/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import java.util.Iterator;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.Segments;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;

public class Segment<ChildType extends Segment<?>> {
    private int offset;
    private int length;
    private Attributes attributes;
    private Segments<ChildType> children = new Segments();
    private Segment<?> parent;

    public Segment(int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.offset = offset;
        this.length = length;
    }

    public Segment(Attributes attributes, int offset, int length) {
        this(offset, length);
        this.attributes = attributes;
    }

    public int getEndOffset() {
        return this.offset + this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.length = length;
        if (!this.children.isEmpty()) {
            int endOffset = this.getEndOffset();
            Iterator<ChildType> childIt = this.children.asList().iterator();
            while (childIt.hasNext()) {
                Segment child = (Segment)childIt.next();
                if (child.getOffset() >= endOffset) {
                    childIt.remove();
                    continue;
                }
                if (child.getEndOffset() <= endOffset) continue;
                int newChildLength = endOffset - child.getOffset();
                child.setLength(newChildLength);
            }
        }
    }

    public void add(ChildType child) {
        if (((Segment)child).getOffset() < this.offset) {
            throw new IllegalArgumentException();
        }
        if (((Segment)child).getEndOffset() > this.getEndOffset()) {
            throw new IllegalArgumentException();
        }
        this.children.add(child);
        ((Segment)child).setParent(this);
    }

    public Segment<?> getParent() {
        return this.parent;
    }

    public Segments<ChildType> getChildren() {
        return this.children;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public void replaceChildren(Segment<?> s) {
        this.children = s.children;
        if (this.children != null) {
            for (Segment child : this.children.asList()) {
                child.setParent(this);
            }
        }
        s.children = null;
    }

    void setParent(Segment<?> parent) {
        this.parent = parent;
    }
}

