/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.apidocs;

import com.google.common.base.Optional;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.apidocs.MethodSelfcallDirectives;
import org.eclipse.recommenders.models.IInputStreamTransformer;
import org.eclipse.recommenders.models.IModelProvider;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Openable;
import org.eclipse.recommenders.utils.Zips;
import org.eclipse.recommenders.utils.gson.GsonUtil;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class SingleZipMethodSelfCallsModelProvider
implements IModelProvider<IUniqueName<IMethodName>, MethodSelfcallDirectives>,
Openable {
    private final File models;
    private final Map<String, IInputStreamTransformer> transformers;
    private ZipFile zip;

    public SingleZipMethodSelfCallsModelProvider(File models, Map<String, IInputStreamTransformer> transformers) {
        this.models = models;
        this.transformers = transformers;
    }

    public void open() throws IOException {
        Zips.readFully((File)this.models);
        this.zip = new ZipFile(this.models);
    }

    public void close() throws IOException {
        Zips.closeQuietly((ZipFile)this.zip);
    }

    public Set<ITypeName> acquireableTypes() {
        Set acquireableTypesSet = Zips.types(this.zip.entries(), (String)".json");
        for (Map.Entry<String, IInputStreamTransformer> transformer : this.transformers.entrySet()) {
            acquireableTypesSet.addAll(Zips.types(this.zip.entries(), (String)(".json." + transformer.getKey())));
        }
        return acquireableTypesSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<MethodSelfcallDirectives> acquireModel(IUniqueName<IMethodName> key) {
        InputStream in = null;
        try {
            String basePath = Zips.path((IMethodName)((IMethodName)key.getName()), (String)".json");
            in = (InputStream)this.getInputStream(this.zip, basePath).orNull();
            if (in == null) {
                Optional optional = Optional.absent();
                IOUtils.closeQuietly((Closeable)in);
                return optional;
            }
            MethodSelfcallDirectives res = (MethodSelfcallDirectives)GsonUtil.deserialize((InputStream)in, MethodSelfcallDirectives.class);
            Optional optional = Optional.of((Object)res);
            IOUtils.closeQuietly((Closeable)in);
            return optional;
        }
        catch (IOException iOException) {
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    private Optional<InputStream> getInputStream(ZipFile zip, String basePath) throws IOException {
        for (Map.Entry<String, IInputStreamTransformer> transformer : this.transformers.entrySet()) {
            ZipEntry toTransform = zip.getEntry(String.valueOf(basePath) + "." + transformer.getKey());
            if (toTransform == null) continue;
            return Optional.of((Object)transformer.getValue().transform(zip.getInputStream(toTransform)));
        }
        ZipEntry entry = zip.getEntry(basePath);
        if (entry == null) {
            return Optional.absent();
        }
        return Optional.of((Object)zip.getInputStream(entry));
    }

    public void releaseModel(MethodSelfcallDirectives value) {
    }
}

