/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import java.util.Collection;
import java.util.List;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.node.AbstractNode;
import org.eclipse.jpt.common.utility.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NewNameStateObject
extends AbstractNode {
    private String name;
    private Collection<String> names;
    private Node.Validator validator;
    static final String NAME_PROPERTY = "name";

    NewNameStateObject(String name, Collection<String> names) {
        super(null);
        this.name = name;
        this.names = names;
    }

    private void addNameProblems(List<Node.Problem> currentProblems) {
        if (StringTools.isBlank((String)this.name)) {
            currentProblems.add(this.buildProblem(JptCommonUiMessages.NEW_NAME_STATE_OBJECT__NAME_MUST_BE_SPECIFIED, 3));
        } else if (this.names.contains(this.name.trim())) {
            currentProblems.add(this.buildProblem(JptCommonUiMessages.NEW_NAME_STATE_OBJECT__NAME_ALREADY_EXISTS, 3));
        }
    }

    protected void addProblemsTo(List<Node.Problem> currentProblems) {
        super.addProblemsTo(currentProblems);
        this.addNameProblems(currentProblems);
    }

    protected void checkParent(Node parentNode) {
    }

    public String displayString() {
        return null;
    }

    String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, oldName, name);
    }

    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    public Node.Validator getValidator() {
        return this.validator;
    }
}

