/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.WTPResourcesNode;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WTPResourcesContentProvider
extends BaseWorkbenchContentProvider
implements IPipelinedTreeContentProvider {
    private static final Logger LOG = LoggerFactory.getLogger(WTPResourcesContentProvider.class);

    public void init(ICommonContentExtensionSite config) {
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public Object[] getChildren(Object element) {
        if (element instanceof WTPResourcesNode) {
            return ((WTPResourcesNode)element).getResources();
        }
        return super.getChildren(element);
    }

    public void getPipelinedElements(Object element, Set currentElements) {
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        IProject project;
        if (parent instanceof IProject && (project = (IProject)parent).isAccessible()) {
            try {
                if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                    return;
                }
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null && (facetedProject.hasProjectFacet(WTPProjectsUtil.DYNAMIC_WEB_FACET) || facetedProject.hasProjectFacet(WTPProjectsUtil.EAR_FACET))) {
                    ArrayList<WTPResourcesNode> newChildren = new ArrayList<WTPResourcesNode>(currentChildren.size() + 1);
                    newChildren.add(new WTPResourcesNode(project));
                    newChildren.addAll(currentChildren);
                    currentChildren.clear();
                    currentChildren.addAll(newChildren);
                }
            }
            catch (CoreException ex) {
                LOG.error(Messages.WTPResourcesContentProvider_Error_Getting_Pipelined_Children, (Throwable)ex);
            }
        }
    }

    public Object getPipelinedParent(Object element, Object suggestedParent) {
        return suggestedParent;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        return false;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate updateSynchronization) {
        return false;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification addModification) {
        return addModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification removeModification) {
        return removeModification;
    }
}

