/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.wtp.AbstractDependencyConfigurator;
import org.eclipse.m2e.wtp.AbstractProjectConfiguratorDelegate;
import org.eclipse.m2e.wtp.ArtifactHelper;
import org.eclipse.m2e.wtp.MarkedException;
import org.eclipse.m2e.wtp.MavenWtpPlugin;
import org.eclipse.m2e.wtp.PackagingConfiguration;
import org.eclipse.m2e.wtp.ResourceCleaner;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.m2e.wtp.internal.ExtensionReader;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.filtering.WebResourceFilteringConfiguration;
import org.eclipse.m2e.wtp.namemapping.FileNameMapping;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

class WebProjectConfiguratorDelegate
extends AbstractProjectConfiguratorDelegate {
    static final IClasspathAttribute DEPENDENCY_ATTRIBUTE = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)"/WEB-INF/lib");
    private static final String M2ECLIPSE_WTP_CONTEXT_ROOT = "m2eclipse.wtp.contextRoot";

    WebProjectConfiguratorDelegate() {
    }

    @Override
    protected void configure(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project.getFile("pom.xml"), true, monitor);
        WarPluginConfiguration config = new WarPluginConfiguration(mavenProject, project);
        String warSourceDirectory = config.getWarSourceDirectory();
        IFolder contentFolder = project.getFolder(warSourceDirectory);
        LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
        this.installJavaFacet(actions, project, facetedProject);
        IVirtualComponent component = ComponentCore.createComponent((IProject)project, (boolean)true);
        String contextRoot = this.getContextRoot(mavenProject, config.getWarName());
        IProjectFacetVersion webFv = config.getWebFacetVersion(project);
        IDataModel webModelCfg = this.getWebModelConfig(warSourceDirectory, contextRoot);
        if (!facetedProject.hasProjectFacet(WebFacetUtils.WEB_FACET)) {
            WTPProjectsUtil.removeConflictingFacets(facetedProject, webFv, actions);
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, webFv, (Object)webModelCfg));
        } else {
            IProjectFacetVersion projectFacetVersion = facetedProject.getProjectFacetVersion(WebFacetUtils.WEB_FACET);
            if (webFv.getVersionString() != null && !webFv.getVersionString().equals(projectFacetVersion.getVersionString())) {
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, webFv, (Object)webModelCfg));
            }
        }
        String customWebXml = config.getCustomWebXml(project);
        if (!actions.isEmpty()) {
            ResourceCleaner fileCleaner = new ResourceCleaner(project, contentFolder);
            try {
                this.addFoldersToClean(fileCleaner, facade);
                fileCleaner.addFiles(contentFolder.getFile("META-INF/MANIFEST.MF").getProjectRelativePath());
                fileCleaner.addFolder(contentFolder.getFolder("WEB-INF/lib"));
                if (customWebXml != null) {
                    fileCleaner.addFiles(contentFolder.getFile("WEB-INF/web.xml").getProjectRelativePath());
                }
                facetedProject.modify(actions, monitor);
            }
            finally {
                fileCleaner.cleanUp();
            }
        }
        this.fixMissingModuleCoreNature(project, monitor);
        this.removeTestFolderLinks(project, mavenProject, monitor, "/WEB-INF/classes");
        this.addContainerAttribute(project, DEPENDENCY_ATTRIBUTE, monitor);
        if (!contextRoot.equals(J2EEProjectUtilities.getServerContextRoot((IProject)project))) {
            J2EEProjectUtilities.setServerContextRoot((IProject)project, (String)contextRoot);
        }
        if (customWebXml != null) {
            this.linkFileFirst(project, customWebXml, "/WEB-INF/web.xml", monitor);
        }
        if ((component = ComponentCore.createComponent((IProject)project, (boolean)true)) != null) {
            boolean useWebresourcefiltering;
            IPath currentDefaultLocation;
            IVirtualFolder rootFolder = component.getRootFolder();
            IPath warPath = new Path("/").append(contentFolder.getProjectRelativePath());
            boolean warPathExists = WTPProjectsUtil.hasLink(project, ROOT_PATH, warPath, monitor);
            if (!warPathExists) {
                component.getRootFolder().createLink(warPath, 0, monitor);
            }
            if ((currentDefaultLocation = J2EEModuleVirtualComponent.getDefaultDeploymentDescriptorFolder((IVirtualFolder)rootFolder)) == null) {
                WTPProjectsUtil.setDefaultDeploymentDescriptorFolder(rootFolder, warPath, monitor);
            }
            IPath filteredFolder = new Path("/").append(WebResourceFilteringConfiguration.getTargetFolder(mavenProject, project));
            boolean useBuildDir = MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager().getPreferences(project).isWebMavenArchiverUsesBuildDirectory();
            boolean bl = useWebresourcefiltering = config.getWebResources() != null && config.getWebResources().length > 0 || config.isFilteringDeploymentDescriptorsEnabled();
            if (useBuildDir || useWebresourcefiltering) {
                if (!useBuildDir && useWebresourcefiltering) {
                    this.mavenMarkerManager.addMarker((IResource)project, "org.eclipse.m2e.core.maven2Problem.wtp.configuration", Messages.markers_mavenarchiver_output_settings_ignored_warning, -1, 1);
                }
                if (!WTPProjectsUtil.hasLink(project, ROOT_PATH, filteredFolder, monitor)) {
                    WTPProjectsUtil.insertLinkBefore(project, filteredFolder, warPath, ROOT_PATH, monitor);
                }
            } else {
                component.getRootFolder().removeLink(filteredFolder, 0, monitor);
            }
            this.addComponentExclusionPatterns(component, config);
        }
        WTPProjectsUtil.removeWTPClasspathContainer(project);
        this.setModuleDependencies(project, mavenProject, monitor);
    }

    private IDataModel getWebModelConfig(String warSourceDirectory, String contextRoot) {
        IDataModel webModelCfg = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetInstallDataModelProvider());
        webModelCfg.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)warSourceDirectory);
        webModelCfg.setProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", (Object)contextRoot);
        webModelCfg.setProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", (Object)false);
        webModelCfg.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        return webModelCfg;
    }

    @Override
    public void setModuleDependencies(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        IVirtualReference[] newRefs;
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project, (boolean)true);
        if (component == null) {
            return;
        }
        this.fixMissingModuleCoreNature(project, monitor);
        WarPluginConfiguration config = new WarPluginConfiguration(mavenProject, project);
        Map<Artifact, String> deployedArtifacts = this.getDeployedArtifacts(mavenProject.getArtifacts(), config);
        List<AbstractDependencyConfigurator> depConfigurators = ExtensionReader.readDependencyConfiguratorExtensions(this.projectManager, MavenPlugin.getMavenRuntimeManager(), this.mavenMarkerManager);
        LinkedHashSet<IVirtualReference> references = new LinkedHashSet<IVirtualReference>();
        List<IMavenProjectFacade> exportedDependencies = this.getWorkspaceDependencies(project, mavenProject);
        for (IMavenProjectFacade dependency : exportedDependencies) {
            String deployedName;
            String depPackaging = dependency.getPackaging();
            if ("pom".equals(depPackaging) || "war".equals(depPackaging) || "zip".equals(depPackaging)) continue;
            this.preConfigureDependencyProject(dependency, monitor);
            if (!ModuleCoreNature.isFlexibleProject((IProject)dependency.getProject())) continue;
            MavenProject depMavenProject = dependency.getMavenProject(monitor);
            IVirtualComponent depComponent = ComponentCore.createComponent((IProject)dependency.getProject());
            ArtifactKey artifactKey = ArtifactHelper.toArtifactKey(depMavenProject.getArtifact());
            Artifact artifact = ArtifactHelper.getArtifact(mavenProject.getArtifacts(), artifactKey);
            if (artifact == null) {
                artifact = depMavenProject.getArtifact();
            }
            if ((deployedName = deployedArtifacts.get(artifact)) == null) continue;
            IVirtualReference reference = ComponentCore.createReference((IVirtualComponent)component, (IVirtualComponent)depComponent);
            Path path = new Path("/WEB-INF/lib");
            reference.setArchiveName(deployedName);
            reference.setRuntimePath((IPath)path);
            references.add(reference);
        }
        IVirtualReference[] oldRefs = WTPProjectsUtil.extractHardReferences(component, false);
        if (WTPProjectsUtil.hasChanged(oldRefs, newRefs = references.toArray(new IVirtualReference[references.size()]))) {
            IVirtualReference[] overlayRefs = WTPProjectsUtil.extractHardReferences(component, true);
            IVirtualReference[] allRefs = new IVirtualReference[overlayRefs.length + newRefs.length];
            System.arraycopy(newRefs, 0, allRefs, 0, newRefs.length);
            System.arraycopy(overlayRefs, 0, allRefs, newRefs.length, overlayRefs.length);
            component.setReferences(allRefs);
        }
        for (IMavenProjectFacade dependency : exportedDependencies) {
            MavenProject depMavenProject = dependency.getMavenProject(monitor);
            Iterator<AbstractDependencyConfigurator> configurators = depConfigurators.iterator();
            while (configurators.hasNext()) {
                try {
                    configurators.next().configureDependency(mavenProject, project, depMavenProject, dependency.getProject(), monitor);
                }
                catch (MarkedException markedException) {}
            }
        }
    }

    protected String getContextRoot(MavenProject mavenProject, String warName) {
        String finalName;
        String property = mavenProject.getProperties().getProperty(M2ECLIPSE_WTP_CONTEXT_ROOT);
        String contextRoot = StringUtils.isBlank((String)property) ? (StringUtils.isBlank((String)(finalName = warName)) || finalName.equals(String.valueOf(mavenProject.getArtifactId()) + "-" + mavenProject.getVersion()) ? mavenProject.getArtifactId() : finalName) : property;
        return contextRoot.trim().replace(" ", "_");
    }

    @Override
    public void configureClasspath(IProject project, MavenProject mavenProject, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        WarPluginConfiguration config = new WarPluginConfiguration(mavenProject, project);
        Set artifacts = mavenProject.getArtifacts();
        Map<Artifact, String> deployedArtifacts = this.getDeployedArtifacts(artifacts, config);
        for (IClasspathEntryDescriptor descriptor : classpath.getEntryDescriptors()) {
            Artifact artifact = ArtifactHelper.getArtifact(artifacts, descriptor.getArtifactKey());
            if (artifact == null) {
                return;
            }
            String deployedName = deployedArtifacts.get(artifact);
            if (deployedName == null || this.isWorkspaceProject(artifact)) {
                descriptor.setClasspathAttribute(NONDEPENDENCY_ATTRIBUTE.getName(), NONDEPENDENCY_ATTRIBUTE.getValue());
                continue;
            }
            descriptor.getClasspathAttributes().put("org.eclipse.jst.component.archivename", deployedName);
        }
    }

    private boolean isWorkspaceProject(Artifact artifact) {
        IMavenProjectFacade facade = this.projectManager.getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        return facade != null && facade.getFullPath(artifact.getFile()) != null;
    }

    private Map<Artifact, String> getDeployedArtifacts(Collection<Artifact> artifacts, WarPluginConfiguration config) {
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.emptyMap();
        }
        int size = artifacts.size();
        LinkedHashMap<Artifact, String> artifactsMap = new LinkedHashMap<Artifact, String>(size);
        PackagingConfiguration opts = new PackagingConfiguration(config.getPackagingIncludes(), config.getPackagingExcludes());
        FileNameMapping fileNameMapping = config.getFileNameMapping();
        HashSet<String> names = new HashSet<String>(size);
        HashSet<String> duplicates = new HashSet<String>(size);
        for (Artifact artifact : artifacts) {
            boolean isDeployed;
            ArtifactHelper.fixArtifactHandler(artifact.getArtifactHandler());
            String string = fileNameMapping.mapFileName(artifact);
            String scope = artifact.getScope();
            boolean bl = isDeployed = ("compile".equals(scope) || "runtime".equals(scope)) && !artifact.isOptional() && opts.isPackaged("WEB-INF/lib/" + string);
            if (!isDeployed) continue;
            if (!names.add(string)) {
                duplicates.add(string);
            }
            artifactsMap.put(artifact, string);
        }
        for (String name : duplicates) {
            for (Map.Entry entry : artifactsMap.entrySet()) {
                if (!name.equals(entry.getValue())) continue;
                String newDeployedName = String.valueOf(((Artifact)entry.getKey()).getGroupId()) + "-" + name;
                entry.setValue(newDeployedName);
            }
        }
        return artifactsMap;
    }
}

