/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.rs.features.FeatureSet;
import org.eclipse.persistence.jpa.rs.features.FeatureSetPreV2;
import org.eclipse.persistence.jpa.rs.features.FeatureSetV2;

public enum ServiceVersion {
    NO_VERSION(null),
    VERSION_1_0("v1.0"),
    VERSION_2_0("v2.0");

    public static final String LATEST_VERSION = "latest";
    private final String version;
    private static final Map<String, ServiceVersion> values;

    static {
        values = new HashMap<String, ServiceVersion>();
        ServiceVersion[] serviceVersionArray = ServiceVersion.values();
        int n = serviceVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceVersion e = serviceVersionArray[n2];
            values.put(e.getCode(), e);
            ++n2;
        }
    }

    private ServiceVersion(String version) {
        this.version = version;
    }

    public String getCode() {
        return this.version;
    }

    public static ServiceVersion fromCode(String version) throws IllegalArgumentException {
        if (version != null && version.equalsIgnoreCase(LATEST_VERSION)) {
            return VERSION_2_0;
        }
        ServiceVersion e = values.get(version);
        if (e == null) {
            throw new IllegalArgumentException("Unsupported version " + version);
        }
        return e;
    }

    public FeatureSet getFeatureSet() {
        if (this.equals((Object)VERSION_2_0)) {
            return new FeatureSetV2();
        }
        return new FeatureSetPreV2();
    }

    public static boolean hasCode(String code) {
        return values.containsKey(code);
    }
}

