/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.ExclusivePositionUpdater;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IndentUtil;
import org.eclipse.wst.jsdt.internal.ui.text.FastJavaPartitionScanner;

public class JavaFormatter {
    private static final String COMMENT_START = "/*-";
    private static final String COMMENT_END = "*/";
    private final String fLineDelimiter;
    private final int fInitialIndentLevel;
    private boolean fUseCodeFormatter;
    private final IJavaScriptProject fProject;

    public JavaFormatter(String lineDelimiter, int initialIndentLevel, boolean useCodeFormatter, IJavaScriptProject project) {
        this.fLineDelimiter = lineDelimiter;
        this.fUseCodeFormatter = useCodeFormatter;
        this.fInitialIndentLevel = initialIndentLevel;
        this.fProject = project;
    }

    public void format(TemplateBuffer buffer, TemplateContext context) throws BadLocationException {
        try {
            VariableTracker tracker = new VariableTracker(buffer);
            IDocument document = tracker.getDocument();
            this.internalFormat(document, context);
            this.convertLineDelimiters(document);
            if (!this.isReplacedAreaEmpty(context)) {
                this.trimStart(document);
            }
            tracker.updateBuffer();
        }
        catch (MalformedTreeException malformedTreeException) {
            throw new BadLocationException();
        }
    }

    private void internalFormat(IDocument document, TemplateContext context) throws BadLocationException {
        if (this.fUseCodeFormatter) {
            try {
                this.format(document, (CompilationUnitContext)context);
                return;
            }
            catch (BadLocationException badLocationException) {
            }
            catch (MalformedTreeException malformedTreeException) {}
        }
        this.indent(document);
    }

    private void convertLineDelimiters(IDocument document) throws BadLocationException {
        int lines = document.getNumberOfLines();
        int line = 0;
        while (line < lines) {
            IRegion region = document.getLineInformation(line);
            String lineDelimiter = document.getLineDelimiter(line);
            if (lineDelimiter != null) {
                document.replace(region.getOffset() + region.getLength(), lineDelimiter.length(), this.fLineDelimiter);
            }
            ++line;
        }
    }

    private void trimStart(IDocument document) throws BadLocationException {
        int i = 0;
        while (i != document.getLength() && Character.isWhitespace(document.getChar(i))) {
            ++i;
        }
        document.replace(0, i, "");
    }

    private boolean isReplacedAreaEmpty(TemplateContext context) {
        DocumentTemplateContext dtc;
        if (context instanceof DocumentTemplateContext && (dtc = (DocumentTemplateContext)context).getStart() == dtc.getCompletionOffset()) {
            try {
                if (dtc.getDocument().get(dtc.getStart(), dtc.getEnd() - dtc.getStart()).trim().length() == 0) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }
        return false;
    }

    private void format(IDocument doc, CompilationUnitContext context) throws BadLocationException {
        IJavaScriptProject project = context.getJavaProject();
        Map options = project != null ? project.getOptions(true) : JavaScriptCore.getOptions();
        String contents = doc.get();
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        int[] kinds = nArray;
        TextEdit edit = null;
        int i = 0;
        while (i < kinds.length && edit == null) {
            edit = CodeFormatterUtil.format2(kinds[i], contents, this.fInitialIndentLevel, this.fLineDelimiter, options);
            ++i;
        }
        if (edit == null) {
            throw new BadLocationException();
        }
        edit.apply(doc, 2);
    }

    private void indent(IDocument document) throws BadLocationException, MalformedTreeException {
        int offset = document.getLineOffset(0);
        document.replace(offset, 0, CodeFormatterUtil.createIndentString(this.fInitialIndentLevel, this.fProject));
        int lineCount = document.getNumberOfLines();
        IndentUtil.indentLines(document, (ILineRange)new LineRange(1, lineCount - 1), this.fProject, null);
    }

    private static final class VariableTracker {
        private static final String CATEGORY = "__template_variables";
        private Document fDocument;
        private final TemplateBuffer fBuffer;
        private List fPositions;

        public VariableTracker(TemplateBuffer buffer) throws MalformedTreeException, BadLocationException {
            Assert.isLegal((buffer != null ? 1 : 0) != 0);
            this.fBuffer = buffer;
            this.fDocument = new Document(this.fBuffer.getString());
            VariableTracker.installJavaStuff(this.fDocument);
            this.fDocument.addPositionCategory(CATEGORY);
            this.fDocument.addPositionUpdater((IPositionUpdater)new ExclusivePositionUpdater(CATEGORY));
            this.fPositions = this.createRangeMarkers(this.fBuffer.getVariables(), (IDocument)this.fDocument);
        }

        private static void installJavaStuff(Document document) {
            String[] types = new String[]{"__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character", "__dftl_partition_content_type"};
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new FastJavaPartitionScanner(), types);
            partitioner.connect((IDocument)document);
            document.setDocumentPartitioner("___java_partitioning", (IDocumentPartitioner)partitioner);
        }

        public IDocument getDocument() {
            this.checkState();
            return this.fDocument;
        }

        private void checkState() {
            if (this.fDocument == null) {
                throw new IllegalStateException();
            }
        }

        public TemplateBuffer updateBuffer() throws MalformedTreeException, BadLocationException {
            this.checkState();
            TemplateVariable[] variables = this.fBuffer.getVariables();
            try {
                this.removeRangeMarkers(this.fPositions, (IDocument)this.fDocument, variables);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                Assert.isTrue((boolean)false);
            }
            this.fBuffer.setContent(this.fDocument.get(), variables);
            this.fDocument = null;
            return this.fBuffer;
        }

        private List createRangeMarkers(TemplateVariable[] variables, IDocument document) throws MalformedTreeException, BadLocationException {
            HashMap<ReplaceEdit, String> markerToOriginal = new HashMap<ReplaceEdit, String>();
            MultiTextEdit root = new MultiTextEdit(0, document.getLength());
            ArrayList<Object> edits = new ArrayList<Object>();
            boolean hasModifications = false;
            int i = 0;
            while (i != variables.length) {
                TemplateVariable variable = variables[i];
                int[] nArray = variable.getOffsets();
                String value = variable.getDefaultValue();
                if (this.isWhitespaceVariable(value)) {
                    String placeholder = JavaFormatter.COMMENT_START + value + JavaFormatter.COMMENT_END;
                    int j = 0;
                    while (j != nArray.length) {
                        ReplaceEdit replace = new ReplaceEdit(nArray[j], value.length(), placeholder);
                        root.addChild((TextEdit)replace);
                        hasModifications = true;
                        markerToOriginal.put(replace, value);
                        edits.add(replace);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j != nArray.length) {
                        RangeMarker marker = new RangeMarker(nArray[j], value.length());
                        root.addChild((TextEdit)marker);
                        edits.add(marker);
                        ++j;
                    }
                }
                ++i;
            }
            if (hasModifications) {
                root.apply(document, 2);
            }
            ArrayList<TypedPosition> positions = new ArrayList<TypedPosition>();
            for (TextEdit textEdit : edits) {
                try {
                    TypedPosition pos = new TypedPosition(textEdit.getOffset(), textEdit.getLength(), (String)markerToOriginal.get(textEdit));
                    document.addPosition(CATEGORY, (Position)pos);
                    positions.add(pos);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    Assert.isTrue((boolean)false);
                }
            }
            return positions;
        }

        private boolean isWhitespaceVariable(String value) {
            int length = value.length();
            return length == 0 || Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(length - 1));
        }

        private void removeRangeMarkers(List positions, IDocument document, TemplateVariable[] variables) throws MalformedTreeException, BadLocationException, BadPositionCategoryException {
            for (TypedPosition position : positions) {
                document.removePosition(CATEGORY, (Position)position);
                String original = position.getType();
                if (original != null) {
                    document.replace(position.getOffset(), position.getLength(), original);
                    position.setLength(original.length());
                }
                document.addPosition((Position)position);
            }
            Iterator it = positions.iterator();
            int i = 0;
            while (i != variables.length) {
                TemplateVariable variable = variables[i];
                int[] offsets = new int[variable.getOffsets().length];
                int j = 0;
                while (j != offsets.length) {
                    offsets[j] = ((Position)it.next()).getOffset();
                    ++j;
                }
                variable.setOffsets(offsets);
                ++i;
            }
        }
    }
}

