/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModel
implements Model {
    protected final ChangeSupport changeSupport = this.buildChangeSupport();

    protected AbstractModel() {
    }

    protected ChangeSupport buildChangeSupport() {
        return new ChangeSupport(this);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public boolean hasAnyChangeListeners() {
        return this.changeSupport != null && this.changeSupport.hasAnyChangeListeners();
    }

    public boolean hasNoChangeListeners() {
        return !this.hasAnyChangeListeners();
    }

    @Override
    public void addStateChangeListener(StateChangeListener listener) {
        this.changeSupport.addStateChangeListener(listener);
    }

    @Override
    public void removeStateChangeListener(StateChangeListener listener) {
        this.changeSupport.removeStateChangeListener(listener);
    }

    public boolean hasAnyStateChangeListeners() {
        return this.changeSupport != null && this.changeSupport.hasAnyStateChangeListeners();
    }

    public boolean hasNoStateChangeListeners() {
        return !this.hasAnyStateChangeListeners();
    }

    protected final void fireStateChanged(StateChangeEvent event) {
        this.changeSupport.fireStateChanged(event);
    }

    protected final void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public boolean hasAnyPropertyChangeListeners(String propertyName) {
        return this.changeSupport != null && this.changeSupport.hasAnyPropertyChangeListeners(propertyName);
    }

    public boolean hasNoPropertyChangeListeners(String propertyName) {
        return !this.hasAnyPropertyChangeListeners(propertyName);
    }

    protected final boolean firePropertyChanged(PropertyChangeEvent event) {
        return this.changeSupport.firePropertyChanged(event);
    }

    protected final boolean firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        return this.changeSupport.firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final boolean firePropertyChanged(String propertyName, int oldValue, int newValue) {
        return this.changeSupport.firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final boolean firePropertyChanged(String propertyName, boolean oldValue, boolean newValue) {
        return this.changeSupport.firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final boolean firePropertyChanged(String propertyName, Object newValue) {
        return this.firePropertyChanged(propertyName, null, newValue);
    }

    @Override
    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.changeSupport.addCollectionChangeListener(collectionName, listener);
    }

    @Override
    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.changeSupport.removeCollectionChangeListener(collectionName, listener);
    }

    public boolean hasAnyCollectionChangeListeners(String collectionName) {
        return this.changeSupport != null && this.changeSupport.hasAnyCollectionChangeListeners(collectionName);
    }

    public boolean hasNoCollectionChangeListeners(String collectionName) {
        return !this.hasAnyCollectionChangeListeners(collectionName);
    }

    protected final boolean fireItemsAdded(CollectionAddEvent event) {
        return this.changeSupport.fireItemsAdded(event);
    }

    protected final boolean fireItemsAdded(String collectionName, Collection<?> addedItems) {
        return this.changeSupport.fireItemsAdded(collectionName, addedItems);
    }

    protected final void fireItemAdded(String collectionName, Object addedItem) {
        this.changeSupport.fireItemAdded(collectionName, addedItem);
    }

    protected final boolean fireItemsRemoved(CollectionRemoveEvent event) {
        return this.changeSupport.fireItemsRemoved(event);
    }

    protected final boolean fireItemsRemoved(String collectionName, Collection<?> removedItems) {
        return this.changeSupport.fireItemsRemoved(collectionName, removedItems);
    }

    protected final void fireItemRemoved(String collectionName, Object removedItem) {
        this.changeSupport.fireItemRemoved(collectionName, removedItem);
    }

    protected final void fireCollectionCleared(CollectionClearEvent event) {
        this.changeSupport.fireCollectionCleared(event);
    }

    protected final void fireCollectionCleared(String collectionName) {
        this.changeSupport.fireCollectionCleared(collectionName);
    }

    protected final void fireCollectionChanged(CollectionChangeEvent event) {
        this.changeSupport.fireCollectionChanged(event);
    }

    protected final void fireCollectionChanged(String collectionName, Collection<?> collection) {
        this.changeSupport.fireCollectionChanged(collectionName, collection);
    }

    protected <E> boolean addItemToCollection(E item, Collection<E> collection, String collectionName) {
        return this.changeSupport.addItemToCollection(item, collection, collectionName);
    }

    protected <E> boolean addItemsToCollection(E[] items, Collection<E> collection, String collectionName) {
        return this.changeSupport.addItemsToCollection(items, collection, collectionName);
    }

    protected <E> boolean addItemsToCollection(Collection<? extends E> items, Collection<E> collection, String collectionName) {
        return this.changeSupport.addItemsToCollection(items, collection, collectionName);
    }

    protected <E> boolean addItemsToCollection(Iterable<? extends E> items, Collection<E> collection, String collectionName) {
        return this.changeSupport.addItemsToCollection(items, collection, collectionName);
    }

    protected <E> boolean addItemsToCollection(Iterator<? extends E> items, Collection<E> collection, String collectionName) {
        return this.changeSupport.addItemsToCollection(items, collection, collectionName);
    }

    protected boolean removeItemFromCollection(Object item, Collection<?> collection, String collectionName) {
        return this.changeSupport.removeItemFromCollection(item, collection, collectionName);
    }

    protected boolean removeItemsFromCollection(Object[] items, Collection<?> collection, String collectionName) {
        return this.changeSupport.removeItemsFromCollection(items, collection, collectionName);
    }

    protected boolean removeItemsFromCollection(Collection<?> items, Collection<?> collection, String collectionName) {
        return this.changeSupport.removeItemsFromCollection(items, collection, collectionName);
    }

    protected boolean removeItemsFromCollection(Iterable<?> items, Collection<?> collection, String collectionName) {
        return this.changeSupport.removeItemsFromCollection(items, collection, collectionName);
    }

    protected boolean removeItemsFromCollection(Iterator<?> items, Collection<?> collection, String collectionName) {
        return this.changeSupport.removeItemsFromCollection(items, collection, collectionName);
    }

    protected boolean retainItemsInCollection(Object[] items, Collection<?> collection, String collectionName) {
        return this.changeSupport.retainItemsInCollection(items, collection, collectionName);
    }

    protected boolean retainItemsInCollection(Collection<?> items, Collection<?> collection, String collectionName) {
        return this.changeSupport.retainItemsInCollection(items, collection, collectionName);
    }

    protected boolean retainItemsInCollection(Iterable<?> items, Collection<?> collection, String collectionName) {
        return this.changeSupport.retainItemsInCollection(items, collection, collectionName);
    }

    protected boolean retainItemsInCollection(Iterator<?> items, Collection<?> collection, String collectionName) {
        return this.changeSupport.retainItemsInCollection(items, collection, collectionName);
    }

    protected boolean clearCollection(Collection<?> collection, String collectionName) {
        return this.changeSupport.clearCollection(collection, collectionName);
    }

    protected <E> boolean synchronizeCollection(Collection<E> newCollection, Collection<E> collection, String collectionName) {
        return this.changeSupport.synchronizeCollection(newCollection, collection, collectionName);
    }

    protected <E> boolean synchronizeCollection(Iterable<E> newCollection, Collection<E> collection, String collectionName) {
        return this.changeSupport.synchronizeCollection(newCollection, collection, collectionName);
    }

    protected <E> boolean synchronizeCollection(Iterator<E> newCollection, Collection<E> collection, String collectionName) {
        return this.changeSupport.synchronizeCollection(newCollection, collection, collectionName);
    }

    @Override
    public void addListChangeListener(String listName, ListChangeListener listener) {
        this.changeSupport.addListChangeListener(listName, listener);
    }

    @Override
    public void removeListChangeListener(String listName, ListChangeListener listener) {
        this.changeSupport.removeListChangeListener(listName, listener);
    }

    public boolean hasAnyListChangeListeners(String listName) {
        return this.changeSupport != null && this.changeSupport.hasAnyListChangeListeners(listName);
    }

    public boolean hasNoListChangeListeners(String listName) {
        return !this.hasAnyListChangeListeners(listName);
    }

    protected final boolean fireItemsAdded(ListAddEvent event) {
        return this.changeSupport.fireItemsAdded(event);
    }

    protected final boolean fireItemsAdded(String listName, int index, List<?> addedItems) {
        return this.changeSupport.fireItemsAdded(listName, index, addedItems);
    }

    protected final void fireItemAdded(String listName, int index, Object addedItem) {
        this.changeSupport.fireItemAdded(listName, index, addedItem);
    }

    protected final boolean fireItemsRemoved(ListRemoveEvent event) {
        return this.changeSupport.fireItemsRemoved(event);
    }

    protected final boolean fireItemsRemoved(String listName, int index, List<?> removedItems) {
        return this.changeSupport.fireItemsRemoved(listName, index, removedItems);
    }

    protected final void fireItemRemoved(String listName, int index, Object removedItem) {
        this.changeSupport.fireItemRemoved(listName, index, removedItem);
    }

    protected final boolean fireItemsReplaced(ListReplaceEvent event) {
        return this.changeSupport.fireItemsReplaced(event);
    }

    protected final <E> boolean fireItemsReplaced(String listName, int index, List<? extends E> newItems, List<E> replacedItems) {
        return this.changeSupport.fireItemsReplaced(listName, index, newItems, replacedItems);
    }

    protected final boolean fireItemReplaced(String listName, int index, Object newItem, Object replacedItem) {
        return this.changeSupport.fireItemReplaced(listName, index, newItem, replacedItem);
    }

    protected final boolean fireItemsMoved(ListMoveEvent event) {
        return this.changeSupport.fireItemsMoved(event);
    }

    protected final <E> boolean fireItemsMoved(String listName, int targetIndex, int sourceIndex, int length) {
        return this.changeSupport.fireItemsMoved(listName, targetIndex, sourceIndex, length);
    }

    protected final boolean fireItemMoved(String listName, int targetIndex, int sourceIndex) {
        return this.changeSupport.fireItemMoved(listName, targetIndex, sourceIndex);
    }

    protected final void fireListCleared(ListClearEvent event) {
        this.changeSupport.fireListCleared(event);
    }

    protected final void fireListCleared(String listName) {
        this.changeSupport.fireListCleared(listName);
    }

    protected final void fireListChanged(ListChangeEvent event) {
        this.changeSupport.fireListChanged(event);
    }

    protected final void fireListChanged(String listName, List<?> list) {
        this.changeSupport.fireListChanged(listName, list);
    }

    protected <E> void addItemToList(int index, E item, List<E> list, String listName) {
        this.changeSupport.addItemToList(index, item, list, listName);
    }

    protected <E> boolean addItemToList(E item, List<E> list, String listName) {
        return this.changeSupport.addItemToList(item, list, listName);
    }

    protected <E> boolean addItemsToList(int index, E[] items, List<E> list, String listName) {
        return this.changeSupport.addItemsToList(index, items, list, listName);
    }

    protected <E> boolean addItemsToList(int index, Collection<? extends E> items, List<E> list, String listName) {
        return this.changeSupport.addItemsToList(index, items, list, listName);
    }

    protected <E> boolean addItemsToList(int index, Iterable<? extends E> items, List<E> list, String listName) {
        return this.changeSupport.addItemsToList(index, items, list, listName);
    }

    protected <E> boolean addItemsToList(int index, Iterator<? extends E> items, List<E> list, String listName) {
        return this.changeSupport.addItemsToList(index, items, list, listName);
    }

    protected <E> boolean addItemsToList(E[] items, List<E> list, String listName) {
        return this.changeSupport.addItemsToList(items, list, listName);
    }

    protected <E> boolean addItemsToList(Collection<? extends E> items, List<E> list, String listName) {
        return this.changeSupport.addItemsToList(items, list, listName);
    }

    protected <E> boolean addItemsToList(Iterable<? extends E> items, List<E> list, String listName) {
        return this.changeSupport.addItemsToList(items, list, listName);
    }

    protected <E> boolean addItemsToList(Iterator<? extends E> items, List<E> list, String listName) {
        return this.changeSupport.addItemsToList(items, list, listName);
    }

    protected <E> E removeItemFromList(int index, List<E> list, String listName) {
        return this.changeSupport.removeItemFromList(index, list, listName);
    }

    protected boolean removeItemFromList(Object item, List<?> list, String listName) {
        return this.changeSupport.removeItemFromList(item, list, listName);
    }

    protected <E> List<E> removeRangeFromList(int beginIndex, int endIndex, List<E> list, String listName) {
        return this.changeSupport.removeRangeFromList(beginIndex, endIndex, list, listName);
    }

    protected <E> List<E> removeItemsFromList(int index, List<E> list, String listName) {
        return this.changeSupport.removeItemsFromList(index, list, listName);
    }

    protected <E> List<E> removeItemsFromList(int index, int length, List<E> list, String listName) {
        return this.changeSupport.removeItemsFromList(index, length, list, listName);
    }

    protected boolean removeItemsFromList(Object[] items, List<?> list, String listName) {
        return this.changeSupport.removeItemsFromList(items, list, listName);
    }

    protected boolean removeItemsFromList(Collection<?> items, List<?> list, String listName) {
        return this.changeSupport.removeItemsFromList(items, list, listName);
    }

    protected boolean removeItemsFromList(Iterable<?> items, List<?> list, String listName) {
        return this.changeSupport.removeItemsFromList(items, list, listName);
    }

    protected boolean removeItemsFromList(Iterator<?> items, List<?> list, String listName) {
        return this.changeSupport.removeItemsFromList(items, list, listName);
    }

    protected boolean retainItemsInList(Object[] items, List<?> list, String listName) {
        return this.changeSupport.retainItemsInList(items, list, listName);
    }

    protected boolean retainItemsInList(Collection<?> items, List<?> list, String listName) {
        return this.changeSupport.retainItemsInList(items, list, listName);
    }

    protected boolean retainItemsInList(Iterable<?> items, List<?> list, String listName) {
        return this.changeSupport.retainItemsInList(items, list, listName);
    }

    protected boolean retainItemsInList(Iterator<?> items, List<?> list, String listName) {
        return this.changeSupport.retainItemsInList(items, list, listName);
    }

    protected <E> E setItemInList(int index, E item, List<E> list, String listName) {
        return this.changeSupport.setItemInList(index, item, list, listName);
    }

    protected <E> int replaceItemInList(E oldItem, E newItem, List<E> list, String listName) {
        return this.changeSupport.replaceItemInList(oldItem, newItem, list, listName);
    }

    protected <E> List<E> setItemsInList(int index, E[] items, List<E> list, String listName) {
        return this.changeSupport.setItemsInList(index, items, list, listName);
    }

    protected <E> List<E> setItemsInList(int index, List<? extends E> items, List<E> list, String listName) {
        return this.changeSupport.setItemsInList(index, items, list, listName);
    }

    protected <E> void moveItemsInList(int targetIndex, int sourceIndex, int length, List<E> list, String listName) {
        this.changeSupport.moveItemsInList(targetIndex, sourceIndex, length, list, listName);
    }

    protected <E> void moveItemInList(int targetIndex, int sourceIndex, List<E> list, String listName) {
        this.changeSupport.moveItemInList(targetIndex, sourceIndex, list, listName);
    }

    protected <E> void moveItemInList(int targetIndex, E item, List<E> list, String listName) {
        this.changeSupport.moveItemInList(targetIndex, item, list, listName);
    }

    protected boolean clearList(List<?> list, String listName) {
        return this.changeSupport.clearList(list, listName);
    }

    protected <E> boolean synchronizeList(List<? extends E> newList, List<E> list, String listName) {
        return this.changeSupport.synchronizeList(newList, list, listName);
    }

    protected <E> boolean synchronizeList(Iterable<? extends E> newList, List<E> list, String listName) {
        return this.changeSupport.synchronizeList(newList, list, listName);
    }

    protected <E> boolean synchronizeList(Iterator<? extends E> newList, List<E> list, String listName) {
        return this.changeSupport.synchronizeList(newList, list, listName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, this);
        sb.append('(');
        int len = sb.length();
        this.toString(sb);
        if (sb.length() == len) {
            sb.deleteCharAt(len - 1);
        } else {
            sb.append(')');
        }
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
    }
}

