/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.Association;
import org.eclipse.jpt.common.utility.closure.InterruptibleClosure;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchInterruptibleClosure<A>
implements InterruptibleClosure<A> {
    private final Iterable<Association<Predicate<? super A>, InterruptibleClosure<? super A>>> closures;
    private final InterruptibleClosure<? super A> defaultInterruptibleClosure;

    public SwitchInterruptibleClosure(Iterable<Association<Predicate<? super A>, InterruptibleClosure<? super A>>> closures, InterruptibleClosure<? super A> defaultInterruptibleClosure) {
        if (IterableTools.isOrContainsNull(closures) || defaultInterruptibleClosure == null) {
            throw new NullPointerException();
        }
        this.closures = closures;
        this.defaultInterruptibleClosure = defaultInterruptibleClosure;
    }

    @Override
    public void execute(A argument) throws InterruptedException {
        for (Association<Predicate<A>, InterruptibleClosure<A>> association : this.closures) {
            if (!association.getKey().evaluate(argument)) continue;
            association.getValue().execute(argument);
            return;
        }
        this.defaultInterruptibleClosure.execute(argument);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.closures);
    }
}

