/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.recommenders.internal.models.rcp.l10n.Messages;
import org.eclipse.recommenders.models.DownloadCallback;

public class MultipleDownloadCallback
extends DownloadCallback {
    private final Map<String, IProgressMonitor> downloads = Maps.newHashMap();
    private boolean downloadSucceeded;
    private long lastTransferred;
    private int finishedWorkUnits;
    private final IProgressMonitor monitor;
    private final int maximumNumberOfDownloads;
    private final int workUnitsPerDownloadTask;
    private int workUnitsRemainder;

    public MultipleDownloadCallback(IProgressMonitor monitor, String message, int totalWorkUnits, int maximumNumberOfDownloads) {
        this.monitor = monitor;
        this.maximumNumberOfDownloads = maximumNumberOfDownloads;
        this.workUnitsPerDownloadTask = totalWorkUnits / maximumNumberOfDownloads;
        this.workUnitsRemainder = totalWorkUnits % maximumNumberOfDownloads;
        monitor.beginTask(message, totalWorkUnits);
    }

    public synchronized void downloadInitiated(String path) {
        int workUnits = this.workUnitsPerDownloadTask;
        if (this.workUnitsRemainder >= 1) {
            ++workUnits;
        }
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(this.monitor, workUnits);
        subProgressMonitor.beginTask(path, workUnits);
        this.downloads.put(path, (IProgressMonitor)subProgressMonitor);
        this.lastTransferred = 0L;
        this.finishedWorkUnits = 0;
    }

    public synchronized void downloadProgressed(String path, long transferred, long total) {
        String message;
        IProgressMonitor submonitor = this.downloads.get(path);
        if (total >= transferred) {
            this.handleMonitorWorkForDownloadProgress(transferred, total, submonitor);
            message = this.createProgressMessage(transferred, total);
        } else {
            message = this.createProgressMessage(transferred);
        }
        submonitor.subTask(message);
    }

    private void handleMonitorWorkForDownloadProgress(long transferred, long total, IProgressMonitor submonitor) {
        long newTransferred = transferred - this.lastTransferred;
        this.lastTransferred = transferred;
        int workUnits = this.calculateWorkUnitsForDownloadProgress(newTransferred, total);
        this.finishedWorkUnits += workUnits;
        submonitor.worked(workUnits);
    }

    private String createProgressMessage(long transferred) {
        return MessageFormat.format(Messages.MONITOR_NAME_DOWNLOAD_TRANSFERRED_SIZE, FileUtils.byteCountToDisplaySize((long)transferred));
    }

    private String createProgressMessage(long transferred, long total) {
        return MessageFormat.format(Messages.MONITOR_NAME_DOWNLOAD_TRANSFERRED_TOTAL_SIZE, FileUtils.byteCountToDisplaySize((long)transferred), FileUtils.byteCountToDisplaySize((long)total));
    }

    private int calculateWorkUnitsForDownloadProgress(long newTransferred, long total) {
        double amount = (double)newTransferred / (double)total;
        int workUnits = (int)((double)this.workUnitsPerDownloadTask * amount);
        return workUnits;
    }

    public synchronized void downloadSucceeded(String path) {
        IProgressMonitor submonitor = this.downloads.get(path);
        this.finishMonitorWork(submonitor);
        submonitor.done();
        this.downloadSucceeded = true;
    }

    public synchronized void downloadFailed(String path) {
        IProgressMonitor submonitor = this.downloads.get(path);
        this.finishMonitorWork(submonitor);
        submonitor.done();
    }

    private void finishMonitorWork(IProgressMonitor submonitor) {
        this.workUnfinishedTaskUnits(submonitor);
        if (this.workUnitsRemainder > 0) {
            this.workOneRemainderUnit(submonitor);
        }
    }

    private void workUnfinishedTaskUnits(IProgressMonitor submonitor) {
        int unfinishedWorkUnits = this.workUnitsPerDownloadTask - this.finishedWorkUnits;
        if (unfinishedWorkUnits > 0) {
            submonitor.worked(unfinishedWorkUnits);
        }
    }

    private void workOneRemainderUnit(IProgressMonitor monitor) {
        monitor.worked(1);
        --this.workUnitsRemainder;
    }

    public boolean isDownloadSucceeded() {
        return this.downloadSucceeded;
    }

    public void finish() {
        this.finishWorkForSkippedTasks();
        this.finishWorkForRemainder();
    }

    private void finishWorkForSkippedTasks() {
        int skippedDownloadTasks = this.maximumNumberOfDownloads - this.downloads.size();
        int i = 0;
        while (i < skippedDownloadTasks) {
            this.monitor.worked(this.workUnitsPerDownloadTask);
            ++i;
        }
    }

    private void finishWorkForRemainder() {
        if (this.workUnitsRemainder > 0) {
            this.monitor.worked(this.workUnitsRemainder);
        }
    }
}

