/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.IDependencyListener;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.internal.models.rcp.EclipseModelRepository;
import org.eclipse.recommenders.internal.models.rcp.l10n.Messages;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.models.rcp.actions.TriggerModelDownloadForDependencyInfosAction;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class DependencyOverviewView
extends ViewPart {
    private final EventBus bus;
    private final IDependencyListener dependencyListener;
    private final IProjectCoordinateProvider pcProvider;
    private final IModelIndex modelIndex;
    private final EclipseModelRepository modelRepository;
    private final SharedImages images;
    private final List<String> modelClassifiers;
    private TreeViewer treeViewer;

    @Inject
    public DependencyOverviewView(EventBus workspaceBus, IDependencyListener dependencyListener, IProjectCoordinateProvider pcProvider, IModelIndex modelIndex, EclipseModelRepository modelRepository, SharedImages images, @Named(value="MODEL_CLASSIFIER") ImmutableSet<String> modelClassifiers) {
        this.bus = workspaceBus;
        this.dependencyListener = dependencyListener;
        this.pcProvider = pcProvider;
        this.modelIndex = modelIndex;
        this.modelRepository = modelRepository;
        this.images = images;
        this.modelClassifiers = Lists.newArrayList(modelClassifiers);
        Collections.sort(this.modelClassifiers);
        this.bus.register((Object)this);
    }

    public void createPartControl(Composite parent) {
        Tree dependencyTree = new Tree(parent, 68354);
        dependencyTree.setHeaderVisible(true);
        dependencyTree.setLinesVisible(true);
        this.createColumn(dependencyTree, Messages.COLUMN_LABEL_DEPENDENCY, 400);
        this.createColumn(dependencyTree, Messages.COLUMN_LABEL_PROJECT_COORDINATE, 200);
        for (String classifier : this.modelClassifiers) {
            this.createColumn(dependencyTree, classifier.toUpperCase(), 50);
        }
        this.treeViewer = new TreeViewer(dependencyTree);
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.treeViewer.setSorter(new ViewerSorter());
        this.addContextMenu();
        this.updateContent();
    }

    private void addContextMenu() {
        final MenuManager menuManager = new MenuManager();
        Menu contextMenu = menuManager.createContextMenu((Control)this.treeViewer.getTree());
        menuManager.setRemoveAllWhenShown(true);
        this.treeViewer.getControl().setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)Checks.cast((Object)DependencyOverviewView.this.treeViewer.getSelection());
                Set deps = DependencyOverviewView.this.extractSelectedDependencies(selection);
                if (!deps.isEmpty()) {
                    menuManager.add((IAction)new TriggerModelDownloadForDependencyInfosAction(Messages.MENUITEM_DOWNLOAD_MODELS, deps, DependencyOverviewView.this.modelClassifiers, DependencyOverviewView.this.pcProvider, DependencyOverviewView.this.modelIndex, DependencyOverviewView.this.modelRepository, DependencyOverviewView.this.bus));
                }
            }
        });
    }

    private Set<DependencyInfo> extractSelectedDependencies(IStructuredSelection selection) {
        HashSet selectedDependencies = Sets.newHashSet();
        for (Object element : selection.toList()) {
            if (element instanceof Dependency) {
                Dependency dependency = (Dependency)element;
                selectedDependencies.add(dependency.info);
                continue;
            }
            if (!(element instanceof Project)) continue;
            Project project = (Project)element;
            for (Dependency dependency : project.dependencies) {
                selectedDependencies.add(dependency.info);
            }
        }
        return selectedDependencies;
    }

    private void createColumn(Tree dependencyTree, String label, int width) {
        TreeColumn column = new TreeColumn(dependencyTree, 16384);
        column.setText(label);
        column.setWidth(width);
    }

    private void refreshData() {
        new UIJob(Messages.JOB_NAME_REFRESHING_DEPENDENCY_OVERVIEW_VIEW){
            {
                this.schedule();
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                DependencyOverviewView.this.updateContent();
                return Status.OK_STATUS;
            }
        };
    }

    private void updateContent() {
        List<Project> projects = this.createModel();
        this.treeViewer.setInput(projects);
    }

    private List<Project> createModel() {
        ArrayList<Project> result = new ArrayList<Project>();
        ImmutableSet projectsDependencyInfos = this.dependencyListener.getProjects();
        for (DependencyInfo projectDI : projectsDependencyInfos) {
            Project project = new Project(projectDI);
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            ImmutableSet dependenciesForProject = this.dependencyListener.getDependenciesForProject(projectDI);
            for (DependencyInfo dependencyInfo : dependenciesForProject) {
                if (dependencyInfo.equals((Object)projectDI)) continue;
                dependencies.add(new Dependency(dependencyInfo, project));
            }
            project.dependencies = dependencies;
            result.add(project);
        }
        return result;
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    @Subscribe
    public void onEvent(ModelEvents.AdvisorConfigurationChangedEvent e) throws IOException {
        this.refreshData();
    }

    public static final class ContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Project) {
                return ((Project)parentElement).dependencies.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return element instanceof Dependency ? ((Dependency)element).parent : null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof List) {
                return !((List)element).isEmpty();
            }
            if (element instanceof Project) {
                return !((Project)element).dependencies.isEmpty();
            }
            return false;
        }
    }

    public static final class Dependency {
        public DependencyInfo info;
        public Project parent;

        public Dependency(DependencyInfo dependencyInfo, Project parent) {
            this.info = dependencyInfo;
            this.parent = parent;
        }

        public String toString() {
            return this.info.getFile().getName();
        }
    }

    public class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof Project) {
                        return DependencyOverviewView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_JAVA_PROJECT);
                    }
                    if (!(element instanceof Dependency)) break;
                    Dependency dependency = (Dependency)element;
                    return this.getImageForDependencyTyp(dependency.info);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof Project) {
                        return ((Project)element).info.getFile().getName();
                    }
                    if (element instanceof Dependency) {
                        return ((Dependency)element).info.getFile().getName();
                    }
                }
                case 1: {
                    if (!(element instanceof Dependency)) break;
                    Dependency dependency = (Dependency)element;
                    ProjectCoordinate pc = (ProjectCoordinate)DependencyOverviewView.this.pcProvider.resolve(dependency.info).orNull();
                    return pc == null ? null : pc.toString();
                }
            }
            if (element instanceof Dependency) {
                return this.findModelCoordinateVersion((Dependency)element, (String)DependencyOverviewView.this.modelClassifiers.get(columnIndex - 2));
            }
            return null;
        }

        private String findModelCoordinateVersion(Dependency dependency, String modelType) {
            ProjectCoordinate pc = (ProjectCoordinate)DependencyOverviewView.this.pcProvider.resolve(dependency.info).orNull();
            if (pc != null) {
                ModelCoordinate mc = (ModelCoordinate)DependencyOverviewView.this.modelIndex.suggest(pc, modelType).orNull();
                return mc == null ? "" : mc.getVersion();
            }
            return "";
        }

        private Image getImageForDependencyTyp(DependencyInfo dependencyInfo) {
            switch (dependencyInfo.getType()) {
                case JRE: {
                    return DependencyOverviewView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_JRE);
                }
                case JAR: {
                    return DependencyOverviewView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_JAR);
                }
                case PROJECT: {
                    return DependencyOverviewView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_JAVA_PROJECT);
                }
            }
            return null;
        }
    }

    public static final class Project {
        List<Dependency> dependencies;
        DependencyInfo info;

        public Project(DependencyInfo projectDependencyInfo) {
            this.info = projectDependencyInfo;
        }

        public String toString() {
            return this.info.getFile().getName();
        }
    }
}

