/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.customization;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.ClassChooserComboPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXmlEnumValue;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCustomization;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkProfiler;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Hyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkProfilerClassChooser
extends ClassChooserComboPane<EclipseLinkCustomization> {
    public EclipseLinkProfilerClassChooser(Pane<? extends EclipseLinkCustomization> parentPane, Composite parent, Hyperlink hyperlink) {
        super(parentPane, parent, hyperlink);
    }

    protected String getClassName() {
        return EclipseLinkProfiler.getProfilerClassName((String)((EclipseLinkCustomization)this.getSubject()).getProfiler());
    }

    protected IJavaProject getJavaProject() {
        return ((EclipseLinkCustomization)this.getSubject()).getJpaProject().getJavaProject();
    }

    protected ModifiablePropertyValueModel<String> buildTextHolder() {
        return new PropertyAspectAdapter<EclipseLinkCustomization, String>(this.getSubjectHolder(), new String[]{"profiler"}){

            protected String buildValue_() {
                String name = ((EclipseLinkCustomization)this.subject).getProfiler();
                if (name == null) {
                    name = EclipseLinkProfilerClassChooser.this.getDefaultValue((EclipseLinkCustomization)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (EclipseLinkProfilerClassChooser.this.getDefaultValue((EclipseLinkCustomization)this.subject).equals(value)) {
                    value = null;
                }
                ((EclipseLinkCustomization)this.subject).setProfiler(value);
            }
        };
    }

    private PropertyValueModel<String> buildDefaultProfilerHolder() {
        return new PropertyAspectAdapter<EclipseLinkCustomization, String>(this.getSubjectHolder(), new String[]{EclipseLinkCustomization.DEFAULT_PROFILER}){

            protected String buildValue_() {
                return EclipseLinkProfilerClassChooser.this.getDefaultValue((EclipseLinkCustomization)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultProfilerListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultProfilerHolder());
    }

    String buildDisplayString(String profilerName) {
        switch (EclipseLinkProfiler.valueOf((String)profilerName)) {
            case no_profiler: {
                return JptJpaEclipseLinkUiMessages.PROFILER_COMPOSITE_NO_PROFILER;
            }
            case performance_profiler: {
                return JptJpaEclipseLinkUiMessages.PROFILER_COMPOSITE_PERFORMANCE_PROFILER;
            }
            case query_monitor: {
                return JptJpaEclipseLinkUiMessages.PROFILER_COMPOSITE_QUERY_MONITOR;
            }
        }
        return null;
    }

    private Comparator<String> buildProfilerComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String profiler1, String profiler2) {
                profiler1 = EclipseLinkProfilerClassChooser.this.buildDisplayString(profiler1);
                profiler2 = EclipseLinkProfilerClassChooser.this.buildDisplayString(profiler2);
                return Collator.getInstance().compare(profiler1, profiler2);
            }
        };
    }

    protected Transformer<String, String> buildClassConverter() {
        return new ClassTransformer();
    }

    protected ListValueModel<String> buildClassListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultProfilerListHolder());
        holders.add(this.buildProfilersListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private Iterator<String> buildProfilers() {
        return IteratorTools.transform((Iterator)IteratorTools.iterator((Object[])EclipseLinkProfiler.values()), (Transformer)PersistenceXmlEnumValue.ENUM_NAME_TRANSFORMER);
    }

    private CollectionValueModel<String> buildProfilersCollectionHolder() {
        return new SimpleCollectionValueModel((Collection)CollectionTools.collection(this.buildProfilers()));
    }

    private ListValueModel<String> buildProfilersListHolder() {
        return new SortedListValueModelAdapter(this.buildProfilersCollectionHolder(), this.buildProfilerComparator());
    }

    private String getDefaultValue(EclipseLinkCustomization subject) {
        String defaultValue = subject.getDefaultProfiler();
        if (defaultValue != null) {
            return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
        }
        return JptCommonUiMessages.DEFAULT_EMPTY;
    }

    protected void setClassName(String className) {
        ((EclipseLinkCustomization)this.getSubject()).setProfiler(className);
    }

    protected String getSuperInterfaceName() {
        return "org.eclipse.persistence.sessions.SessionProfiler";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClassTransformer
    extends TransformerAdapter<String, String> {
        ClassTransformer() {
        }

        public String transform(String value) {
            try {
                return EclipseLinkProfilerClassChooser.this.buildDisplayString(value);
            }
            catch (RuntimeException runtimeException) {
                return value;
            }
        }
    }
}

