/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.appclient;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.javaee.applicationclient.ApplicationClient;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.jee.ui.internal.Messages;
import org.eclipse.jst.jee.ui.internal.navigator.appclient.AbstractAppClientGroupProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.jst.jee.ui.plugin.JEEUIPluginIcons;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class GroupAppClientProvider
extends AbstractAppClientGroupProvider
implements IAdaptable {
    private final IProject project;
    private static final String PROJECT_RELATIVE_PATH = "META-INF/application-client.xml";
    private Image appClient50Image;
    private Image appClient60Image;
    private Image appClient70Image;
    private IFile ddFile;

    public GroupAppClientProvider(ApplicationClient javaee, IProject project) {
        super((JavaEEObject)javaee);
        this.project = project;
    }

    public String getText() {
        String result = null;
        result = this.project == null ? NLS.bind((String)Messages.DEPLOYMENT_DESCRIPTOR, (Object[])new Object[]{""}) : NLS.bind((String)Messages.DEPLOYMENT_DESCRIPTOR, (Object)this.project.getName());
        return result;
    }

    public List getChildren() {
        ArrayList result = new ArrayList();
        if (this.javaee != null) {
            result.addAll(((ApplicationClient)this.javaee).getEjbRefs());
            result.addAll(((ApplicationClient)this.javaee).getResourceRefs());
            result.addAll(((ApplicationClient)this.javaee).getResourceEnvRefs());
            result.addAll(((ApplicationClient)this.javaee).getEnvEntries());
            result.addAll(((ApplicationClient)this.javaee).getMessageDestinationRefs());
            result.addAll(((ApplicationClient)this.javaee).getPersistenceUnitRefs());
            result.addAll(((ApplicationClient)this.javaee).getServiceRefs());
        }
        return result;
    }

    public Image getImage() {
        String version = ((ApplicationClient)this.javaee).getVersion();
        if ("5".equals(version)) {
            return this.getAppClient50Image();
        }
        if ("6".equals(version)) {
            return this.getAppClient60Image();
        }
        if ("7".equals(version)) {
            return this.getAppClient70Image();
        }
        return this.getAppClient50Image();
    }

    public IFile getDDFile() {
        if (this.ddFile != null) {
            return this.ddFile;
        }
        IVirtualFolder virtualFolder = ComponentCore.createComponent((IProject)this.project).getRootFolder();
        this.ddFile = virtualFolder.getFile(PROJECT_RELATIVE_PATH).getUnderlyingFile();
        return this.ddFile;
    }

    public IProject getProject() {
        return this.project;
    }

    public Object getAdapter(Class adapter) {
        if (IProject.class == adapter) {
            return this.getProject();
        }
        return null;
    }

    private Image getAppClient50Image() {
        if (this.appClient50Image == null) {
            this.appClient50Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.APP_CLIENT50).createImage();
        }
        return this.appClient50Image;
    }

    private Image getAppClient60Image() {
        if (this.appClient60Image == null) {
            this.appClient60Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.APP_CLIENT60).createImage();
        }
        return this.appClient60Image;
    }

    private Image getAppClient70Image() {
        if (this.appClient70Image == null) {
            this.appClient70Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.APP_CLIENT70).createImage();
        }
        return this.appClient70Image;
    }
}

