/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceRelationshipMappingAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OneToOneAnnotation2_0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceOneToOneAnnotation
extends SourceRelationshipMappingAnnotation
implements OneToOneAnnotation2_0 {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.OneToOne");
    static final DeclarationAnnotationElementAdapter<String> TARGET_ENTITY_ADAPTER = SourceOneToOneAnnotation.buildTargetEntityAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceOneToOneAnnotation.buildFetchAdapter();
    private static final DeclarationAnnotationElementAdapter<String[]> CASCADE_ADAPTER = SourceOneToOneAnnotation.buildCascadeAdapter();
    private static final DeclarationAnnotationElementAdapter<String> MAPPED_BY_ADAPTER = SourceOneToOneAnnotation.buildMappedByAdapter();
    private final AnnotationElementAdapter<String> mappedByAdapter = this.buildAnnotationElementAdapter(MAPPED_BY_ADAPTER);
    private String mappedBy;
    private TextRange mappedByTextRange;
    private static final DeclarationAnnotationElementAdapter<Boolean> OPTIONAL_ADAPTER = SourceOneToOneAnnotation.buildOptionalAdapter();
    private final AnnotationElementAdapter<Boolean> optionalAdapter = this.buildBooleanAnnotationElementAdapter(OPTIONAL_ADAPTER);
    private Boolean optional;
    private TextRange optionalTextRange;
    private static final DeclarationAnnotationElementAdapter<Boolean> ORPHAN_REMOVAL_ADAPTER = SourceOneToOneAnnotation.buildOrphanRemovalAdapter();
    private final AnnotationElementAdapter<Boolean> orphanRemovalAdapter = this.buildBooleanAnnotationElementAdapter(ORPHAN_REMOVAL_ADAPTER);
    private Boolean orphanRemoval;
    private TextRange orphanRemovalTextRange;

    public SourceOneToOneAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super(parent, element, DECLARATION_ANNOTATION_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.persistence.OneToOne";
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.mappedBy = this.buildMappedBy(astAnnotation);
        this.mappedByTextRange = this.buildMappedByTextRange(astAnnotation);
        this.optional = this.buildOptional(astAnnotation);
        this.optionalTextRange = this.buildOptionalTextRange(astAnnotation);
        this.orphanRemoval = this.buildOrphanRemoval(astAnnotation);
        this.orphanRemovalTextRange = this.buildOrphanRemovalTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncMappedBy(this.buildMappedBy(astAnnotation));
        this.mappedByTextRange = this.buildMappedByTextRange(astAnnotation);
        this.syncOptional(this.buildOptional(astAnnotation));
        this.optionalTextRange = this.buildOptionalTextRange(astAnnotation);
        this.syncOrphanRemoval(this.buildOrphanRemoval(astAnnotation));
        this.orphanRemovalTextRange = this.buildOrphanRemovalTextRange(astAnnotation);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.mappedBy == null && this.optional == null && this.orphanRemoval == null;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getTargetEntityAdapter() {
        return TARGET_ENTITY_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getFetchAdapter() {
        return FETCH_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String[]> getCascadeAdapter() {
        return CASCADE_ADAPTER;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String mappedBy) {
        if (ObjectTools.notEquals((Object)this.mappedBy, (Object)mappedBy)) {
            this.mappedBy = mappedBy;
            this.mappedByAdapter.setValue((Object)mappedBy);
        }
    }

    private void syncMappedBy(String astMappedBy) {
        String old = this.mappedBy;
        this.mappedBy = astMappedBy;
        this.firePropertyChanged("mappedBy", old, astMappedBy);
    }

    private String buildMappedBy(Annotation astAnnotation) {
        return (String)this.mappedByAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getMappedByTextRange() {
        return this.mappedByTextRange;
    }

    private TextRange buildMappedByTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(MAPPED_BY_ADAPTER, astAnnotation);
    }

    @Override
    public boolean mappedByTouches(int pos) {
        return this.textRangeTouches(this.mappedByTextRange, pos);
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        if (ObjectTools.notEquals((Object)this.optional, (Object)optional)) {
            this.optional = optional;
            this.optionalAdapter.setValue((Object)optional);
        }
    }

    private void syncOptional(Boolean astOptional) {
        Boolean old = this.optional;
        this.optional = astOptional;
        this.firePropertyChanged("optional", old, astOptional);
    }

    private Boolean buildOptional(Annotation astAnnotation) {
        return (Boolean)this.optionalAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getOptionalTextRange() {
        return this.optionalTextRange;
    }

    private TextRange buildOptionalTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(OPTIONAL_ADAPTER, astAnnotation);
    }

    @Override
    public Boolean getOrphanRemoval() {
        return this.orphanRemoval;
    }

    @Override
    public void setOrphanRemoval(Boolean orphanRemoval) {
        if (ObjectTools.notEquals((Object)this.orphanRemoval, (Object)orphanRemoval)) {
            this.orphanRemoval = orphanRemoval;
            this.orphanRemovalAdapter.setValue((Object)orphanRemoval);
        }
    }

    private void syncOrphanRemoval(Boolean astOrphanRemoval) {
        Boolean old = this.orphanRemoval;
        this.orphanRemoval = astOrphanRemoval;
        this.firePropertyChanged("orphanRemoval", old, astOrphanRemoval);
    }

    @Override
    public TextRange getOrphanRemovalTextRange() {
        return this.orphanRemovalTextRange;
    }

    private TextRange buildOrphanRemovalTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(ORPHAN_REMOVAL_ADAPTER, astAnnotation);
    }

    private Boolean buildOrphanRemoval(Annotation astAnnotation) {
        return (Boolean)this.orphanRemovalAdapter.getValue(astAnnotation);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter() {
        return SourceOneToOneAnnotation.buildTargetEntityAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetEntity");
    }

    private static DeclarationAnnotationElementAdapter<String> buildMappedByAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"mappedBy");
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return SourceOneToOneAnnotation.buildFetchAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter() {
        return SourceOneToOneAnnotation.buildOptionalAdapter(DECLARATION_ANNOTATION_ADAPTER, "optional");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildCascadeAdapter() {
        return SourceOneToOneAnnotation.buildEnumArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "cascade");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOrphanRemovalAdapter() {
        return SourceOneToOneAnnotation.buildOrphanRemovalAdapter(DECLARATION_ANNOTATION_ADAPTER, "orphanRemoval");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOrphanRemovalAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, BooleanExpressionConverter.instance());
    }
}

