/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaBaseColumn;
import org.eclipse.jpt.jpa.core.resource.java.CompleteJoinColumnAnnotation;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaJoinColumn
extends AbstractJavaBaseColumn<JoinColumn.ParentAdapter, CompleteJoinColumnAnnotation>
implements JavaSpecifiedJoinColumn {
    protected CompleteJoinColumnAnnotation columnAnnotation;
    protected String specifiedReferencedColumnName;
    protected String defaultReferencedColumnName;

    public GenericJavaJoinColumn(JoinColumn.ParentAdapter parentAdapter, CompleteJoinColumnAnnotation columnAnnotation) {
        super(parentAdapter, columnAnnotation);
    }

    @Override
    protected void initialize(CompleteJoinColumnAnnotation colAnnotation) {
        super.initialize(colAnnotation);
        this.specifiedReferencedColumnName = this.buildSpecifiedReferencedColumnName(colAnnotation);
    }

    @Override
    public void synchronizeWithResourceModel(CompleteJoinColumnAnnotation colAnnotation) {
        super.synchronizeWithResourceModel(colAnnotation);
        this.setSpecifiedReferencedColumnName_(this.buildSpecifiedReferencedColumnName(colAnnotation));
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultReferencedColumnName(this.buildDefaultReferencedColumnName());
    }

    @Override
    public CompleteJoinColumnAnnotation getColumnAnnotation() {
        return this.columnAnnotation;
    }

    @Override
    protected void setColumnAnnotation(CompleteJoinColumnAnnotation columnAnnotation) {
        this.columnAnnotation = columnAnnotation;
    }

    @Override
    protected void removeColumnAnnotation() {
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName != null ? this.specifiedReferencedColumnName : this.defaultReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String name) {
        if (ObjectTools.notEquals((Object)this.specifiedReferencedColumnName, (Object)name)) {
            this.getColumnAnnotation().setReferencedColumnName(name);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedReferencedColumnName_(name);
        }
    }

    protected void setSpecifiedReferencedColumnName_(String name) {
        String old = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = name;
        this.firePropertyChanged("specifiedReferencedColumnName", old, name);
    }

    protected String buildSpecifiedReferencedColumnName(CompleteJoinColumnAnnotation colAnnotation) {
        return colAnnotation.getReferencedColumnName();
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String name) {
        String old = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = name;
        this.firePropertyChanged("defaultReferencedColumnName", old, name);
    }

    protected String buildDefaultReferencedColumnName() {
        return MappingTools.buildJoinColumnDefaultReferencedColumnName((JoinColumn.ParentAdapter)this.parentAdapter);
    }

    @Override
    public Table getReferencedColumnDbTable() {
        return ((JoinColumn.ParentAdapter)this.parentAdapter).getReferencedColumnDbTable();
    }

    protected Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    @Override
    public boolean referencedColumnIsResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public void initializeFrom(VirtualJoinColumn virtualColumn) {
        super.initializeFrom(virtualColumn);
        this.setSpecifiedReferencedColumnName(virtualColumn.getReferencedColumnName());
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos)) {
            return this.getJavaCandidateReferencedColumnNames();
        }
        return null;
    }

    protected boolean referencedColumnNameTouches(int pos) {
        return this.getColumnAnnotation().referencedColumnNameTouches(pos);
    }

    protected Iterable<String> getJavaCandidateReferencedColumnNames() {
        return new TransformationIterable(this.getCandidateReferencedColumnNames(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateReferencedColumnNames() {
        Table table = ((JoinColumn.ParentAdapter)this.parentAdapter).getReferencedColumnDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public TextRange getReferencedColumnNameTextRange() {
        return this.getValidationTextRange(this.getColumnAnnotation().getReferencedColumnNameTextRange());
    }
}

