/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.IdTypeMapping;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.jpa.core.context.java.JavaIdTypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdClassReference;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.orm.GenericOrmIdClassReference;
import org.eclipse.jpt.jpa.core.resource.orm.XmlIdClassContainer;
import org.eclipse.jpt.jpa.core.resource.orm.XmlIdTypeMapping;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmIdTypeMapping<X extends XmlIdTypeMapping>
extends AbstractOrmTypeMapping<X>
implements OrmIdTypeMapping {
    protected final OrmIdClassReference idClassReference = this.buildIdClassReference();
    protected IdTypeMapping superTypeMapping;

    protected AbstractOrmIdTypeMapping(OrmPersistentType parent, X xmlTypeMapping) {
        super(parent, xmlTypeMapping);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.idClassReference.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.idClassReference.update();
        this.setSuperTypeMapping_(this.findSuperTypeMapping());
    }

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        return (JavaIdTypeMapping)super.getJavaTypeMapping();
    }

    @Override
    public JavaIdTypeMapping getJavaTypeMappingForDefaults() {
        return (JavaIdTypeMapping)super.getJavaTypeMappingForDefaults();
    }

    @Override
    public OrmIdClassReference getIdClassReference() {
        return this.idClassReference;
    }

    protected OrmIdClassReference buildIdClassReference() {
        return new GenericOrmIdClassReference(this);
    }

    @Override
    public XmlIdClassContainer getXmlIdClassContainer() {
        return (XmlIdClassContainer)this.getXmlTypeMapping();
    }

    @Override
    public JavaIdClassReference getJavaIdClassReferenceForDefaults() {
        JavaIdTypeMapping javaTypeMapping = this.getJavaTypeMappingForDefaults();
        return javaTypeMapping == null ? null : javaTypeMapping.getIdClassReference();
    }

    @Override
    public String getPrimaryKeyClassName() {
        String idClassName = this.getIdClassReference().getFullyQualifiedIdClassName();
        if (StringTools.isNotBlank((String)idClassName)) {
            return idClassName;
        }
        AttributeMapping idMapping = this.getIdAttributeMapping();
        if (idMapping != null) {
            return idMapping.getPersistentAttribute().getTypeName();
        }
        return null;
    }

    @Override
    public IdTypeMapping getSuperTypeMapping() {
        return this.superTypeMapping;
    }

    protected void setSuperTypeMapping_(IdTypeMapping typeMapping) {
        IdTypeMapping old = this.superTypeMapping;
        this.superTypeMapping = typeMapping;
        this.firePropertyChanged("superTypeMapping", old, typeMapping);
    }

    protected IdTypeMapping findSuperTypeMapping() {
        return this.findSuperTypeMapping(this.getFullyQualifiedParentClass());
    }

    protected IdTypeMapping findSuperTypeMapping(String superTypeName) {
        String thisTypeName = this.getPersistentType().getName();
        if (superTypeName == null || ObjectTools.equals((Object)thisTypeName, (Object)superTypeName)) {
            return null;
        }
        IdTypeMapping typeMapping = this.findTypeMapping(superTypeName);
        if (typeMapping != null) {
            return typeMapping;
        }
        JavaResourceType superResourceType = this.findResourceType(superTypeName);
        return superResourceType == null ? null : this.findSuperTypeMapping(superResourceType.getSuperclassQualifiedName());
    }

    protected JavaResourceType findResourceType(String typeName) {
        return (JavaResourceType)this.getJpaProject().getJavaResourceType(typeName, JavaResourceAnnotatedElement.AstNodeType.TYPE);
    }

    protected IdTypeMapping findTypeMapping(String typeName) {
        return this.getPersistenceUnit().getIdTypeMapping(typeName);
    }

    @Override
    public Iterable<IdTypeMapping> getInheritanceHierarchy() {
        return this.buildInheritanceHierarchy(this);
    }

    @Override
    public Iterable<IdTypeMapping> getAncestors() {
        return this.superTypeMapping == null ? IterableTools.emptyIterable() : this.buildInheritanceHierarchy(this.superTypeMapping);
    }

    protected Iterable<IdTypeMapping> buildInheritanceHierarchy(IdTypeMapping start) {
        return ObjectTools.chain((Object)start, (Transformer)new IdTypeMapping.SuperTypeMappingTransformer(this));
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return null;
    }

    @Override
    public boolean isRootEntity() {
        return false;
    }

    @Override
    public Entity getRootEntity() {
        return null;
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.idClassReference.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validatePrimaryKey(messages, reporter);
    }

    protected void validatePrimaryKey(List<IMessage> messages, IReporter reporter) {
        this.buildPrimaryKeyValidator().validate(messages, reporter);
    }

    protected abstract JpaValidator buildPrimaryKeyValidator();
}

