/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Association;
import org.eclipse.jpt.common.utility.internal.SimpleAssociation;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaBaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.java.JavaConverter;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratedValue;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaIdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.NamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.NullJavaConverter;
import org.eclipse.jpt.jpa.core.jpa2.context.IdMapping2_0;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.IdAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationArgumentMessages;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaIdMapping
extends AbstractJavaAttributeMapping<IdAnnotation>
implements JavaIdMapping,
IdMapping2_0,
JavaGeneratorContainer.Parent {
    protected final JavaSpecifiedColumn column = this.buildColumn();
    protected final JavaGeneratorContainer generatorContainer = this.buildGeneratorContainer();
    protected JavaGeneratedValue generatedValue = this.buildGeneratedValue();
    protected JavaConverter converter = this.buildConverter();
    protected boolean derived;
    protected static final JavaConverter.Adapter[] CONVERTER_ADAPTER_ARRAY = new JavaConverter.Adapter[]{JavaBaseTemporalConverter.BasicAdapter.instance()};
    protected static final Iterable<JavaConverter.Adapter> CONVERTER_ADAPTERS = IterableTools.iterable((Object[])CONVERTER_ADAPTER_ARRAY);

    protected AbstractJavaIdMapping(JavaSpecifiedPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.column.synchronizeWithResourceModel();
        this.generatorContainer.synchronizeWithResourceModel();
        this.syncGeneratedValue();
        this.syncConverter();
    }

    @Override
    public void update() {
        super.update();
        this.column.update();
        this.generatorContainer.update();
        if (this.generatedValue != null) {
            this.generatedValue.update();
        }
        this.converter.update();
        this.setDerived(this.buildDerived());
    }

    @Override
    public JavaSpecifiedColumn getColumn() {
        return this.column;
    }

    protected JavaSpecifiedColumn buildColumn() {
        return this.getJpaFactory().buildJavaColumn(this);
    }

    @Override
    public JavaGeneratorContainer getGeneratorContainer() {
        return this.generatorContainer;
    }

    protected JavaGeneratorContainer buildGeneratorContainer() {
        return this.getJpaFactory().buildJavaGeneratorContainer(this);
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return this.generatorContainer.getGenerators();
    }

    public JavaResourceMember getResourceAnnotatedElement() {
        return this.getResourceAttribute();
    }

    @Override
    public boolean supportsGenerators() {
        return !this.getPersistentAttribute().isVirtual();
    }

    @Override
    public JavaGeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }

    @Override
    public JavaGeneratedValue addGeneratedValue() {
        if (this.generatedValue != null) {
            throw new IllegalStateException("generated value already exists: " + this.generatedValue);
        }
        GeneratedValueAnnotation annotation = this.buildGeneratedValueAnnotation();
        JavaGeneratedValue value = this.buildGeneratedValue(annotation);
        this.setGeneratedValue(value);
        return value;
    }

    protected GeneratedValueAnnotation buildGeneratedValueAnnotation() {
        return (GeneratedValueAnnotation)this.getResourceAttribute().addAnnotation("javax.persistence.GeneratedValue");
    }

    @Override
    public void removeGeneratedValue() {
        if (this.generatedValue == null) {
            throw new IllegalStateException("generated value does not exist");
        }
        this.getResourceAttribute().removeAnnotation("javax.persistence.GeneratedValue");
        this.setGeneratedValue(null);
    }

    protected JavaGeneratedValue buildGeneratedValue() {
        GeneratedValueAnnotation annotation = this.getGeneratedValueAnnotation();
        return annotation == null ? null : this.buildGeneratedValue(annotation);
    }

    protected GeneratedValueAnnotation getGeneratedValueAnnotation() {
        return (GeneratedValueAnnotation)this.getResourceAttribute().getAnnotation("javax.persistence.GeneratedValue");
    }

    protected JavaGeneratedValue buildGeneratedValue(GeneratedValueAnnotation generatedValueAnnotation) {
        return this.getJpaFactory().buildJavaGeneratedValue(this, generatedValueAnnotation);
    }

    protected void syncGeneratedValue() {
        GeneratedValueAnnotation annotation = this.getGeneratedValueAnnotation();
        if (annotation == null) {
            if (this.generatedValue != null) {
                this.setGeneratedValue(null);
            }
        } else if (this.generatedValue != null && this.generatedValue.getGeneratedValueAnnotation() == annotation) {
            this.generatedValue.synchronizeWithResourceModel();
        } else {
            this.setGeneratedValue(this.buildGeneratedValue(annotation));
        }
    }

    protected void setGeneratedValue(JavaGeneratedValue value) {
        JavaGeneratedValue old = this.generatedValue;
        this.generatedValue = value;
        this.firePropertyChanged("generatedValue", old, value);
    }

    @Override
    public JavaConverter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(Class<? extends Converter> converterType) {
        if (this.converter.getConverterType() != converterType) {
            this.converter.dispose();
            JavaConverter.Adapter converterAdapter = this.getConverterAdapter(converterType);
            this.retainConverterAnnotation(converterAdapter);
            this.setConverter_(this.buildConverter(converterAdapter));
        }
    }

    protected JavaConverter buildConverter(JavaConverter.Adapter converterAdapter) {
        return converterAdapter != null ? converterAdapter.buildNewConverter(this, this.getJpaFactory()) : this.buildNullConverter();
    }

    protected void setConverter_(JavaConverter converter) {
        JavaConverter old = this.converter;
        this.converter = converter;
        this.firePropertyChanged("converter", old, converter);
    }

    protected void retainConverterAnnotation(JavaConverter.Adapter converterAdapter) {
        JavaResourceAttribute resourceAttribute = this.getResourceAttribute();
        for (JavaConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter == converterAdapter) continue;
            adapter.removeConverterAnnotation(resourceAttribute);
        }
    }

    protected JavaConverter buildConverter() {
        JpaFactory jpaFactory = this.getJpaFactory();
        for (JavaConverter.Adapter adapter : this.getConverterAdapters()) {
            JavaConverter javaConverter = adapter.buildConverter(this, jpaFactory);
            if (javaConverter == null) continue;
            return javaConverter;
        }
        return this.buildNullConverter();
    }

    protected void syncConverter() {
        Association<JavaConverter.Adapter, Annotation> assoc = this.getConverterAnnotation();
        if (assoc == null) {
            if (this.converter.getConverterType() != null) {
                this.setConverter_(this.buildNullConverter());
            }
        } else {
            JavaConverter.Adapter adapter = (JavaConverter.Adapter)assoc.getKey();
            Annotation annotation = (Annotation)assoc.getValue();
            if (this.converter.getConverterType() == adapter.getConverterType() && this.converter.getConverterAnnotation() == annotation) {
                this.converter.synchronizeWithResourceModel();
            } else {
                this.setConverter_(adapter.buildConverter(annotation, this, this.getJpaFactory()));
            }
        }
    }

    protected Association<JavaConverter.Adapter, Annotation> getConverterAnnotation() {
        JavaResourceAttribute resourceAttribute = this.getResourceAttribute();
        for (JavaConverter.Adapter adapter : this.getConverterAdapters()) {
            Annotation annotation = adapter.getConverterAnnotation(resourceAttribute);
            if (annotation == null) continue;
            return new SimpleAssociation((Object)adapter, (Object)annotation);
        }
        return null;
    }

    protected JavaConverter buildNullConverter() {
        return new NullJavaConverter(this);
    }

    protected JavaConverter.Adapter getConverterAdapter(Class<? extends Converter> converterType) {
        for (JavaConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter.getConverterType() != converterType) continue;
            return adapter;
        }
        return null;
    }

    protected Iterable<JavaConverter.Adapter> getConverterAdapters() {
        return CONVERTER_ADAPTERS;
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    protected void setDerived(boolean derived) {
        boolean old = this.derived;
        this.derived = derived;
        this.firePropertyChanged("derived", old, derived);
    }

    protected boolean buildDerived() {
        return this.isJpa2_0Compatible() && this.buildDerived_();
    }

    protected boolean buildDerived_() {
        return this.getTypeMapping().attributeIsDerivedId(this.getName());
    }

    @Override
    public String getKey() {
        return "id";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.Id";
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.column.getName();
    }

    protected boolean columnIsSpecified() {
        return this.getResourceAttribute().getAnnotation("javax.persistence.Column") != null;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public JpaContextModel getColumnParent() {
        return this;
    }

    @Override
    public ColumnAnnotation getColumnAnnotation() {
        return (ColumnAnnotation)this.getResourceAttribute().getNonNullAnnotation("javax.persistence.Column");
    }

    @Override
    public void removeColumnAnnotation() {
        this.getResourceAttribute().removeAnnotation("javax.persistence.Column");
    }

    @Override
    public String getDefaultColumnName(NamedColumn col) {
        return this.derived && !this.columnIsSpecified() ? null : this.getName();
    }

    @Override
    public String getDefaultTableName() {
        return this.derived && !this.columnIsSpecified() ? null : this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public Iterable<String> getCandidateTableNames() {
        return this.getTypeMapping().getAllAssociatedTableNames();
    }

    @Override
    public JpaValidator buildColumnValidator(NamedColumn col) {
        return new NamedColumnValidator((PersistentAttribute)this.getPersistentAttribute(), (BaseColumn)col, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.column.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.generatorContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.generatedValue != null && (result = this.generatedValue.getCompletionProposals(pos)) != null) {
            return result;
        }
        result = this.converter.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.columnIsSpecified() || !this.derived) {
            this.column.validate(messages, reporter);
        }
        if (this.columnIsSpecified() && this.derived) {
            messages.add(this.buildColumnSpecifiedAndDerivedMessage());
        }
        this.generatorContainer.validate(messages, reporter);
        if (this.generatedValue != null) {
            this.generatedValue.validate(messages, reporter);
        }
        this.converter.validate(messages, reporter);
    }

    protected IMessage buildColumnSpecifiedAndDerivedMessage() {
        return this.buildValidationMessage(this.getTextRange(), JptJpaCoreValidationMessages.ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_COLUMN_SPECIFIED, this.buildAttributeDescription());
    }

    protected String buildAttributeDescription() {
        return NLS.bind((String)this.getAttributeDescriptionTemplate(), (Object)this.getPersistentAttribute().getName());
    }

    protected String getAttributeDescriptionTemplate() {
        return this.getPersistentAttribute().isVirtual() ? JptJpaCoreValidationArgumentMessages.VIRTUAL_ATTRIBUTE_DESC : JptJpaCoreValidationArgumentMessages.ATTRIBUTE_DESC;
    }

    protected TextRange getTextRange() {
        return this.getPersistentAttribute().isVirtual() ? this.getVirtualPersistentAttributeTextRange() : this.column.getValidationTextRange();
    }
}

