/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.BaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlContextModelFactory;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.NullJpaValidator;
import org.eclipse.jpt.jpa.core.resource.orm.EnumType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.jpa.core.resource.orm.XmlConvertibleMapping;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlMapKeyConvertibleMapping_2_0;

public interface OrmBaseEnumeratedConverter
extends BaseEnumeratedConverter,
OrmConverter {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BasicAdapter
    implements OrmConverter.Adapter {
        private static final BasicAdapter INSTANCE = new BasicAdapter();

        public static BasicAdapter instance() {
            return INSTANCE;
        }

        private BasicAdapter() {
        }

        public Class<BaseEnumeratedConverter> getConverterType() {
            return BaseEnumeratedConverter.class;
        }

        @Override
        public OrmConverter buildConverter(OrmAttributeMapping parent, OrmXmlContextModelFactory factory) {
            XmlConvertibleMapping xmlMapping = (XmlConvertibleMapping)((Object)parent.getXmlAttributeMapping());
            return xmlMapping.getEnumerated() == null ? null : factory.buildOrmBaseEnumeratedConverter(this.buildConverterParentAdapter(parent, xmlMapping));
        }

        protected ParentAdapter buildConverterParentAdapter(OrmAttributeMapping parent, XmlConvertibleMapping mapping) {
            return new ConverterParentAdapter(parent, mapping);
        }

        @Override
        public boolean isActive(XmlAttributeMapping xmlMapping) {
            return ((XmlConvertibleMapping)((Object)xmlMapping)).getEnumerated() != null;
        }

        @Override
        public OrmConverter buildNewConverter(OrmAttributeMapping parent, OrmXmlContextModelFactory factory) {
            return factory.buildOrmBaseEnumeratedConverter(this.buildConverterParentAdapter(parent, (XmlConvertibleMapping)((Object)parent.getXmlAttributeMapping())));
        }

        @Override
        public void clearXmlValue(XmlAttributeMapping xmlMapping) {
            ((XmlConvertibleMapping)((Object)xmlMapping)).setEnumerated(null);
        }

        public static class ConverterParentAdapter
        implements ParentAdapter {
            private final OrmAttributeMapping parent;
            private final XmlConvertibleMapping mapping;

            public ConverterParentAdapter(OrmAttributeMapping parent, XmlConvertibleMapping mapping) {
                this.parent = parent;
                this.mapping = mapping;
            }

            public OrmAttributeMapping getConverterParent() {
                return this.parent;
            }

            public void setXmlEnumType(EnumType enumType) {
                this.mapping.setEnumerated(enumType);
            }

            public EnumType getXmlEnumType() {
                return this.mapping.getEnumerated();
            }

            public TextRange getEnumTextRange() {
                return this.mapping.getEnumeratedTextRange();
            }

            public JpaValidator buildValidator(Converter converter) {
                return NullJpaValidator.instance();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapKeyAdapter
    implements OrmConverter.Adapter {
        private static final MapKeyAdapter INSTANCE = new MapKeyAdapter();

        public static MapKeyAdapter instance() {
            return INSTANCE;
        }

        private MapKeyAdapter() {
        }

        public Class<BaseEnumeratedConverter> getConverterType() {
            return BaseEnumeratedConverter.class;
        }

        @Override
        public OrmConverter buildConverter(OrmAttributeMapping parent, OrmXmlContextModelFactory factory) {
            XmlMapKeyConvertibleMapping_2_0 xmlMapping = (XmlMapKeyConvertibleMapping_2_0)((Object)parent.getXmlAttributeMapping());
            return xmlMapping.getMapKeyEnumerated() == null ? null : factory.buildOrmBaseEnumeratedConverter(this.buildParentAdapter(parent, xmlMapping));
        }

        protected ParentAdapter buildParentAdapter(OrmAttributeMapping parent, XmlMapKeyConvertibleMapping_2_0 mapping) {
            return new ConverterParentAdapter(parent, mapping);
        }

        @Override
        public boolean isActive(XmlAttributeMapping xmlMapping) {
            return ((XmlMapKeyConvertibleMapping_2_0)((Object)xmlMapping)).getMapKeyEnumerated() != null;
        }

        @Override
        public OrmConverter buildNewConverter(OrmAttributeMapping parent, OrmXmlContextModelFactory factory) {
            return factory.buildOrmBaseEnumeratedConverter(this.buildParentAdapter(parent, (XmlMapKeyConvertibleMapping_2_0)((Object)parent.getXmlAttributeMapping())));
        }

        @Override
        public void clearXmlValue(XmlAttributeMapping xmlMapping) {
            ((XmlMapKeyConvertibleMapping_2_0)((Object)xmlMapping)).setMapKeyEnumerated(null);
        }

        public static class ConverterParentAdapter
        implements ParentAdapter {
            private final OrmAttributeMapping parent;
            private final XmlMapKeyConvertibleMapping_2_0 mapping;

            public ConverterParentAdapter(OrmAttributeMapping parent, XmlMapKeyConvertibleMapping_2_0 mapping) {
                this.parent = parent;
                this.mapping = mapping;
            }

            public OrmAttributeMapping getConverterParent() {
                return this.parent;
            }

            public void setXmlEnumType(EnumType enumType) {
                this.mapping.setMapKeyEnumerated(enumType);
            }

            public EnumType getXmlEnumType() {
                return this.mapping.getMapKeyEnumerated();
            }

            public TextRange getEnumTextRange() {
                return this.mapping.getMapKeyEnumeratedTextRange();
            }

            public JpaValidator buildValidator(Converter converter) {
                return NullJpaValidator.instance();
            }
        }
    }

    public static interface ParentAdapter
    extends OrmConverter.ParentAdapter {
        public EnumType getXmlEnumType();

        public void setXmlEnumType(EnumType var1);

        public TextRange getEnumTextRange();
    }
}

