/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.utility.ProjectTools;
import org.eclipse.jpt.common.core.utility.command.JobCommand;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.StatefulCommandContext;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.command.AsynchronousExtendedCommandContext;
import org.eclipse.jpt.common.utility.internal.command.SimpleStatefulExtendedCommandContext;
import org.eclipse.jpt.common.utility.internal.exception.ExceptionHandlerAdapter;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.reference.SynchronizedBoolean;
import org.eclipse.jpt.jaxb.core.JaxbFile;
import org.eclipse.jpt.jaxb.core.JaxbPreferences;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbProjectManager;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.SimpleJaxbProjectConfig;
import org.eclipse.jpt.jaxb.core.internal.plugin.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.internal.utility.CallbackJobSynchronizer;
import org.eclipse.jpt.jaxb.core.internal.utility.JobSynchronizer;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDefinition;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformManager;
import org.eclipse.jpt.jaxb.core.utility.CallbackSynchronizer;
import org.eclipse.jpt.jaxb.core.utility.Synchronizer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalJaxbProjectManager
extends AbstractModel
implements JaxbProjectManager {
    private final JaxbWorkspace jaxbWorkspace;
    private final Vector<JaxbProject> jaxbProjects = new Vector();
    final ILock lock = this.getJobManager().newLock();
    private volatile StatefulCommandContext eventHandler = new AsynchronousExtendedCommandContext(JptCommonCoreMessages.DALI_EVENT_HANDLER_THREAD_NAME, (ExceptionHandler)new LocalExceptionHandler());
    private final IResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private static final int RESOURCE_CHANGE_EVENT_TYPES = 17;
    private static final String FACETED_PROJECT_FRAMEWORK_SETTINGS_FILE_NAME = "org.eclipse.wst.common.project.facet.core.xml";
    private final IFacetedProjectListener facetedProjectListener = new FacetedProjectListener();
    private static final IFacetedProjectEvent.Type[] FACETED_PROJECT_EVENT_TYPES = new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PRE_UNINSTALL};
    private final JavaElementChangeListener javaElementChangeListener = new JavaElementChangeListener();
    private static final int JAVA_CHANGE_EVENT_TYPES = 5;
    private static final boolean DEBUG = false;

    InternalJaxbProjectManager(JaxbWorkspace jaxbWorkspace) {
        this.jaxbWorkspace = jaxbWorkspace;
    }

    void start() {
        try {
            this.lock.acquire();
            this.start_();
        }
        finally {
            this.lock.release();
        }
    }

    private void start_() {
        InternalJaxbProjectManager.debug("*** JAXB project manager START ***");
        try {
            this.buildJaxbProjects();
            this.eventHandler.start();
            this.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 17);
            FacetedProjectFramework.addListener((IFacetedProjectListener)this.facetedProjectListener, (IFacetedProjectEvent.Type[])FACETED_PROJECT_EVENT_TYPES);
            JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener, (int)5);
        }
        catch (RuntimeException ex) {
            JptJaxbCorePlugin.instance().logError(ex);
            this.stop_();
        }
    }

    private void buildJaxbProjects() {
        try {
            this.buildJaxbProjects_();
        }
        catch (CoreException ex) {
            JptJaxbCorePlugin.instance().logError(ex);
        }
    }

    private void buildJaxbProjects_() throws CoreException {
        this.getWorkspace().getRoot().accept((IResourceProxyVisitor)new ResourceProxyVisitor(), 0);
    }

    void stop() {
        try {
            this.lock.acquire();
            this.stop_();
        }
        finally {
            this.lock.release();
        }
    }

    private void stop_() {
        InternalJaxbProjectManager.debug("*** JAXB project manager STOP ***");
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        FacetedProjectFramework.removeListener((IFacetedProjectListener)this.facetedProjectListener);
        this.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        try {
            this.eventHandler.stop();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.clearJaxbProjects();
    }

    private void clearJaxbProjects() {
        for (JaxbProject jaxbProject : this.getJaxbProjects_()) {
            this.removeJaxbProject(jaxbProject);
        }
    }

    @Override
    public Iterable<JaxbProject> getJaxbProjects() {
        try {
            this.lock.acquire();
            Iterable<JaxbProject> iterable = this.getJaxbProjects_();
            return iterable;
        }
        finally {
            this.lock.release();
        }
    }

    private Iterable<JaxbProject> getJaxbProjects_() {
        return IterableTools.cloneLive(this.jaxbProjects);
    }

    @Override
    public int getJaxbProjectsSize() {
        return this.jaxbProjects.size();
    }

    @Override
    public JaxbProject getJaxbProject(IProject project) {
        try {
            this.lock.acquire();
            JaxbProject jaxbProject = this.getJaxbProject_(project);
            return jaxbProject;
        }
        finally {
            this.lock.release();
        }
    }

    private JaxbProject getJaxbProject_(IProject project) {
        for (JaxbProject jaxbProject : this.jaxbProjects) {
            if (!jaxbProject.getProject().equals((Object)project)) continue;
            return jaxbProject;
        }
        return null;
    }

    @Override
    public JaxbFile getJaxbFile(IFile file) {
        JaxbProject jaxbProject = this.getJaxbProject(file.getProject());
        return jaxbProject == null ? null : jaxbProject.getJaxbFile(file);
    }

    @Override
    public void rebuildJaxbProject(IProject project) {
        try {
            this.lock.acquire();
            this.rebuildJaxbProject_(project);
        }
        finally {
            this.lock.release();
        }
    }

    private void rebuildJaxbProject_(IProject project) {
        this.removeJaxbProject(this.getJaxbProject_(project));
        this.addJaxbProject(project);
    }

    @Override
    public boolean javaElementChangeListenerIsActive() {
        return this.javaElementChangeListener.isActive();
    }

    @Override
    public void setJavaElementChangeListenerIsActive(boolean javaElementChangeListenerIsActive) {
        this.javaElementChangeListener.setActive(javaElementChangeListenerIsActive);
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public IJobManager getJobManager() {
        return Job.getJobManager();
    }

    void addJaxbProject(IProject project) {
        this.addJaxbProject(this.buildJaxbProject(project));
    }

    private void addJaxbProject(JaxbProject jaxbProject) {
        InternalJaxbProjectManager.dumpStackTrace("add: ", jaxbProject);
        if (jaxbProject != null) {
            this.addItemToCollection(jaxbProject, this.jaxbProjects, "jaxbProjects");
        }
    }

    private JaxbProject buildJaxbProject(IProject project) {
        return this.buildJaxbProject(this.buildJaxbProjectConfig(project));
    }

    private JaxbProject buildJaxbProject(JaxbProject.Config config) {
        JaxbPlatformDefinition platformDefinition = config.getPlatformDefinition();
        if (platformDefinition == null) {
            return null;
        }
        JaxbProject jaxbProject = this.buildJaxbProject(platformDefinition, config);
        if (jaxbProject == null) {
            return null;
        }
        jaxbProject.setContextModelSynchronizer(this.buildJobContextModelSynchronizer(jaxbProject));
        jaxbProject.setUpdateSynchronizer(this.buildJobUpdateSynchronizer(jaxbProject));
        return jaxbProject;
    }

    private JaxbProject buildJaxbProject(JaxbPlatformDefinition platformDefinition, JaxbProject.Config config) {
        try {
            return platformDefinition.getFactory().buildJaxbProject(config);
        }
        catch (RuntimeException ex) {
            JptJaxbCorePlugin.instance().logError(ex);
            return null;
        }
    }

    private JaxbProject.Config buildJaxbProjectConfig(IProject project) {
        SimpleJaxbProjectConfig config = new SimpleJaxbProjectConfig();
        config.setProject(project);
        config.setPlatformDefinition(this.getJaxbPlatformDefinition(project));
        return config;
    }

    private JaxbPlatformDefinition getJaxbPlatformDefinition(IProject project) {
        JaxbPlatformManager mgr = this.jaxbWorkspace.getJaxbPlatformManager();
        String jaxbPlatformID = JaxbPreferences.getJaxbPlatformID(project);
        if (jaxbPlatformID != null) {
            return mgr.getJaxbPlatformDefinition(jaxbPlatformID);
        }
        jaxbPlatformID = this.getDefaultJaxbPlatformID(project);
        return jaxbPlatformID == null ? null : mgr.getJaxbPlatformDefinition(jaxbPlatformID);
    }

    private String getDefaultJaxbPlatformID(IProject project) {
        IProjectFacetVersion jaxbFacetVersion = this.getJaxbFacetVersion(project);
        if (jaxbFacetVersion == null) {
            return null;
        }
        JaxbPlatformConfig config = this.jaxbWorkspace.getJaxbPlatformManager().getDefaultJaxbPlatformConfig(jaxbFacetVersion);
        return config == null ? null : config.getId();
    }

    private IProjectFacetVersion getJaxbFacetVersion(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project).getProjectFacetVersion(JaxbProject.FACET);
        }
        catch (CoreException ex) {
            JptJaxbCorePlugin.instance().logError(ex);
            return null;
        }
    }

    private Synchronizer buildJobContextModelSynchronizer(JaxbProject jaxbProject) {
        return new JobSynchronizer(this.buildContextModelJobName(jaxbProject), this.buildContextModelJobCommand(jaxbProject), (ISchedulingRule)jaxbProject.getProject());
    }

    private String buildContextModelJobName(JaxbProject jaxbProject) {
        return NLS.bind((String)JptJaxbCoreMessages.CONTEXT_MODEL_SYNC_JOB_NAME, (Object)jaxbProject.getName());
    }

    private JobCommand buildContextModelJobCommand(final JaxbProject jaxbProject) {
        return new JobCommand(){

            public IStatus execute(IProgressMonitor monitor) {
                return jaxbProject.synchronizeContextModel(monitor);
            }
        };
    }

    private CallbackSynchronizer buildJobUpdateSynchronizer(JaxbProject jaxbProject) {
        return new CallbackJobSynchronizer(this.buildUpdateJobName(jaxbProject), this.buildUpdateJobCommand(jaxbProject), (ISchedulingRule)jaxbProject.getProject());
    }

    private String buildUpdateJobName(JaxbProject jaxbProject) {
        return NLS.bind((String)JptJaxbCoreMessages.UPDATE_JOB_NAME, (Object)jaxbProject.getName());
    }

    private JobCommand buildUpdateJobCommand(final JaxbProject jaxbProject) {
        return new JobCommand(){

            public IStatus execute(IProgressMonitor monitor) {
                return jaxbProject.update(monitor);
            }
        };
    }

    void removeJaxbProject(JaxbProject jaxbProject) {
        InternalJaxbProjectManager.dumpStackTrace("remove: ", jaxbProject);
        this.removeItemFromCollection(jaxbProject, this.jaxbProjects, "jaxbProjects");
        jaxbProject.dispose();
    }

    void projectChanged(IResourceDelta delta) {
        this.eventHandler.execute(this.buildProjectChangedCommand(delta));
    }

    private Command buildProjectChangedCommand(final IResourceDelta delta) {
        return new EventHandlerCommand(this, "Project POST_CHANGE Command"){

            void execute_() {
                this.projectChanged_(delta);
            }
        };
    }

    void projectChanged_(IResourceDelta delta) {
        for (JaxbProject jaxbProject : this.jaxbProjects) {
            jaxbProject.projectChanged(delta);
        }
    }

    void projectPostCleanBuild(IProject project) {
        this.executeAfterEventsHandled(this.buildProjectPostCleanBuildCommand(project));
    }

    private Command buildProjectPostCleanBuildCommand(final IProject project) {
        return new EventHandlerCommand(this, "Project POST_BUILD (CLEAN_BUILD) Command"){

            void execute_() {
                this.projectPostCleanBuild_(project);
            }
        };
    }

    void projectPostCleanBuild_(IProject project) {
        JaxbProject jaxbProject = this.getJaxbProject_(project);
        if (jaxbProject != null) {
            this.removeJaxbProject(jaxbProject);
            this.addJaxbProject(project);
        }
    }

    void checkForJaxbFacetTransition(IProject project) {
        JaxbProject jaxbProject = this.getJaxbProject_(project);
        if (ProjectTools.hasFacet((IProject)project, (String)"jpt.jaxb")) {
            if (jaxbProject == null) {
                this.executeAfterEventsHandled(this.buildAddJaxbProjectCommand(project));
            }
        } else if (jaxbProject != null) {
            this.executeAfterEventsHandled(this.buildRemoveJaxbProjectCommand(jaxbProject));
        }
    }

    private Command buildAddJaxbProjectCommand(final IProject project) {
        return new EventHandlerCommand(this, "Add JAXB Project Command"){

            void execute_() {
                this.addJaxbProject(project);
            }
        };
    }

    private Command buildRemoveJaxbProjectCommand(final JaxbProject jaxbProject) {
        return new EventHandlerCommand(this, "Remove JAXB Project Command"){

            void execute_() {
                this.removeJaxbProject(jaxbProject);
            }
        };
    }

    void jaxbFacetedProjectPreUninstall(IProjectFacetActionEvent event) {
        IProject project = event.getProject().getProject();
        this.executeAfterEventsHandled(this.buildJaxbFacetedProjectPreUninstallCommand(project));
    }

    private Command buildJaxbFacetedProjectPreUninstallCommand(final IProject project) {
        return new EventHandlerCommand(this, "Faceted Project PRE_UNINSTALL Command"){

            void execute_() {
                this.jaxbFacetedProjectPreUninstall_(project);
            }
        };
    }

    void jaxbFacetedProjectPreUninstall_(IProject project) {
        this.removeJaxbProject(this.getJaxbProject_(project));
    }

    void javaElementChanged(ElementChangedEvent event) {
        this.eventHandler.execute(this.buildJavaElementChangedCommand(event));
    }

    private Command buildJavaElementChangedCommand(final ElementChangedEvent event) {
        return new EventHandlerCommand(this, "Java element changed Command"){

            void execute_() {
                this.javaElementChanged_(event);
            }
        };
    }

    void javaElementChanged_(ElementChangedEvent event) {
        for (JaxbProject jaxbProject : this.jaxbProjects) {
            jaxbProject.javaElementChanged(event);
        }
    }

    @Override
    public JaxbWorkspace getJaxbWorkspace() {
        return this.jaxbWorkspace;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.jaxbProjects);
    }

    private void executeAfterEventsHandled(Command command) {
        SynchronizedBoolean flag = new SynchronizedBoolean(false);
        this.eventHandler.execute((Command)new PauseCommand(flag));
        try {
            flag.waitUntilTrue();
        }
        catch (InterruptedException interruptedException) {}
        try {
            command.execute();
        }
        finally {
            flag.setFalse();
        }
    }

    public void handleEventsSynchronously() throws InterruptedException {
        try {
            this.lock.acquire();
            this.handleEventsSynchronously_();
        }
        finally {
            this.lock.release();
        }
    }

    private void handleEventsSynchronously_() throws InterruptedException {
        this.eventHandler.stop();
        this.eventHandler = new SimpleStatefulExtendedCommandContext();
        this.eventHandler.start();
    }

    static void debug(String message, Object object) {
    }

    static void debug(String message) {
    }

    private static void debug_(String message) {
        System.out.println(String.valueOf(Thread.currentThread().getName()) + ": " + message);
    }

    static void dumpStackTrace() {
        InternalJaxbProjectManager.dumpStackTrace(null);
    }

    static void dumpStackTrace(String message, Object object) {
    }

    static void dumpStackTrace(String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpStackTrace_(String message) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            if (message != null) {
                InternalJaxbProjectManager.debug_(message);
            }
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int i = 3;
            while (i < stackTrace.length) {
                StackTraceElement element = stackTrace[i];
                if (element.getMethodName().equals("invoke0")) break;
                System.out.println("\t" + element);
                ++i;
            }
        }
    }

    private abstract class EventHandlerCommand
    implements Command {
        private final String name;

        EventHandlerCommand(String name) {
            this.name = name;
        }

        public final void execute() {
            try {
                try {
                    InternalJaxbProjectManager.this.lock.acquire();
                    this.execute_();
                }
                catch (RuntimeException ex) {
                    JptJaxbCorePlugin.instance().logError(ex);
                    InternalJaxbProjectManager.this.lock.release();
                }
            }
            finally {
                InternalJaxbProjectManager.this.lock.release();
            }
        }

        abstract void execute_();

        public String toString() {
            return this.name;
        }
    }

    private class FacetedProjectListener
    implements IFacetedProjectListener {
        FacetedProjectListener() {
        }

        public void handleEvent(IFacetedProjectEvent event) {
            switch (event.getType()) {
                case PRE_UNINSTALL: {
                    this.processPreUninstallEvent((IProjectFacetActionEvent)event);
                    break;
                }
            }
        }

        private void processPreUninstallEvent(IProjectFacetActionEvent event) {
            InternalJaxbProjectManager.debug("Facet PRE_UNINSTALL: ", event.getProjectFacet());
            if (event.getProjectFacet().equals(JaxbProject.FACET)) {
                InternalJaxbProjectManager.this.jaxbFacetedProjectPreUninstall(event);
            }
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    private class JavaElementChangeListener
    implements IElementChangedListener {
        private volatile boolean active = true;

        JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.active) {
                InternalJaxbProjectManager.this.javaElementChanged(event);
            }
        }

        void setActive(boolean active) {
            this.active = active;
        }

        boolean isActive() {
            return this.active;
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    class LocalExceptionHandler
    extends ExceptionHandlerAdapter {
        LocalExceptionHandler() {
        }

        public void handleException(Throwable t) {
            JptJaxbCorePlugin.instance().logError(t);
        }
    }

    private static class PauseCommand
    implements Command {
        private final Thread producerThread;
        private final SynchronizedBoolean flag;

        PauseCommand(SynchronizedBoolean flag) {
            this(Thread.currentThread(), flag);
        }

        PauseCommand(Thread producerThread, SynchronizedBoolean flag) {
            this.producerThread = producerThread;
            this.flag = flag;
        }

        public void execute() {
            this.flag.setTrue();
            if (Thread.currentThread() != this.producerThread) {
                try {
                    this.flag.waitUntilFalse();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 1: {
                    this.processPostChangeEvent(event);
                    break;
                }
                case 32: {
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    this.processPostBuildEvent(event);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
            }
        }

        private void processPostChangeEvent(IResourceChangeEvent event) {
            InternalJaxbProjectManager.debug("Resource POST_CHANGE");
            this.processPostChangeDelta(event.getDelta());
        }

        private void processPostChangeDelta(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    this.processPostChangeRootDelta(delta);
                    break;
                }
                case 4: {
                    this.processPostChangeProjectDelta(delta);
                    break;
                }
                case 2: {
                    this.processPostChangeFolderDelta((IFolder)resource, delta);
                    break;
                }
                case 1: {
                    this.processPostChangeFileDelta((IFile)resource, delta);
                    break;
                }
            }
        }

        private void processPostChangeRootDelta(IResourceDelta delta) {
            this.processPostChangeDeltaChildren(delta);
        }

        private void processPostChangeProjectDelta(IResourceDelta delta) {
            InternalJaxbProjectManager.this.projectChanged(delta);
            this.processPostChangeDeltaChildren(delta);
        }

        private void processPostChangeFolderDelta(IFolder folder, IResourceDelta delta) {
            if (folder.getName().equals(".settings")) {
                this.processPostChangeDeltaChildren(delta);
            }
        }

        private void processPostChangeFileDelta(IFile file, IResourceDelta delta) {
            if (file.getName().equals(InternalJaxbProjectManager.FACETED_PROJECT_FRAMEWORK_SETTINGS_FILE_NAME)) {
                this.checkForFacetFileChanges(file, delta);
            }
        }

        private void checkForFacetFileChanges(IFile file, IResourceDelta delta) {
            switch (delta.getKind()) {
                case 1: 
                case 2: 
                case 4: {
                    InternalJaxbProjectManager.this.checkForJaxbFacetTransition(file.getProject());
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    break;
                }
            }
        }

        private void processPostChangeDeltaChildren(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.processPostChangeDelta(child);
                ++n2;
            }
        }

        private void processPostBuildEvent(IResourceChangeEvent event) {
            InternalJaxbProjectManager.debug("Resource POST_BUILD: ", event.getResource());
            if (event.getBuildKind() == 15) {
                this.processPostCleanBuildDelta(event.getDelta());
            }
        }

        private void processPostCleanBuildDelta(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    this.processPostCleanBuildDeltaChildren(delta);
                    break;
                }
                case 4: {
                    this.processProjectPostCleanBuild((IProject)resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
            }
        }

        private void processPostCleanBuildDeltaChildren(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.processPostCleanBuildDelta(child);
                ++n2;
            }
        }

        private void processProjectPostCleanBuild(IProject project) {
            InternalJaxbProjectManager.debug("\tProject CLEAN: ", project.getName());
            InternalJaxbProjectManager.this.projectPostCleanBuild(project);
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    private class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        ResourceProxyVisitor() {
        }

        public boolean visit(IResourceProxy resourceProxy) {
            switch (resourceProxy.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    this.processProject(resourceProxy);
                    return false;
                }
                case 2: {
                    return false;
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }

        private void processProject(IResourceProxy resourceProxy) {
            IProject project;
            if (resourceProxy.isAccessible() && ProjectTools.hasFacet((IProject)(project = (IProject)resourceProxy.requestResource()), (String)"jpt.jaxb")) {
                InternalJaxbProjectManager.this.addJaxbProject(project);
            }
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }
}

