/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.context;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.internal.context.AbstractJaxbContextNode;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQName
extends AbstractJaxbContextNode
implements JaxbQName {
    protected final ResourceProxy proxy;
    protected String namespace;
    protected String defaultNamespace;
    protected String specifiedNamespace;
    protected String name;
    protected String defaultName;
    protected String specifiedName;

    protected AbstractQName(JaxbContextNode parent, ResourceProxy proxy) {
        super(parent);
        this.proxy = proxy;
        this.specifiedNamespace = this.getResourceNamespace();
        this.specifiedName = this.getResourceName();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncNamespace();
        this.syncName();
    }

    @Override
    public void update() {
        super.update();
        this.updateNamespace();
        this.updateName();
    }

    protected abstract JaxbPackage getJaxbPackage();

    protected final XsdSchema getXsdSchema() {
        JaxbPackage jaxbPackage = this.getJaxbPackage();
        return jaxbPackage == null ? null : jaxbPackage.getXsdSchema();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    protected void setNamespace_(String newNamespace) {
        String oldNamespace = this.namespace;
        this.namespace = newNamespace;
        this.firePropertyChanged("namespace", oldNamespace, newNamespace);
    }

    @Override
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    protected void setDefaultNamespace_(String newDefaultNamespace) {
        String oldDefaultNamespace = this.defaultNamespace;
        this.defaultNamespace = newDefaultNamespace;
        this.firePropertyChanged("defaultNamespace", oldDefaultNamespace, newDefaultNamespace);
    }

    @Override
    public String getSpecifiedNamespace() {
        return this.specifiedNamespace;
    }

    @Override
    public void setSpecifiedNamespace(String newSpecifiedNamespace) {
        this.setResourceNamespace(newSpecifiedNamespace);
        this.setSpecifiedNamespace_(newSpecifiedNamespace);
    }

    protected void setSpecifiedNamespace_(String newSpecifiedNamespace) {
        String oldNamespace = this.specifiedNamespace;
        this.specifiedNamespace = newSpecifiedNamespace;
        this.firePropertyChanged("specifiedNamespace", oldNamespace, newSpecifiedNamespace);
    }

    protected abstract String buildDefaultNamespace();

    protected String getResourceNamespace() {
        return this.proxy.getNamespace();
    }

    protected void setResourceNamespace(String newNamespace) {
        this.proxy.setNamespace(newNamespace);
    }

    protected void syncNamespace() {
        this.setSpecifiedNamespace_(this.getResourceNamespace());
    }

    protected void updateNamespace() {
        this.setDefaultNamespace_(this.buildDefaultNamespace());
        String namespace = this.specifiedNamespace;
        if (StringTools.isBlank((String)namespace) || ObjectTools.equals((Object)namespace, (Object)"##default")) {
            namespace = this.defaultNamespace;
        }
        this.setNamespace_(namespace);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("name", oldName, newName);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName_(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultName", oldDefaultName, newDefaultName);
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        this.setResourceName(newSpecifiedName);
        this.setSpecifiedName_(newSpecifiedName);
    }

    protected void setSpecifiedName_(String newSpecifiedName) {
        String old = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.firePropertyChanged("specifiedName", old, newSpecifiedName);
    }

    protected abstract String buildDefaultName();

    protected String getResourceName() {
        return this.proxy.getName();
    }

    protected void setResourceName(String newName) {
        this.proxy.setName(newName);
    }

    protected void syncName() {
        this.setSpecifiedName_(this.getResourceName());
    }

    protected void updateName() {
        this.setDefaultName_(this.buildDefaultName());
        String name = this.specifiedName;
        if (name == null || ObjectTools.equals((Object)name, (Object)"##default")) {
            name = this.defaultName;
        }
        this.setName_(name);
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        if (this.proxy.namespaceTouches(pos)) {
            return this.getNamespaceProposals();
        }
        if (this.proxy.nameTouches(pos)) {
            return this.getNameProposals();
        }
        return EmptyIterable.instance();
    }

    protected abstract Iterable<String> getNamespaceProposals();

    protected abstract Iterable<String> getNameProposals();

    @Override
    public TextRange getValidationTextRange() {
        return this.getParent().getValidationTextRange();
    }

    protected TextRange getTextRange(TextRange textRange) {
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getNamespaceValidationTextRange() {
        return this.getTextRange(this.proxy.getNamespaceValidationTextRange());
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.getTextRange(this.proxy.getNameValidationTextRange());
    }

    protected String getReferencedComponentTypeDescription() {
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateName(messages, reporter);
        if (!StringTools.isBlank((String)this.getName())) {
            this.validateReference(messages, reporter);
        }
    }

    protected void validateName(List<IMessage> messages, IReporter reporter) {
        if (StringTools.isBlank((String)this.getName())) {
            messages.add(this.buildValidationMessage(this.getNameValidationTextRange(), JptJaxbCoreValidationMessages.QNAME__MISSING_NAME, this.getReferencedComponentTypeDescription()));
        }
    }

    protected abstract void validateReference(List<IMessage> var1, IReporter var2);

    protected IMessage getUnresolveSchemaComponentMessage() {
        return this.buildValidationMessage(this.getNameValidationTextRange(), JptJaxbCoreValidationMessages.QNAME__UNRESOLVED_COMPONENT, this.getReferencedComponentTypeDescription(), this.getNamespace(), this.getName());
    }

    public static interface ResourceProxy {
        public String getNamespace();

        public void setNamespace(String var1);

        public boolean namespaceTouches(int var1);

        public TextRange getNamespaceValidationTextRange();

        public String getName();

        public void setName(String var1);

        public boolean nameTouches(int var1);

        public TextRange getNameValidationTextRange();
    }
}

