/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.discovery.operation;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileModificationJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractCreateMavenProjectsOperation;
import org.eclipse.m2e.internal.discovery.startup.UpdateConfigurationStartup;

public class RestartInstallOperation
extends InstallOperation {
    private int restartPolicy;
    private final ProvisioningSession session;
    private final Collection<IInstallableUnit> toInstall;
    private final IRunnableWithProgress postInstallHook;
    private Collection<String> projectsToConfigure;

    public RestartInstallOperation(ProvisioningSession session, Collection<IInstallableUnit> toInstall, IRunnableWithProgress postInstallHook) {
        this(session, toInstall, postInstallHook, null, 3);
    }

    public RestartInstallOperation(ProvisioningSession session, Collection<IInstallableUnit> toInstall, IRunnableWithProgress postInstallHook, Collection<String> projectsToConfigure, int restartPolicy) {
        super(session, toInstall);
        this.session = session;
        this.toInstall = toInstall;
        this.postInstallHook = postInstallHook;
        this.projectsToConfigure = projectsToConfigure;
        this.restartPolicy = restartPolicy;
    }

    public ProvisioningJob getProvisioningJob(IProgressMonitor monitor) {
        ProvisioningJob job = super.getProvisioningJob(monitor);
        if (job != null && job instanceof ProfileModificationJob) {
            ((ProfileModificationJob)job).setRestartPolicy(this.restartPolicy);
            UpdateMavenConfigurationProvisioningJob ucJob = new UpdateMavenConfigurationProvisioningJob((ProfileModificationJob)job, this.session, this.postInstallHook, this.projectsToConfigure);
            return ucJob;
        }
        return job;
    }

    public int getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(int restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public Collection<IInstallableUnit> getIUs() {
        return this.toInstall;
    }

    public RestartInstallOperation copy(Collection<IInstallableUnit> toInstall) {
        return new RestartInstallOperation(this.session, toInstall, this.postInstallHook, this.projectsToConfigure, this.restartPolicy);
    }

    private static class UpdateMavenConfigurationProvisioningJob
    extends ProfileModificationJob {
        private ProfileModificationJob job;
        private final IRunnableWithProgress postInstallHook;
        private Collection<String> projectsToConfigure;

        public UpdateMavenConfigurationProvisioningJob(ProfileModificationJob job, ProvisioningSession session, IRunnableWithProgress postInstallHook, Collection<String> projectsToConfigure) {
            super(job.getName(), session, job.getProfileId(), null, null);
            this.job = job;
            this.postInstallHook = postInstallHook;
            this.projectsToConfigure = projectsToConfigure;
        }

        public IStatus runModal(IProgressMonitor monitor) {
            IStatus status = this.job.run(monitor);
            if (status.isOK() && this.postInstallHook != null) {
                try {
                    this.postInstallHook.run(monitor);
                }
                catch (InvocationTargetException e) {
                    return AbstractCreateMavenProjectsOperation.toStatus((InvocationTargetException)e);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
            }
            if (status.isOK()) {
                if (this.getRestartPolicy() == 1) {
                    UpdateConfigurationStartup.updateConfiguration();
                } else {
                    UpdateConfigurationStartup.enableStartup(this.projectsToConfigure);
                }
            }
            return status;
        }

        public String getProfileId() {
            return this.job.getProfileId();
        }

        public int getRestartPolicy() {
            return this.job.getRestartPolicy();
        }
    }
}

