/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.discovery.operation;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.m2e.internal.discovery.MavenDiscovery;
import org.eclipse.m2e.internal.discovery.Messages;
import org.eclipse.m2e.internal.discovery.operation.RestartInstallOperation;
import org.eclipse.osgi.util.NLS;

public class MavenDiscoveryInstallOperation
implements IRunnableWithProgress {
    private Collection<CatalogItem> installableConnectors;
    private ProvisioningSession session;
    private Set<URI> repositoryLocations;
    private final boolean restart;
    private List<IStatus> statuses = new ArrayList<IStatus>();
    private RestartInstallOperation operation;
    private final IRunnableWithProgress postInstallHook;
    private Collection<String> projectsToConfigure;
    private boolean shouldResolve;

    public MavenDiscoveryInstallOperation(Collection<CatalogItem> installableConnectors, IRunnableWithProgress postInstallHook, boolean restart) {
        this(installableConnectors, postInstallHook, restart, true, null);
    }

    public MavenDiscoveryInstallOperation(Collection<CatalogItem> installableConnectors, IRunnableWithProgress postInstallHook, boolean restart, boolean shouldResolve, Collection<String> projectsToConfigure) {
        this.installableConnectors = installableConnectors;
        this.postInstallHook = postInstallHook;
        this.restart = restart;
        this.session = ProvisioningUI.getDefaultUI().getSession();
        this.shouldResolve = shouldResolve;
        this.projectsToConfigure = projectsToConfigure;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.MavenDiscoveryInstallOperation_Configuring, (int)100);
            try {
                IInstallableUnit[] ius = this.computeInstallableUnits((IProgressMonitor)monitor.newChild(50));
                this.checkCancelled((IProgressMonitor)monitor);
                this.operation = this.createAndResolve((IProgressMonitor)monitor.newChild(50), ius, new URI[]{}, this.restart && MavenDiscovery.requireRestart(this.installableConnectors));
                this.checkCancelled((IProgressMonitor)monitor);
            }
            finally {
                monitor.done();
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public RestartInstallOperation getOperation() {
        return this.operation;
    }

    public IInstallableUnit[] computeInstallableUnits(IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
        try {
            List<IMetadataRepository> repositories = this.addRepositories(monitor.newChild(50));
            Collection<IInstallableUnit> installableUnits = this.queryInstallableUnits((IProgressMonitor)monitor.newChild(50), repositories);
            if (!this.statuses.isEmpty()) {
                throw new CoreException((IStatus)new MultiStatus("org.eclipse.m2e.discovery", 0, this.statuses.toArray(new IStatus[this.statuses.size()]), Messages.MavenDiscoveryInstallOperation_ErrorMessage, null));
            }
            IInstallableUnit[] iInstallableUnitArray = installableUnits.toArray(new IInstallableUnit[installableUnits.size()]);
            return iInstallableUnitArray;
        }
        finally {
            monitor.done();
        }
    }

    private Collection<IInstallableUnit> queryInstallableUnits(IProgressMonitor progressMonitor, List<IMetadataRepository> repositories) {
        HashSet<IInstallableUnit> installableUnits = new HashSet<IInstallableUnit>(this.installableConnectors.size());
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)this.installableConnectors.size());
        try {
            for (CatalogItem item : this.installableConnectors) {
                SubMonitor subMon = monitor.newChild(1);
                this.checkCancelled((IProgressMonitor)monitor);
                URI address = URI.create(item.getSiteUrl());
                IMetadataRepository repository = null;
                for (IMetadataRepository candidate : repositories) {
                    if (!address.equals(candidate.getLocation())) continue;
                    repository = candidate;
                    break;
                }
                if (repository == null) {
                    this.statuses.add((IStatus)new Status(4, "org.eclipse.m2e.discovery", NLS.bind((String)Messages.MavenDiscoveryInstallOperation_missingRepository, (Object)item.getName(), (Object)item.getSiteUrl())));
                    continue;
                }
                this.checkCancelled((IProgressMonitor)monitor);
                Set<IVersionedId> ids = this.getDescriptorIds(repository);
                for (IVersionedId versionedId : ids) {
                    IQueryResult result = repository.query(QueryUtil.createIUQuery((IVersionedId)versionedId), (IProgressMonitor)subMon.newChild(1));
                    Set matches = result.toSet();
                    if (matches.size() == 1) {
                        installableUnits.addAll(matches);
                        continue;
                    }
                    if (matches.size() == 0) {
                        this.statuses.add((IStatus)new Status(4, "org.eclipse.m2e.discovery", NLS.bind((String)Messages.MavenDiscoveryInstallOperation_missingIU, (Object)item.getName(), (Object)versionedId.toString())));
                        continue;
                    }
                    IInstallableUnit match = null;
                    for (IInstallableUnit iu : matches) {
                        if (match != null && iu.getVersion().compareTo((Object)match.getVersion()) <= 0) continue;
                        match = iu;
                    }
                    if (match == null) continue;
                    installableUnits.add(match);
                }
            }
            HashSet<IInstallableUnit> hashSet = installableUnits;
            return hashSet;
        }
        finally {
            monitor.done();
        }
    }

    protected Set<IVersionedId> getDescriptorIds(IMetadataRepository repository) {
        HashSet<IVersionedId> ids = new HashSet<IVersionedId>();
        for (CatalogItem item : this.installableConnectors) {
            if (!repository.getLocation().equals(URI.create(item.getSiteUrl()))) continue;
            for (String id : item.getInstallableUnits()) {
                ids.add(VersionedId.parse((String)id));
            }
        }
        return ids;
    }

    protected List<IMetadataRepository> addRepositories(SubMonitor monitor) {
        RepositoryTracker repositoryTracker = ProvisioningUI.getDefaultUI().getRepositoryTracker();
        this.repositoryLocations = new HashSet<URI>();
        monitor.setWorkRemaining(this.installableConnectors.size() * 5);
        for (CatalogItem descriptor : this.installableConnectors) {
            URI uri = URI.create(descriptor.getSiteUrl());
            if (this.repositoryLocations.add(uri)) {
                this.checkCancelled((IProgressMonitor)monitor);
                repositoryTracker.addRepository(uri, null, this.session);
            }
            monitor.worked(1);
        }
        ArrayList<IMetadataRepository> repositories = new ArrayList<IMetadataRepository>();
        monitor.setWorkRemaining(repositories.size());
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)this.session.getProvisioningAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        for (URI uri : this.repositoryLocations) {
            this.checkCancelled((IProgressMonitor)monitor);
            try {
                IMetadataRepository repository = manager.loadRepository(uri, (IProgressMonitor)monitor.newChild(1));
                repositories.add(repository);
            }
            catch (ProvisionException e) {
                this.statuses.add(e.getStatus());
            }
        }
        return repositories;
    }

    private RestartInstallOperation createAndResolve(IProgressMonitor monitor, IInstallableUnit[] ius, URI[] repositories, boolean requireRestart) throws CoreException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)ius.length);
        try {
            IStatus operationStatus;
            RestartInstallOperation op = new RestartInstallOperation(this.session, Arrays.asList(ius), this.postInstallHook, this.projectsToConfigure, requireRestart ? 3 : 1);
            if (this.shouldResolve && (operationStatus = op.resolveModal((IProgressMonitor)mon)).getSeverity() > 2) {
                throw new CoreException(operationStatus);
            }
            RestartInstallOperation restartInstallOperation = op;
            return restartInstallOperation;
        }
        finally {
            mon.done();
        }
    }

    private void checkCancelled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

