/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.classpathdep;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyComponent;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyValidator;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyVirtualComponent;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathDependencyUtil
implements IClasspathDependencyConstants {
    @Deprecated
    public static Map<IClasspathEntry, IClasspathAttribute> getRawComponentClasspathDependencies(IJavaProject javaProject) throws CoreException {
        return ClasspathDependencyUtil.getRawComponentClasspathDependencies(javaProject, IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY);
    }

    @Deprecated
    public static Map<IClasspathEntry, IClasspathAttribute> getRawComponentClasspathDependencies(IJavaProject javaProject, IClasspathDependencyConstants.DependencyAttributeType attributeType) throws CoreException {
        return ClasspathDependencyUtil.getRawComponentClasspathDependencies(JavaCoreLite.create((IJavaProject)javaProject), attributeType);
    }

    public static Map<IClasspathEntry, IClasspathAttribute> getRawComponentClasspathDependencies(IJavaProjectLite javaProjectLite, IClasspathDependencyConstants.DependencyAttributeType attributeType) throws CoreException {
        return ClasspathDependencyUtil.getRawComponentClasspathDependencies(javaProjectLite, attributeType, false);
    }

    public static Map<IClasspathEntry, IClasspathAttribute> getRawComponentClasspathDependencies(IJavaProjectLite javaProjectLite, IClasspathDependencyConstants.DependencyAttributeType attributeType, boolean isLegacyJ2EE) throws CoreException {
        IClasspathEntry[] entries;
        if (javaProjectLite == null) {
            return Collections.emptyMap();
        }
        HashMap<IClasspathEntry, IClasspathAttribute> referencedRawEntries = new HashMap<IClasspathEntry, IClasspathAttribute>();
        IClasspathEntry[] iClasspathEntryArray = entries = javaProjectLite.readRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            IClasspathAttribute attrib = ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry, attributeType, isLegacyJ2EE);
            if (attrib != null) {
                referencedRawEntries.put(entry, attrib);
            }
            ++n2;
        }
        return referencedRawEntries;
    }

    @Deprecated
    public static List<IClasspathEntry> getPotentialComponentClasspathDependencies(IJavaProject javaProject) throws CoreException {
        return ClasspathDependencyUtil.getPotentialComponentClasspathDependencies(JavaCoreLite.create((IJavaProject)javaProject));
    }

    public static List<IClasspathEntry> getPotentialComponentClasspathDependencies(IJavaProjectLite javaProjectLite) throws CoreException {
        return ClasspathDependencyUtil.getPotentialComponentClasspathDependencies(javaProjectLite, false);
    }

    public static List<IClasspathEntry> getPotentialComponentClasspathDependencies(IJavaProjectLite javaProjectLite, boolean isLegacyJ2EE) throws CoreException {
        ArrayList<IClasspathEntry> potentialRawEntries = new ArrayList<IClasspathEntry>();
        if (javaProjectLite == null || !javaProjectLite.getProject().isAccessible()) {
            return Collections.emptyList();
        }
        IProject project = javaProjectLite.getProject();
        boolean isWebApp = JavaEEProjectUtilities.isDynamicWebProject(project);
        boolean isRAR = JavaEEProjectUtilities.isJCAProject(project);
        ClasspathDependencyValidator.ClasspathDependencyValidatorData data = new ClasspathDependencyValidator.ClasspathDependencyValidatorData(project);
        IClasspathEntry[] entries = javaProjectLite.readRawClasspath();
        int i = 0;
        while (i < entries.length) {
            block23: {
                IClasspathEntry entry;
                block24: {
                    IProject[] earProjects;
                    boolean foundEntry;
                    block25: {
                        boolean isFile;
                        entry = entries[i];
                        IClasspathAttribute attrib = ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry, IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY, isLegacyJ2EE);
                        if (attrib != null) break block23;
                        IMessage[] msgs = ClasspathDependencyValidator.validateVirtualComponentEntry(entry, null, true, project, data);
                        boolean error = false;
                        int j = 0;
                        while (j < msgs.length) {
                            if (msgs[j].getSeverity() == 1) {
                                error = true;
                                break;
                            }
                            ++j;
                        }
                        if (error) break block23;
                        if (1 != entry.getEntryKind()) break block24;
                        boolean bl = isFile = !ClasspathDependencyUtil.isClassFolderEntry(entry);
                        if (!isFile) break block24;
                        foundEntry = false;
                        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                        if (isWebApp) {
                            IContainer[] webLibFolders;
                            IContainer[] iContainerArray = webLibFolders = component.getRootFolder().getFolder(WEB_INF_LIB_PATH).getUnderlyingFolders();
                            int n = webLibFolders.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IContainer webLib = iContainerArray[n2];
                                IPath webLibFolderPath = webLib.getFullPath();
                                if (webLibFolderPath.equals((Object)entry.getPath().removeLastSegments(1))) {
                                    foundEntry = true;
                                    break;
                                }
                                ++n2;
                            }
                        } else if (isRAR) {
                            IContainer[] rootFolders;
                            IContainer[] iContainerArray = rootFolders = component.getRootFolder().getUnderlyingFolders();
                            int n = rootFolders.length;
                            int n3 = 0;
                            while (n3 < n) {
                                IContainer root = iContainerArray[n3];
                                IPath rootPath = root.getFullPath();
                                if (rootPath.isPrefixOf(entry.getPath())) {
                                    foundEntry = true;
                                    break;
                                }
                                ++n3;
                            }
                        }
                        if (foundEntry) break block23;
                        List manifestRefs = J2EEModuleVirtualComponent.getManifestReferences(component, null);
                        if (manifestRefs == null) break block25;
                        int j2 = 0;
                        while (j2 < manifestRefs.size()) {
                            IFile file;
                            IVirtualReference ref = (IVirtualReference)manifestRefs.get(j2);
                            IVirtualComponent c = ref.getReferencedComponent();
                            if (c.isBinary() && (file = (IFile)c.getAdapter(IFile.class)) != null && file.getFullPath().equals((Object)entry.getPath())) {
                                foundEntry = true;
                                break;
                            }
                            ++j2;
                        }
                        if (foundEntry) break block23;
                    }
                    IProject[] iProjectArray = earProjects = EarUtilities.getReferencingEARProjects(project);
                    int n = earProjects.length;
                    int n4 = 0;
                    while (n4 < n) {
                        IProject earProject = iProjectArray[n4];
                        String earDDVersion = EarUtilities.getJ2EEDDProjectVersion(earProject);
                        if (!(earDDVersion.equals("1.2") || earDDVersion.equals("1.3") || earDDVersion.equals("1.4"))) {
                            IContainer[] earLibFolders;
                            IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
                            Application app = (Application)ModelProviderManager.getModelProvider(earComponent).getModelObject();
                            String libDir = app.getLibraryDirectory();
                            if (libDir == null) {
                                libDir = "lib";
                            }
                            IContainer[] iContainerArray = earLibFolders = earComponent.getRootFolder().getFolder((IPath)new Path(libDir)).getUnderlyingFolders();
                            int n5 = earLibFolders.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IContainer earLib = iContainerArray[n6];
                                IPath earLibFolderPath = earLib.getFullPath();
                                if (earLibFolderPath.equals((Object)entry.getPath().removeLastSegments(1))) {
                                    foundEntry = true;
                                    break;
                                }
                                ++n6;
                            }
                            if (foundEntry) break;
                        }
                        ++n4;
                    }
                    if (foundEntry) break block23;
                }
                potentialRawEntries.add(entry);
            }
            ++i;
        }
        return potentialRawEntries;
    }

    private static boolean isValid(IClasspathEntry entry, IClasspathAttribute attrib, boolean isWebApp, IProject project, ClasspathDependencyValidator.ClasspathDependencyValidatorData data) {
        IMessage[] msgs = ClasspathDependencyValidator.validateVirtualComponentEntry(entry, attrib, isWebApp, project, data);
        boolean valid = true;
        int j = 0;
        while (j < msgs.length) {
            if (msgs[j].getSeverity() == 1) {
                valid = false;
                break;
            }
            ++j;
        }
        return valid;
    }

    public static Map<IClasspathEntry, IClasspathAttribute> getComponentClasspathDependencies(IJavaProjectLite javaProjectLite, boolean isLegacyJ2EE) throws CoreException {
        return ClasspathDependencyUtil.getComponentClasspathDependencies(javaProjectLite, isLegacyJ2EE, true);
    }

    @Deprecated
    public static Map<IClasspathEntry, IClasspathAttribute> getComponentClasspathDependencies(IJavaProject javaProject, boolean isLegacyJ2EE) throws CoreException {
        return ClasspathDependencyUtil.getComponentClasspathDependencies(JavaCoreLite.create((IJavaProject)javaProject), isLegacyJ2EE);
    }

    @Deprecated
    public static Map<IClasspathEntry, IClasspathAttribute> getComponentClasspathDependencies(IJavaProject javaProject, boolean isWebApp, boolean onlyValid) throws CoreException {
        return ClasspathDependencyUtil.getComponentClasspathDependencies(JavaCoreLite.create((IJavaProject)javaProject), isWebApp, onlyValid);
    }

    public static Map<IClasspathEntry, IClasspathAttribute> getComponentClasspathDependencies(IJavaProjectLite javaProjectLite, boolean isLegacyJ2EE, boolean onlyValid) throws CoreException {
        IPackageFragmentRoot[] roots;
        ClasspathDependencyValidator.ClasspathDependencyValidatorData data = new ClasspathDependencyValidator.ClasspathDependencyValidatorData(javaProjectLite.getProject());
        boolean isWebApp = JavaEEProjectUtilities.isDynamicWebProject(javaProjectLite.getProject());
        Map<IClasspathEntry, IClasspathAttribute> referencedRawEntries = ClasspathDependencyUtil.getRawComponentClasspathDependencies(javaProjectLite, IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY, isLegacyJ2EE);
        HashMap<IClasspathEntry, IClasspathAttribute> validRawEntries = new HashMap<IClasspathEntry, IClasspathAttribute>();
        HashMap<IClasspathEntry, IClasspathAttribute> validRawClassPathContainerEntries = new HashMap<IClasspathEntry, IClasspathAttribute>();
        for (IClasspathEntry entry : referencedRawEntries.keySet()) {
            IClasspathAttribute attrib;
            if (!ClasspathDependencyUtil.isValid(entry, attrib = referencedRawEntries.get(entry), isWebApp, javaProjectLite.getProject(), data)) continue;
            if (entry.getEntryKind() == 5) {
                validRawClassPathContainerEntries.put(entry, attrib);
                continue;
            }
            validRawEntries.put(entry, attrib);
        }
        if (validRawEntries.isEmpty() && validRawClassPathContainerEntries.isEmpty()) {
            return Collections.emptyMap();
        }
        IJavaProject javaProject = JavaCore.create((IProject)javaProjectLite.getProject());
        IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
        HashMap<IPath, IClasspathEntry> pathToResolvedEntry = new HashMap<IPath, IClasspathEntry>();
        int j = 0;
        while (j < entries.length) {
            pathToResolvedEntry.put(entries[j].getPath(), entries[j]);
            ++j;
        }
        LinkedHashMap<IClasspathEntry, IClasspathAttribute> resolvedEntries = new LinkedHashMap<IClasspathEntry, IClasspathAttribute>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            IClasspathEntry rawEntry = root.getRawClasspathEntry();
            IClasspathAttribute attrib = (IClasspathAttribute)validRawEntries.get(rawEntry);
            if (attrib != null) {
                IPath pkgFragPath = root.getPath();
                IClasspathEntry resolvedEntry = (IClasspathEntry)pathToResolvedEntry.get(pkgFragPath);
                resolvedEntries.put(resolvedEntry, attrib);
            }
            ++n2;
        }
        for (Map.Entry entry : validRawClassPathContainerEntries.entrySet()) {
            IClasspathEntry[] classpathContainerEntries;
            IClasspathContainer classpathContainer = JavaCore.getClasspathContainer((IPath)((IClasspathEntry)entry.getKey()).getPath(), (IJavaProject)javaProject);
            if (classpathContainer == null || (classpathContainerEntries = classpathContainer.getClasspathEntries()) == null) continue;
            int j2 = 0;
            while (j2 < classpathContainerEntries.length) {
                resolvedEntries.put(classpathContainerEntries[j2], (IClasspathAttribute)entry.getValue());
                ++j2;
            }
        }
        LinkedHashMap<IClasspathEntry, IClasspathAttribute> referencedEntries = new LinkedHashMap<IClasspathEntry, IClasspathAttribute>();
        for (Map.Entry mapEntry : resolvedEntries.entrySet()) {
            IClasspathEntry resolvedEntry = (IClasspathEntry)mapEntry.getKey();
            IClasspathAttribute attrib = (IClasspathAttribute)mapEntry.getValue();
            IClasspathAttribute resolvedAttrib = ClasspathDependencyUtil.checkForComponentDependencyAttribute(resolvedEntry, IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY, isLegacyJ2EE);
            if (resolvedAttrib != null && !resolvedAttrib.getName().equals("org.eclipse.jst.component.dependency") || onlyValid && !ClasspathDependencyUtil.isValid(resolvedEntry, resolvedAttrib != null ? resolvedAttrib : attrib, isWebApp, javaProjectLite.getProject(), data)) continue;
            if (resolvedAttrib != null) {
                attrib = resolvedAttrib;
            }
            referencedEntries.put(resolvedEntry, attrib);
        }
        return referencedEntries;
    }

    public static IPath getEntryLocation(IClasspathEntry entry) {
        IPath entryPath;
        if (entry == null) {
            return null;
        }
        IPath entryLocation = entryPath = entry.getPath();
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
        if (resource != null) {
            entryLocation = resource.getLocation();
        }
        return entryLocation;
    }

    public static IResource getEntryResource(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        IPath entryPath = entry.getPath();
        return ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
    }

    public static IProject isClasspathProjectReference(IVirtualReference ref) {
        if (ref != null && ref.getReferencedComponent() instanceof IClasspathDependencyComponent) {
            return ref.getReferencedComponent().getProject();
        }
        return null;
    }

    public static boolean isClassFolderEntry(IClasspathEntry entry) {
        IPath entryPath;
        if (entry == null || entry.getEntryKind() != 1) {
            return false;
        }
        IPath entryLocation = entryPath = entry.getPath();
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
        if (resource != null) {
            entryLocation = resource.getLocation();
        }
        boolean isFile = true;
        if (entryLocation.toFile().isDirectory()) {
            isFile = false;
        }
        return !isFile;
    }

    public static IPath getClasspathVirtualReferenceLocation(IVirtualReference ref) {
        if (ref != null && ref.getReferencedComponent() instanceof IClasspathDependencyComponent) {
            return (IPath)ref.getReferencedComponent().getAdapter(IPath.class);
        }
        return null;
    }

    public static IPath getRuntimePath(IClasspathAttribute attrib, boolean isWebApp, boolean isClassFolder) {
        if (attrib != null && !attrib.getName().equals("org.eclipse.jst.component.dependency")) {
            return null;
        }
        if (attrib == null || attrib.getValue() == null || attrib.getValue().length() == 0) {
            return ClasspathDependencyUtil.getDefaultRuntimePath(isWebApp, isClassFolder);
        }
        return new Path(attrib.getValue());
    }

    public static boolean isClassFolderReference(IVirtualReference ref) {
        IVirtualComponent comp = ref.getReferencedComponent();
        if (comp instanceof ClasspathDependencyVirtualComponent) {
            ClasspathDependencyVirtualComponent cpComp = (ClasspathDependencyVirtualComponent)comp;
            return cpComp.isClassFolder();
        }
        return false;
    }

    public static IContainer getClassFolder(IVirtualComponent comp) {
        if (comp instanceof ClasspathDependencyVirtualComponent) {
            ClasspathDependencyVirtualComponent cpComp = (ClasspathDependencyVirtualComponent)comp;
            return cpComp.getClassFolder();
        }
        return null;
    }

    public static IPath getDefaultRuntimePath(boolean isWebApp) {
        return ClasspathDependencyUtil.getDefaultRuntimePath(isWebApp, false);
    }

    public static IPath getDefaultRuntimePath(boolean isWebApp, boolean isClassFolder) {
        if (isWebApp) {
            return isClassFolder ? WEB_INF_CLASSES_PATH : WEB_INF_LIB_PATH;
        }
        return isClassFolder ? RUNTIME_MAPPING_INTO_COMPONENT_PATH : RUNTIME_MAPPING_INTO_CONTAINER_PATH;
    }

    public static IPath getDefaultRuntimePath(IVirtualComponent virtualComponent, IClasspathEntry entry) {
        IVirtualComponent earComponent;
        boolean isClassFolderEntry = ClasspathDependencyUtil.isClassFolderEntry(entry);
        if (virtualComponent == null) {
            return ClasspathDependencyUtil.getDefaultRuntimePath(false, isClassFolderEntry);
        }
        boolean isWebApp = JavaEEProjectUtilities.isDynamicWebComponent(virtualComponent);
        if (isWebApp || isClassFolderEntry) {
            return ClasspathDependencyUtil.getDefaultRuntimePath(isWebApp, isClassFolderEntry);
        }
        IProject[] earProjects = EarUtilities.getReferencingEARProjects(virtualComponent.getProject());
        if (earProjects.length > 0 && (earComponent = ComponentCore.createComponent((IProject)earProjects[0])) != null) {
            return ClasspathDependencyUtil.calculateDefaultRuntimePath(earComponent, virtualComponent);
        }
        return ClasspathDependencyUtil.getDefaultRuntimePath(false, false);
    }

    public static IPath calculateDefaultRuntimePath(IVirtualComponent parentComponent, IVirtualComponent targetComponent) {
        IVirtualReference targetRef = parentComponent.getReference(targetComponent.getName());
        String libDir = EarUtilities.getEARLibDir(parentComponent);
        if (libDir != null && libDir.length() > 0) {
            Path libDirPath = new Path(libDir);
            if (targetRef == null || targetRef.getRuntimePath().equals((Object)"/")) {
                return new Path("../").append(libDirPath.makeAbsolute());
            }
            IPath childProjectRuntimePath = targetRef.getRuntimePath();
            String[] childProjectFolders = childProjectRuntimePath.segments();
            String[] libFolders = libDirPath.segments();
            int commonFolderCount = 0;
            int i = 0;
            while (i < childProjectFolders.length) {
                if (i >= libFolders.length || !childProjectFolders[i].equals(libFolders[i])) break;
                ++commonFolderCount;
                ++i;
            }
            String resultString = "../";
            int i2 = 0;
            while (i2 < childProjectFolders.length - commonFolderCount) {
                resultString = String.valueOf(resultString) + "../";
                ++i2;
            }
            return new Path(resultString).append(libDirPath.removeFirstSegments(commonFolderCount));
        }
        return ClasspathDependencyUtil.getDefaultRuntimePath(false, false);
    }

    public static String getArchiveName(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        boolean isClassFolder = ClasspathDependencyUtil.isClassFolderEntry(entry);
        if (isClassFolder) {
            IResource resource = ClasspathDependencyUtil.getEntryResource(entry);
            if (resource == null) {
                return ClasspathDependencyUtil.getEntryLocation(entry).lastSegment();
            }
            return resource.getFullPath().toString();
        }
        String customArchiveName = ClasspathDependencyUtil.getCustomArchiveName(entry);
        if (customArchiveName != null) {
            return customArchiveName;
        }
        IPath entryLocation = ClasspathDependencyUtil.getEntryLocation(entry);
        return entryLocation.lastSegment();
    }

    private static String getCustomArchiveName(IClasspathEntry entry) {
        IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
        if (extraAttributes != null) {
            IClasspathAttribute[] iClasspathAttributeArray = extraAttributes;
            int n = extraAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute cpa = iClasspathAttributeArray[n2];
                if (cpa != null && "org.eclipse.jst.component.archivename".equals(cpa.getName())) {
                    return cpa.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public static IClasspathAttribute checkForComponentDependencyAttribute(IClasspathEntry entry) {
        return ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry, IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY);
    }

    public static IClasspathAttribute checkForComponentDependencyAttribute(IClasspathEntry entry, IClasspathDependencyConstants.DependencyAttributeType attributeType) {
        return ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry, attributeType, false);
    }

    public static IClasspathAttribute checkForComponentDependencyAttribute(IClasspathEntry entry, IClasspathDependencyConstants.DependencyAttributeType attributeType, boolean isLegacyJ2EE) {
        if (entry == null) {
            return null;
        }
        IClasspathAttribute[] attributes = entry.getExtraAttributes();
        int i = 0;
        while (i < attributes.length) {
            IClasspathAttribute attribute = attributes[i];
            String name = attribute.getName();
            if (name.equals("org.eclipse.jst.component.dependency") ? attributeType == IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY || attributeType == IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY : name.equals("org.eclipse.jst.component.nondependency") && (attributeType == IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY || attributeType == IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_NONDEPENDENCY)) {
                return attribute;
            }
            ++i;
        }
        return null;
    }

    public static boolean isClasspathComponentDependency(IVirtualComponent component) {
        return component != null && component instanceof IClasspathDependencyComponent;
    }

    public static String getClasspathComponentDependencyDisplayString(IVirtualComponent component) {
        URI archiveURI = URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)component));
        return archiveURI.lastSegment();
    }

    public static boolean isMappedIntoContainer(String path) {
        return path.startsWith("../");
    }

    public static IClasspathEntry modifyDependencyPath(IClasspathEntry entry, IPath dependencyPath) {
        IClasspathEntry newEntry = null;
        IClasspathAttribute[] newAttributes = ClasspathDependencyUtil.modifyDependencyPath(entry.getExtraAttributes(), dependencyPath);
        switch (entry.getEntryKind()) {
            case 5: {
                newEntry = JavaCore.newContainerEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])newAttributes, (boolean)entry.isExported());
                break;
            }
            case 1: {
                newEntry = JavaCore.newLibraryEntry((IPath)entry.getPath(), (IPath)entry.getSourceAttachmentPath(), (IPath)entry.getSourceAttachmentRootPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])newAttributes, (boolean)entry.isExported());
                break;
            }
            case 4: {
                newEntry = JavaCore.newVariableEntry((IPath)entry.getPath(), (IPath)entry.getSourceAttachmentPath(), (IPath)entry.getSourceAttachmentRootPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])newAttributes, (boolean)entry.isExported());
                break;
            }
            case 2: {
                newEntry = JavaCore.newProjectEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (boolean)entry.combineAccessRules(), (IClasspathAttribute[])newAttributes, (boolean)entry.isExported());
                break;
            }
            case 3: {
                newEntry = JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])entry.getInclusionPatterns(), (IPath[])entry.getExclusionPatterns(), (IPath)entry.getOutputLocation(), (IClasspathAttribute[])newAttributes);
            }
        }
        return newEntry;
    }

    public static IPath getRuntimePath(IClasspathEntry entry) {
        IClasspathAttribute[] attributes;
        IClasspathAttribute[] iClasspathAttributeArray = attributes = entry.getExtraAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if (attribute.getName().equals("org.eclipse.jst.component.dependency")) {
                return new Path(attribute.getValue());
            }
            ++n2;
        }
        return null;
    }

    private static IClasspathAttribute[] modifyDependencyPath(IClasspathAttribute[] currentAttributes, IPath runtimePath) {
        ArrayList<IClasspathAttribute> updatedAttributes = new ArrayList<IClasspathAttribute>();
        boolean modified = false;
        IClasspathAttribute[] iClasspathAttributeArray = currentAttributes;
        int n = currentAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute currentAttribute = iClasspathAttributeArray[n2];
            if (currentAttribute.getName().equals("org.eclipse.jst.component.dependency")) {
                modified = true;
                if (runtimePath != null) {
                    try {
                        IClasspathAttribute newAttribute = UpdateClasspathAttributeUtil.createDependencyAttribute(runtimePath);
                        updatedAttributes.add(newAttribute);
                    }
                    catch (CoreException e) {
                        J2EEPlugin.logError(e);
                    }
                }
            } else {
                updatedAttributes.add(currentAttribute);
            }
            ++n2;
        }
        if (!modified) {
            try {
                IClasspathAttribute newAttribute = UpdateClasspathAttributeUtil.createDependencyAttribute(runtimePath);
                updatedAttributes.add(newAttribute);
            }
            catch (CoreException e) {
                J2EEPlugin.logError(e);
            }
        }
        return updatedAttributes.toArray(new IClasspathAttribute[updatedAttributes.size()]);
    }
}

