/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.SharedImages;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardSelectionPage;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizardCategoryFilter;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewCPWizard
extends BaseWizard
implements INewWizard,
IContextProvider {
    private CPWizardSelectionPage mProfilePage;
    private ViewerFilter[] mViewerFilters;
    private IConnectionProfile mParentProfile;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());

    public NewCPWizard() {
        this.setDefaultPageImageDescriptor(SharedImages.DESC_WIZBAN);
        this.setWindowTitle(ConnectivityUIPlugin.getDefault().getResourceString("NewCPWizard.title"));
    }

    public NewCPWizard(ViewerFilter filter, IConnectionProfile parentProfile) {
        this(parentProfile);
        if (filter != null) {
            this.mViewerFilters = new ViewerFilter[]{filter};
        }
    }

    public NewCPWizard(ViewerFilter[] filters, IConnectionProfile parentProfile) {
        this(parentProfile);
        this.mViewerFilters = filters;
    }

    private NewCPWizard(IConnectionProfile parentProfile) {
        this();
        this.mParentProfile = parentProfile;
    }

    public boolean performFinish() {
        if (this.mProfilePage != null && !this.mProfilePage.getControl().isDisposed()) {
            IWizardNode selectedNode = this.mProfilePage.getSelectedNode();
            if (selectedNode == null) {
                return false;
            }
            IWizard wizard = selectedNode.getWizard();
            if (wizard == null) {
                return false;
            }
            if (wizard.canFinish()) {
                return wizard.performFinish();
            }
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.mProfilePage = new CPWizardSelectionPage(CPWizardSelectionPage.class.getName(), this.mViewerFilters);
        this.addPage((IWizardPage)this.mProfilePage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (this.mViewerFilters == null || this.mViewerFilters.length == 0) {
            this.mViewerFilters = new ViewerFilter[]{new NewCPWizardCategoryFilter(null)};
        }
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    public IConnectionProfile getParentProfile() {
        return this.mParentProfile;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getShell(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_NEW_CP_WIZARD", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    public boolean canFinish() {
        return super.canFinish();
    }
}

