/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.structure;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jpt.common.ui.JptCommonUiImages;
import org.eclipse.jpt.common.ui.internal.jface.ModelItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.internal.jface.NullItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;
import org.eclipse.jpt.jpa.ui.internal.structure.PersistenceStructureItemLabelProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappingStructureItemLabelProviderFactory
implements ItemExtendedLabelProvider.Factory {
    protected static final Transformer<TypeMapping, ImageDescriptor> TYPE_MAPPING_IMAGE_DESCRIPTOR_TRANSFORMER = new TypeMappingImageDescriptorTransformer();
    protected static final Transformer<AttributeMapping, ImageDescriptor> ATTRIBUTE_MAPPING_IMAGE_DESCRIPTOR_TRANSFORMER = new AttributeMappingImageDescriptorTransformer();

    protected MappingStructureItemLabelProviderFactory() {
    }

    public ItemExtendedLabelProvider buildProvider(Object item, ItemExtendedLabelProvider.Manager manager) {
        if (item instanceof PersistentType) {
            return MappingStructureItemLabelProviderFactory.buildPersistentTypeProvider((PersistentType)item, manager);
        }
        if (item instanceof PersistentAttribute) {
            return MappingStructureItemLabelProviderFactory.buildPersistentAttributeProvider((PersistentAttribute)item, manager);
        }
        return NullItemExtendedLabelProvider.instance();
    }

    public static ItemExtendedLabelProvider buildPersistentTypeProvider(PersistentType persistentType, ItemExtendedLabelProvider.Manager manager) {
        return new ModelItemExtendedLabelProvider((Object)persistentType, manager, MappingStructureItemLabelProviderFactory.buildPersistentTypeImageDescriptorModel(persistentType), MappingStructureItemLabelProviderFactory.buildPersistentTypeTextModel(persistentType), MappingStructureItemLabelProviderFactory.buildPersistentTypeDescriptionModel(persistentType));
    }

    protected static PropertyValueModel<ImageDescriptor> buildPersistentTypeImageDescriptorModel(PersistentType persistentType) {
        return new TransformationPropertyValueModel(MappingStructureItemLabelProviderFactory.buildPersistentTypeMappingModel(persistentType), TYPE_MAPPING_IMAGE_DESCRIPTOR_TRANSFORMER);
    }

    protected static PropertyValueModel<TypeMapping> buildPersistentTypeMappingModel(PersistentType persistentType) {
        return new PersistentTypeMappingModel(persistentType);
    }

    protected static PropertyValueModel<String> buildPersistentTypeTextModel(PersistentType persistentType) {
        return new PersistentTypeTextModel(persistentType);
    }

    protected static PropertyValueModel<String> buildPersistentTypeDescriptionModel(PersistentType persistentType) {
        return PersistenceStructureItemLabelProviderFactory.buildNonQuotedComponentDescriptionModel((JpaContextModel)persistentType, MappingStructureItemLabelProviderFactory.buildPersistentTypeTextModel(persistentType));
    }

    public static ItemExtendedLabelProvider buildPersistentAttributeProvider(PersistentAttribute persistentAttribute, ItemExtendedLabelProvider.Manager manager) {
        return new ModelItemExtendedLabelProvider((Object)persistentAttribute, manager, MappingStructureItemLabelProviderFactory.buildPersistentAttributeImageDescriptorModel(persistentAttribute), MappingStructureItemLabelProviderFactory.buildPersistentAttributeTextModel(persistentAttribute), MappingStructureItemLabelProviderFactory.buildPersistentAttributeDescriptionModel(persistentAttribute));
    }

    protected static PropertyValueModel<ImageDescriptor> buildPersistentAttributeImageDescriptorModel(PersistentAttribute persistentAttribute) {
        return new TransformationPropertyValueModel(MappingStructureItemLabelProviderFactory.buildPersistentAttributeMappingModel(persistentAttribute), ATTRIBUTE_MAPPING_IMAGE_DESCRIPTOR_TRANSFORMER);
    }

    protected static PropertyValueModel<AttributeMapping> buildPersistentAttributeMappingModel(PersistentAttribute persistentAttribute) {
        return new PersistentAttributeMappingModel(persistentAttribute);
    }

    protected static PropertyValueModel<String> buildPersistentAttributeTextModel(PersistentAttribute persistentAttribute) {
        return new PersistentAttributeTextModel(persistentAttribute);
    }

    protected static PropertyValueModel<String> buildPersistentAttributeDescriptionModel(PersistentAttribute persistentAttribute) {
        return PersistenceStructureItemLabelProviderFactory.buildNonQuotedComponentDescriptionModel((JpaContextModel)persistentAttribute, MappingStructureItemLabelProviderFactory.buildTypeTextModel(persistentAttribute), MappingStructureItemLabelProviderFactory.buildPersistentAttributeTextModel(persistentAttribute));
    }

    protected static PropertyValueModel<String> buildTypeTextModel(PersistentAttribute persistentAttribute) {
        return new PersistentTypeTextModel(persistentAttribute.getDeclaringPersistentType());
    }

    public String toString() {
        return ObjectTools.singletonToString((Object)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeMappingImageDescriptorTransformer
    extends TransformerAdapter<AttributeMapping, ImageDescriptor> {
        public ImageDescriptor transform(AttributeMapping attributeMapping) {
            MappingUiDefinition definition = this.getAttributeMappingUiDefinition(attributeMapping);
            return definition == null ? null : JptCommonUiImages.gray((ImageDescriptor)definition.getImageDescriptor(), (boolean)attributeMapping.getPersistentAttribute().isVirtual());
        }

        private MappingUiDefinition getAttributeMappingUiDefinition(AttributeMapping attributeMapping) {
            JpaPlatformUi ui = this.getJpaPlatformUi(attributeMapping);
            return ui == null ? null : ui.getAttributeMappingUiDefinition(attributeMapping.getResourceType(), attributeMapping.getKey());
        }

        private JpaPlatformUi getJpaPlatformUi(AttributeMapping attributeMapping) {
            return (JpaPlatformUi)attributeMapping.getJpaProject().getJpaPlatform().getAdapter(JpaPlatformUi.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistentAttributeMappingModel
    extends PropertyAspectAdapter<PersistentAttribute, AttributeMapping> {
        public PersistentAttributeMappingModel(PersistentAttribute subject) {
            super("mapping", (Model)subject);
        }

        protected AttributeMapping buildValue_() {
            return ((PersistentAttribute)this.subject).getMapping();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistentAttributeTextModel
    extends PropertyAspectAdapter<PersistentAttribute, String> {
        public PersistentAttributeTextModel(PersistentAttribute subject) {
            super("name", (Model)subject);
        }

        protected String buildValue_() {
            return ((PersistentAttribute)this.subject).getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistentTypeMappingModel
    extends PropertyAspectAdapter<PersistentType, TypeMapping> {
        public PersistentTypeMappingModel(PersistentType subject) {
            super("mapping", (Model)subject);
        }

        protected TypeMapping buildValue_() {
            return ((PersistentType)this.subject).getMapping();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistentTypeTextModel
    extends PropertyAspectAdapter<PersistentType, String> {
        public PersistentTypeTextModel(PersistentType subject) {
            super("name", (Model)subject);
        }

        protected String buildValue_() {
            return ((PersistentType)this.subject).getTypeQualifiedName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeMappingImageDescriptorTransformer
    extends TransformerAdapter<TypeMapping, ImageDescriptor> {
        public ImageDescriptor transform(TypeMapping typeMapping) {
            MappingUiDefinition definition = this.getTypeMappingUiDefinition(typeMapping);
            return definition == null ? null : definition.getImageDescriptor();
        }

        private MappingUiDefinition getTypeMappingUiDefinition(TypeMapping typeMapping) {
            JpaPlatformUi ui = this.getJpaPlatformUi(typeMapping);
            return ui == null ? null : ui.getTypeMappingUiDefinition(typeMapping.getResourceType(), typeMapping.getKey());
        }

        private JpaPlatformUi getJpaPlatformUi(TypeMapping typeMapping) {
            return (JpaPlatformUi)typeMapping.getJpaProject().getJpaPlatform().getAdapter(JpaPlatformUi.class);
        }
    }
}

