/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.jface.ResourceManagerLabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.details.DefaultMappingUiDefinition;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapAsComposite<T extends JpaStructureNode>
extends Pane<T> {
    protected boolean dragEvent;
    protected MappingChangeHandler mappingChangeHandler;
    protected int mappingTypeLength;
    protected int mappingTypeStart;
    protected boolean mouseDown;
    protected int nameLength;
    protected int nameStart;
    protected StyledText styledText;
    private static final String DIALOG_SETTINGS = "org.eclipse.jpt.jpa.ui.dialogs.MapAsDialog";

    protected MapAsComposite(Pane<? extends T> parentPane, Composite parentComposite) {
        super(parentPane, parentComposite);
    }

    protected MapAsComposite(Pane<? extends T> parentPane, Composite parent, PropertyValueModel<Boolean> enabledModel) {
        super(parentPane, parent, enabledModel);
    }

    protected JpaPlatformUi getJpaPlatformUi() {
        return (JpaPlatformUi)((JpaStructureNode)this.getSubject()).getJpaProject().getJpaPlatform().getAdapter(JpaPlatformUi.class);
    }

    protected abstract DefaultMappingUiDefinition getDefaultDefinition();

    protected abstract DefaultMappingUiDefinition getDefaultDefinition(String var1);

    protected MappingUiDefinition getMappingUiDefinition() {
        return this.mappingChangeHandler.getMappingUiDefinition();
    }

    protected abstract MappingChangeHandler buildMappingChangeHandler();

    private MouseListener buildMouseListener() {
        return new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    MapAsComposite.this.mouseDown = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                MapAsComposite.this.mouseDown = false;
                StyledText text = (StyledText)e.widget;
                int offset = text.getCaretOffset();
                if (MapAsComposite.this.dragEvent) {
                    MapAsComposite.this.dragEvent = false;
                    if (MapAsComposite.this.isOverLink(offset)) {
                        text.setCursor(MapAsComposite.this.getHandCursor());
                    }
                } else if (MapAsComposite.this.isOverLink(offset)) {
                    text.setCursor(MapAsComposite.this.getHandCursor());
                    MapAsComposite.this.openMappingSelectionDialog();
                    text.setCursor(null);
                }
            }
        };
    }

    private MouseMoveListener buildMouseMoveListener() {
        return new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                StyledText text = (StyledText)e.widget;
                if (MapAsComposite.this.mouseDown) {
                    if (!MapAsComposite.this.dragEvent) {
                        text.setCursor(null);
                    }
                    MapAsComposite.this.dragEvent = true;
                    return;
                }
                int offset = -1;
                try {
                    offset = text.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (MapAsComposite.this.isOverLink(offset)) {
                    text.setCursor(MapAsComposite.this.getHandCursor());
                } else {
                    text.setCursor(null);
                }
            }
        };
    }

    private Cursor getHandCursor() {
        return this.getShell().getDisplay().getSystemCursor(21);
    }

    protected String buildText(String name, String mappingType) {
        return NLS.bind((String)this.mappingChangeHandler.getLabelText(), (Object)name, (Object)mappingType);
    }

    protected void clearStyleRange() {
        this.styledText.setStyleRange(null);
    }

    protected void doPopulate() {
        super.doPopulate();
        this.updateDescription();
    }

    protected void initialize() {
        super.initialize();
        this.mappingChangeHandler = this.buildMappingChangeHandler();
    }

    protected void enabledModelChanged(boolean oldEnabled, boolean newEnabled) {
        if (!this.styledText.isDisposed()) {
            if (newEnabled) {
                this.updateLinkRange();
            } else {
                this.clearStyleRange();
            }
        }
    }

    protected Composite addComposite(Composite parent) {
        this.styledText = new StyledText(parent, 72);
        this.bindEnabledState(new Control[]{this.styledText});
        this.styledText.addMouseListener(this.buildMouseListener());
        this.styledText.addMouseMoveListener(this.buildMouseMoveListener());
        this.styledText.setLayoutData((Object)new GridData(768));
        return this.styledText;
    }

    public Composite getControl() {
        return (Composite)super.getControl();
    }

    protected void initializeLayout(Composite container) {
    }

    protected MappingUiDefinition initialSelection() {
        return this.mappingChangeHandler.getMappingUiDefinition();
    }

    protected boolean isOverLink(int location) {
        return location >= this.mappingTypeStart && location <= this.mappingTypeStart + this.mappingTypeLength;
    }

    protected void morphMapping(MappingUiDefinition definition) {
        this.mappingChangeHandler.morphMapping(definition);
    }

    protected void openMappingSelectionDialog() {
        MappingSelectionDialog dialog = new MappingSelectionDialog(this.getShell(), this.getResourceManager());
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            MappingUiDefinition definition = (MappingUiDefinition)dialog.getFirstResult();
            this.morphMapping(definition);
        }
    }

    protected void updateDescription() {
        if (this.getSubject() == null) {
            return;
        }
        this.clearStyleRange();
        this.updateText();
        if (this.isEnabled()) {
            this.updateLinkRange();
        }
    }

    protected void updateLinkRange() {
        Color linkColor = JFaceColors.getHyperlinkText((Display)this.getShell().getDisplay());
        StyleRange styleRange = new StyleRange(this.nameStart, this.nameLength, null, null, 1);
        this.styledText.setStyleRange(styleRange);
        if (this.mappingTypeStart > -1) {
            styleRange = new StyleRange(this.mappingTypeStart, this.mappingTypeLength, linkColor, null);
            styleRange.underline = true;
            styleRange.underlineColor = linkColor;
            styleRange.underlineStyle = 0;
            this.styledText.setStyleRange(styleRange);
        }
    }

    protected void updateText() {
        String name = this.mappingChangeHandler.getName();
        if (name == null) {
            name = JptJpaUiDetailsMessages.NO_NAME_SET;
        }
        String mappingType = this.mappingChangeHandler.getMappingText();
        String text = this.buildText(name, mappingType);
        this.mappingTypeStart = text.lastIndexOf(mappingType);
        this.mappingTypeLength = mappingType.length();
        this.nameStart = text.indexOf(name);
        this.nameLength = name.length();
        this.styledText.setText(text);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractMappingChangeHandler
    implements MappingChangeHandler {
        @Override
        public final void morphMapping(MappingUiDefinition definition) {
            IProject project = ((JpaStructureNode)MapAsComposite.this.getSubject()).getJpaProject().getProject();
            try {
                Job.getJobManager().beginRule((ISchedulingRule)project, null);
                this.morphMapping_(definition);
                this.setJpaSelection((JpaStructureNode)MapAsComposite.this.getSubject());
            }
            finally {
                Job.getJobManager().endRule((ISchedulingRule)project);
            }
        }

        protected abstract void morphMapping_(MappingUiDefinition var1);

        private void setJpaSelection(JpaStructureNode jpaSelection) {
            JpaSelectionManager mgr = this.getJpaSelectionManager();
            mgr.setSelection(null);
            mgr.setSelection(jpaSelection);
        }

        private JpaSelectionManager getJpaSelectionManager() {
            return (JpaSelectionManager)WorkbenchTools.getAdapter(JpaSelectionManager.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface MappingChangeHandler {
        public String getLabelText();

        public String getMappingText();

        public void morphMapping(MappingUiDefinition var1);

        public String getName();

        public Iterable<MappingUiDefinition> getMappingUiDefinitions();

        public MappingUiDefinition getMappingUiDefinition();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MappingSelectionDialog
    extends FilteredItemsSelectionDialog {
        private MappingUiDefinition defaultDefinition;

        protected MappingSelectionDialog(Shell shell, ResourceManager resourceManager) {
            super(shell, false);
            this.setMessage(JptJpaUiDetailsMessages.MAP_AS_COMPOSITE_LABEL_TEXT);
            this.setTitle(JptJpaUiDetailsMessages.MAP_AS_COMPOSITE_DIALOG_TITLE);
            ILabelProvider labelProvider = this.buildLabelProvider(resourceManager);
            this.setListLabelProvider(labelProvider);
            this.setDetailsLabelProvider(labelProvider);
        }

        private ILabelProvider buildLabelProvider(ResourceManager resourceManager) {
            return new ResourceManagerLabelProvider(MappingUiDefinition.IMAGE_DESCRIPTOR_TRANSFORMER, MappingUiDefinition.LABEL_TRANSFORMER, resourceManager);
        }

        protected Control createExtendedContentArea(Composite parent) {
            return null;
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            return new MappingTypeItemsFilter();
        }

        protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
            monitor.beginTask(null, -1);
            try {
                this.defaultDefinition = MapAsComposite.this.getDefaultDefinition();
                if (this.defaultDefinition != null) {
                    provider.add((Object)this.defaultDefinition, itemsFilter);
                }
                for (MappingUiDefinition mappingDefinition : MapAsComposite.this.mappingChangeHandler.getMappingUiDefinitions()) {
                    provider.add((Object)mappingDefinition, itemsFilter);
                }
            }
            finally {
                monitor.done();
            }
        }

        protected IDialogSettings getDialogSettings() {
            return JptJpaUiPlugin.instance().getDialogSettings(MapAsComposite.DIALOG_SETTINGS);
        }

        public String getElementName(Object object) {
            MappingUiDefinition definition = (MappingUiDefinition)object;
            return definition.getLabel();
        }

        protected Comparator<MappingUiDefinition> getItemsComparator() {
            return new Comparator<MappingUiDefinition>(){

                @Override
                public int compare(MappingUiDefinition item1, MappingUiDefinition item2) {
                    if (item1 == MappingSelectionDialog.this.defaultDefinition) {
                        return -1;
                    }
                    if (item2 == MappingSelectionDialog.this.defaultDefinition) {
                        return 1;
                    }
                    String displayString1 = item1.getLabel();
                    String displayString2 = item2.getLabel();
                    return Collator.getInstance().compare(displayString1, displayString2);
                }
            };
        }

        protected IStatus validateItem(Object item) {
            if (item == null) {
                return JptJpaUiPlugin.instance().buildErrorStatus();
            }
            return Status.OK_STATUS;
        }

        private class MappingTypeItemsFilter
        extends FilteredItemsSelectionDialog.ItemsFilter {
            MappingTypeItemsFilter() {
                super((FilteredItemsSelectionDialog)MappingSelectionDialog.this);
                if (StringTools.isBlank((String)this.getPattern())) {
                    this.patternMatcher.setPattern("*");
                }
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                MappingUiDefinition definition = (MappingUiDefinition)item;
                return this.matches(definition.getLabel());
            }
        }
    }
}

