/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinColumnsComposite<T extends JpaModel>
extends Pane<T> {
    JoinColumnsEditor<T> joinColumnsEditor;
    ModifiableCollectionValueModel<SpecifiedJoinColumn> selectedJoinColumnsModel;

    public JoinColumnsComposite(Pane<? extends T> parent, Composite parentComposite, JoinColumnsEditor<T> joinColumnsEditor, PropertyValueModel<Boolean> enabledModel) {
        super(parent, parentComposite, enabledModel);
        this.joinColumnsEditor = joinColumnsEditor;
        this.initializeLayout2();
    }

    public Composite getControl() {
        return (Composite)super.getControl();
    }

    protected void initialize() {
        super.initialize();
        this.selectedJoinColumnsModel = this.buildSelectedJoinColumnsModel();
    }

    protected void initializeLayout(Composite container) {
    }

    private void initializeLayout2() {
        new AddRemoveListPane((Pane)this, this.getControl(), this.buildJoinColumnsAdapter(), this.buildJoinColumnsListModel(), this.selectedJoinColumnsModel, this.buildJoinColumnsListLabelProvider(), JpaHelpContextIds.MAPPING_JOIN_TABLE_COLUMNS);
    }

    private ModifiableCollectionValueModel<SpecifiedJoinColumn> buildSelectedJoinColumnsModel() {
        return new SimpleCollectionValueModel();
    }

    String buildJoinColumnLabel(JoinColumn joinColumn) {
        if (joinColumn.isVirtual()) {
            return NLS.bind((String)JptJpaUiDetailsMessages.JOIN_COLUMNS_COMPOSITE_MAPPING_BETWEEN_TWO_PARAMS_DEFAULT, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptJpaUiDetailsMessages.JOIN_COLUMNS_COMPOSITE_MAPPING_BETWEEN_TWO_PARAMS_BOTH_DEFAULT, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptJpaUiDetailsMessages.JOIN_COLUMNS_COMPOSITE_MAPPING_BETWEEN_TWO_PARAMS_FIRST_DEFAULT, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)JptJpaUiDetailsMessages.JOIN_COLUMNS_COMPOSITE_MAPPING_BETWEEN_TWO_PARAMS_SECOND_DEFAULT, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)JptJpaUiDetailsMessages.JOIN_COLUMNS_COMPOSITE_MAPPING_BETWEEN_TWO_PARAMS, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private AddRemovePane.Adapter<SpecifiedJoinColumn> buildJoinColumnsAdapter() {
        return new AddRemovePane.AbstractAdapter<SpecifiedJoinColumn>(){

            public SpecifiedJoinColumn addNewItem() {
                return JoinColumnsComposite.this.joinColumnsEditor.addJoinColumn((JpaModel)JoinColumnsComposite.this.getSubject());
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<SpecifiedJoinColumn> selectedItemsModel) {
                return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
            }

            public void removeSelectedItems(CollectionValueModel<SpecifiedJoinColumn> selectedItemsModel) {
                SpecifiedJoinColumn joinColumn = (SpecifiedJoinColumn)selectedItemsModel.iterator().next();
                JoinColumnsComposite.this.joinColumnsEditor.removeJoinColumn((JpaModel)JoinColumnsComposite.this.getSubject(), joinColumn);
            }

            public boolean hasOptionalButton() {
                return true;
            }

            public String optionalButtonText() {
                return JptJpaUiDetailsMessages.JOIN_COLUMNS_COMPOSITE_EDIT;
            }

            public void optionOnSelection(CollectionValueModel<SpecifiedJoinColumn> selectedItemsModel) {
                SpecifiedJoinColumn joinColumn = (SpecifiedJoinColumn)selectedItemsModel.iterator().next();
                JoinColumnsComposite.this.joinColumnsEditor.editJoinColumn((JpaModel)JoinColumnsComposite.this.getSubject(), (JoinColumn)joinColumn);
            }
        };
    }

    private ListValueModel<JoinColumn> buildJoinColumnsListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildJoinColumnsListHolder(), new String[]{"specifiedName", "defaultName", "specifiedReferencedColumnName", "defaultReferencedColumnName"});
    }

    private ListValueModel<JoinColumn> buildJoinColumnsListHolder() {
        ArrayList<ListValueModel<JoinColumn>> list = new ArrayList<ListValueModel<JoinColumn>>();
        list.add(this.buildDefaultJoinColumnListHolder());
        list.add(this.buildSpecifiedJoinColumnsListHolder());
        return CompositeListValueModel.forModels(list);
    }

    private ListValueModel<JoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<T, JoinColumn>(this.getSubjectHolder(), new String[]{this.joinColumnsEditor.getSpecifiedJoinColumnsListPropertyName()}){

            protected ListIterable<JoinColumn> getListIterable() {
                return JoinColumnsComposite.this.joinColumnsEditor.getSpecifiedJoinColumns((JpaModel)this.subject);
            }

            protected int size_() {
                return JoinColumnsComposite.this.joinColumnsEditor.getSpecifiedJoinColumnsSize((JpaModel)this.subject);
            }
        };
    }

    private ListValueModel<JoinColumn> buildDefaultJoinColumnListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultJoinColumnHolder());
    }

    private PropertyValueModel<JoinColumn> buildDefaultJoinColumnHolder() {
        return new PropertyAspectAdapter<T, JoinColumn>(this.getSubjectHolder(), new String[]{this.joinColumnsEditor.getDefaultPropertyName()}){

            protected JoinColumn buildValue_() {
                return JoinColumnsComposite.this.joinColumnsEditor.getDefaultJoinColumn((JpaModel)this.subject);
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                JoinColumn joinColumn = (JoinColumn)element;
                return JoinColumnsComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    public void setSelectedJoinColumn(SpecifiedJoinColumn joinColumn) {
        this.selectedJoinColumnsModel.setValues((Iterable)new SingleElementIterable((Object)joinColumn));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JoinColumnsEditor<T> {
        public SpecifiedJoinColumn addJoinColumn(T var1);

        public void editJoinColumn(T var1, JoinColumn var2);

        public boolean hasSpecifiedJoinColumns(T var1);

        public ListIterable<JoinColumn> getSpecifiedJoinColumns(T var1);

        public int getSpecifiedJoinColumnsSize(T var1);

        public JoinColumn getDefaultJoinColumn(T var1);

        public String getSpecifiedJoinColumnsListPropertyName();

        public String getDefaultPropertyName();

        public void removeJoinColumn(T var1, SpecifiedJoinColumn var2);
    }
}

