/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.BaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.LobConverter;
import org.eclipse.jpt.jpa.core.context.SpecifiedAccessReference;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.ui.details.JpaComposite;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.ColumnComposite;
import org.eclipse.jpt.jpa.ui.internal.details.EnumTypeComboViewer;
import org.eclipse.jpt.jpa.ui.internal.details.FetchTypeComboViewer;
import org.eclipse.jpt.jpa.ui.internal.details.OptionalTriStateCheckBox;
import org.eclipse.jpt.jpa.ui.internal.details.TemporalTypeCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicMappingComposite<T extends BasicMapping>
extends Pane<T>
implements JpaComposite {
    protected AbstractBasicMappingComposite(PropertyValueModel<? extends T> mappingModel, PropertyValueModel<Boolean> enabledModel, Composite parentComposite, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        super(mappingModel, enabledModel, parentComposite, widgetFactory, resourceManager);
    }

    protected void initializeLayout(Composite container) {
        this.initializeBasicCollapsibleSection(container);
        this.initializeTypeCollapsibleSection(container);
    }

    protected void initializeBasicCollapsibleSection(Composite container) {
        Section section = this.getWidgetFactory().createSection(container, 322);
        section.setLayoutData((Object)new GridData(768));
        section.setText(JptJpaUiDetailsMessages.BASIC_SECTION_TITLE);
        section.setClient(this.initializeBasicSection((Composite)section));
    }

    protected Control initializeBasicSection(Composite container) {
        container = this.addSubPane(container, 2, 0, 0, 0, 0);
        ColumnComposite columnComposite = new ColumnComposite(this, this.buildColumnModel(), container);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        columnComposite.getControl().setLayoutData((Object)gridData);
        this.addLabel(container, JptJpaUiDetailsMessages.BASIC_GENERAL_SECTION_FETCH_LABEL);
        new FetchTypeComboViewer(this, container);
        OptionalTriStateCheckBox optionalCheckBox = new OptionalTriStateCheckBox(this, container);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        optionalCheckBox.getControl().setLayoutData((Object)gridData);
        return container;
    }

    protected void initializeTypeCollapsibleSection(Composite container) {
        final Section section = this.getWidgetFactory().createSection(container, 258);
        section.setLayoutData((Object)new GridData(768));
        section.setText(JptJpaUiDetailsMessages.TYPE_SECTION_TYPE);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState() && section.getClient() == null) {
                    section.setClient(AbstractBasicMappingComposite.this.initializeTypeSection((Composite)section));
                }
            }
        });
    }

    protected Control initializeTypeSection(Composite container) {
        container = this.addSubPane(container, 2, 0, 0, 0, 0);
        Button noConverterButton = this.addRadioButton(container, JptJpaUiDetailsMessages.TYPE_SECTION_DEFAULT, this.buildConverterBooleanHolder(null), null);
        ((GridData)noConverterButton.getLayoutData()).horizontalSpan = 2;
        Button lobButton = this.addRadioButton(container, JptJpaUiDetailsMessages.TYPE_SECTION_LOB, this.buildConverterBooleanHolder(LobConverter.class), null);
        ((GridData)lobButton.getLayoutData()).horizontalSpan = 2;
        PropertyValueModel<Converter> converterHolder = this.buildConverterHolder();
        this.addRadioButton(container, JptJpaUiDetailsMessages.TYPE_SECTION_TEMPORAL, this.buildConverterBooleanHolder(BaseTemporalConverter.class), null);
        new TemporalTypeCombo(this, this.buildTemporalConverterHolder(converterHolder), container);
        this.addRadioButton(container, JptJpaUiDetailsMessages.TYPE_SECTION_ENUMERATED, this.buildConverterBooleanHolder(BaseEnumeratedConverter.class), null);
        new EnumTypeComboViewer(this, this.buildEnumeratedConverterHolder(converterHolder), container);
        return container;
    }

    protected PropertyValueModel<SpecifiedColumn> buildColumnModel() {
        return new TransformationPropertyValueModel<T, SpecifiedColumn>(this.getSubjectHolder()){

            protected SpecifiedColumn transform_(T mapping) {
                return mapping.getColumn();
            }
        };
    }

    protected PropertyValueModel<Converter> buildConverterHolder() {
        return new PropertyAspectAdapter<T, Converter>(this.getSubjectHolder(), new String[]{"converter"}){

            protected Converter buildValue_() {
                return ((BasicMapping)this.subject).getConverter();
            }
        };
    }

    protected PropertyValueModel<BaseTemporalConverter> buildTemporalConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, BaseTemporalConverter>(converterHolder){

            protected BaseTemporalConverter transform_(Converter converter) {
                return converter.getConverterType() == BaseTemporalConverter.class ? (BaseTemporalConverter)converter : null;
            }
        };
    }

    protected PropertyValueModel<BaseEnumeratedConverter> buildEnumeratedConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, BaseEnumeratedConverter>(converterHolder){

            protected BaseEnumeratedConverter transform_(Converter converter) {
                return converter.getConverterType() == BaseEnumeratedConverter.class ? (BaseEnumeratedConverter)converter : null;
            }
        };
    }

    protected ModifiablePropertyValueModel<Boolean> buildConverterBooleanHolder(final Class<? extends Converter> converterType) {
        return new PropertyAspectAdapter<T, Boolean>(this.getSubjectHolder(), new String[]{"converter"}){

            protected Boolean buildValue_() {
                Converter converter = ((BasicMapping)this.subject).getConverter();
                return converter.getConverterType() == converterType;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((BasicMapping)this.subject).setConverter(converterType);
                }
            }
        };
    }

    protected PropertyValueModel<SpecifiedAccessReference> buildAccessReferenceModel() {
        return new PropertyAspectAdapter<T, SpecifiedAccessReference>(this.getSubjectHolder()){

            protected SpecifiedAccessReference buildValue_() {
                return ((BasicMapping)this.subject).getPersistentAttribute();
            }
        };
    }
}

