/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.css.core.internal.document.CSSAttrImpl;
import org.eclipse.wst.css.core.internal.document.CSSModelUpdateContext;
import org.eclipse.wst.css.core.internal.document.CSSPrimitiveValueImpl;
import org.eclipse.wst.css.core.internal.document.CSSStyleDeclItemImpl;
import org.eclipse.wst.css.core.internal.document.CounterImpl;
import org.eclipse.wst.css.core.internal.document.RGBColorImpl;
import org.eclipse.wst.css.core.internal.document.RectImpl;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.TextRegionListImpl;

class CSSDeclarationItemParser {
    static final int S_NORMAL = 0;
    static final int S_FUNCTION = 1;
    static final int S_FONT_SLASH = 2;
    static final int S_COMMA_SEPARATION = 3;
    private ICSSDocument fDocument = null;
    private IStructuredDocumentRegion fParentRegion = null;
    private boolean fTempStructuredDocument = false;
    private CSSModelUpdateContext fUpdateContext = null;
    private Map regionValues = new HashMap(0);

    CSSDeclarationItemParser(ICSSDocument doc) {
        this.fDocument = doc;
    }

    private CSSPrimitiveValueImpl createAttrValue(ITextRegionList regions) {
        String funcName = this.getFunctionName(regions);
        if (funcName == null || !funcName.toLowerCase().equals("attr")) {
            return null;
        }
        String[] accepts = new String[]{"DECLARATION_VALUE_IDENT"};
        ITextRegionList valueRegions = this.getFunctionParameters(regions, accepts);
        if (valueRegions.size() != 1) {
            return null;
        }
        CSSPrimitiveValueImpl value = this.getCSSPrimitiveValue((short)22);
        if (value == null) {
            return null;
        }
        ITextRegion region = valueRegions.get(0);
        value.setValue(this.getText(region));
        return value;
    }

    private CSSPrimitiveValueImpl createCountersValue(ITextRegionList regions) {
        String funcName = this.getFunctionName(regions);
        if (funcName == null || !funcName.toLowerCase().equals("counters")) {
            return null;
        }
        String[] accepts = new String[]{"DECLARATION_VALUE_IDENT", "DECLARATION_VALUE_STRING"};
        ITextRegionList valueRegions = this.getFunctionParameters(regions, accepts);
        int size = valueRegions.size();
        if (size != 2 && size != 3) {
            return null;
        }
        CounterImpl value = this.getCounter();
        if (value == null) {
            return null;
        }
        int i = 0;
        while (i < size) {
            ITextRegion region = valueRegions.get(i);
            String text = this.getText(region);
            CSSAttrImpl attr = null;
            switch (i) {
                case 0: {
                    value.setIdentifier(text);
                    attr = value.getAttributeNode("identifier");
                    break;
                }
                case 1: {
                    value.setSeparator(text);
                    attr = value.getAttributeNode("separator");
                    break;
                }
                case 2: {
                    value.setListStyle(text);
                    attr = value.getAttributeNode("liststyle");
                    break;
                }
            }
            if (attr != null) {
                attr.setRangeRegion(this.fParentRegion, region, region);
            }
            ++i;
        }
        return value;
    }

    private CSSPrimitiveValueImpl createCounterValue(ITextRegionList regions) {
        String funcName = this.getFunctionName(regions);
        if (funcName == null || !funcName.toLowerCase().equals("counter")) {
            return null;
        }
        String[] accepts = new String[]{"DECLARATION_VALUE_IDENT"};
        ITextRegionList valueRegions = this.getFunctionParameters(regions, accepts);
        int size = valueRegions.size();
        if (size != 1 && size != 2) {
            return null;
        }
        CounterImpl value = this.getCounter();
        if (value == null) {
            return null;
        }
        int i = 0;
        while (i < size) {
            ITextRegion region = valueRegions.get(i);
            String text = this.getText(region);
            CSSAttrImpl attr = null;
            switch (i) {
                case 0: {
                    value.setIdentifier(text);
                    attr = value.getAttributeNode("identifier");
                    break;
                }
                case 1: {
                    value.setListStyle(text);
                    attr = value.getAttributeNode("liststyle");
                    break;
                }
            }
            if (attr != null) {
                attr.setRangeRegion(this.fParentRegion, region, region);
            }
            ++i;
        }
        return value;
    }

    private CSSStyleDeclItemImpl createDeclarationItem(ITextRegionList nodeRegions) {
        CSSStyleDeclItemImpl item = null;
        String name = this.getPropertyName(nodeRegions);
        if (name != null) {
            item = this.getCSSStyleDeclItem(name);
        }
        return item;
    }

    private CSSPrimitiveValueImpl createFloatValue(String text, String type) {
        FloatInfo info = new FloatInfo(text);
        CSSPrimitiveValueImpl value = this.getCSSPrimitiveValue(info.getValueType());
        if (value != null) {
            value.setValue(info.getValue());
        }
        return value;
    }

    private CSSPrimitiveValueImpl createFormatValue(ITextRegionList regions) {
        String funcName = this.getFunctionName(regions);
        if (funcName == null || !funcName.toLowerCase().equals("format")) {
            return null;
        }
        String[] accepts = new String[]{"DECLARATION_VALUE_STRING"};
        ITextRegionList valueRegions = this.getFunctionParameters(regions, accepts);
        if (valueRegions.size() == 0) {
            return null;
        }
        CSSPrimitiveValueImpl value = this.getCSSPrimitiveValue((short)29);
        if (value == null) {
            return null;
        }
        ITextRegion region = valueRegions.get(0);
        value.setValue(CSSUtil.extractStringContents(this.getText(region)));
        return value;
    }

    private CSSPrimitiveValueImpl createLocalValue(ITextRegionList regions) {
        String funcName = this.getFunctionName(regions);
        if (funcName == null || !funcName.toLowerCase().equals("local")) {
            return null;
        }
        String[] accepts = new String[]{"DECLARATION_VALUE_STRING"};
        ITextRegionList valueRegions = this.getFunctionParameters(regions, accepts);
        if (valueRegions.size() != 1) {
            return null;
        }
        CSSPrimitiveValueImpl value = this.getCSSPrimitiveValue((short)30);
        if (value == null) {
            return null;
        }
        ITextRegion region = valueRegions.get(0);
        value.setValue(CSSUtil.extractStringContents(this.getText(region)));
        return value;
    }

    private CSSPrimitiveValueImpl createPrimitiveValue(ITextRegion region, String propertyValue) {
        String text;
        if (region == null) {
            return null;
        }
        CSSPrimitiveValueImpl value = null;
        String type = region.getType();
        String string = text = propertyValue != null ? propertyValue : this.getText(region);
        if (CSSDeclarationItemParser.isBlank(type)) {
            value = null;
        } else if (type == "DECLARATION_VALUE_NUMBER" || type == "DECLARATION_VALUE_DIMENSION" || type == "DECLARATION_VALUE_PERCENTAGE") {
            value = this.createFloatValue(text, type);
        } else if (type == "DECLARATION_VALUE_STRING" || type == "DECLARATION_VALUE_URI" || type == "DECLARATION_VALUE_IDENT" || type == "DECLARATION_VALUE_HASH") {
            value = this.createStringValue(text, type);
        }
        if (value == null) {
            value = this.createStringValue(text, type);
        }
        if (!this.fTempStructuredDocument && value != null) {
            value.setRangeRegion(this.fParentRegion, region, region);
        }
        return value;
    }

    private CSSPrimitiveValueImpl createPrimitiveValue(ITextRegionList regions) {
        CSSPrimitiveValueImpl value = null;
        CSSUtil.stripSurroundingSpace(regions);
        if (regions.isEmpty()) {
            return null;
        }
        ITextRegion region = regions.get(0);
        if (region == null) {
            return null;
        }
        String type = region.getType();
        if (type == "DECLARATION_VALUE_FUNCTION") {
            String text = this.getText(region).toLowerCase();
            if (text.equals("rgb(")) {
                value = this.createRgbValue(regions);
            } else if (text.equals("counter(")) {
                value = this.createCounterValue(regions);
            } else if (text.equals("counters(")) {
                value = this.createCountersValue(regions);
            } else if (text.equals("attr(")) {
                value = this.createAttrValue(regions);
            } else if (text.equals("format(")) {
                value = this.createFormatValue(regions);
            } else if (text.equals("local(")) {
                value = this.createLocalValue(regions);
            } else if (text.equals("rect(")) {
                value = this.createRectValue(regions);
            }
            if (value == null) {
                value = this.createStringValue(regions);
            }
        } else {
            value = this.createStringValue(regions);
        }
        if (!this.fTempStructuredDocument && value != null) {
            value.setRangeRegion(this.fParentRegion, regions.get(0), regions.get(regions.size() - 1));
        }
        return value;
    }

    private CSSPrimitiveValueImpl createRectValue(ITextRegionList regions) {
        String funcName = this.getFunctionName(regions);
        if (funcName == null || !funcName.toLowerCase().equals("rect")) {
            return null;
        }
        String[] accepts = new String[]{"DECLARATION_VALUE_NUMBER", "DECLARATION_VALUE_DIMENSION", "DECLARATION_VALUE_IDENT"};
        ITextRegionList valueRegions = this.getFunctionParameters(regions, accepts);
        if (valueRegions.size() != 4) {
            return null;
        }
        RectImpl value = this.getRect();
        if (value == null) {
            return null;
        }
        int i = 0;
        while (i < 4) {
            ITextRegion region = valueRegions.get(i);
            CSSPrimitiveValueImpl childValue = null;
            switch (i) {
                case 0: {
                    childValue = (CSSPrimitiveValueImpl)value.getTop();
                    break;
                }
                case 1: {
                    childValue = (CSSPrimitiveValueImpl)value.getRight();
                    break;
                }
                case 2: {
                    childValue = (CSSPrimitiveValueImpl)value.getBottom();
                    break;
                }
                case 3: {
                    childValue = (CSSPrimitiveValueImpl)value.getLeft();
                    break;
                }
            }
            if (childValue == null) {
                return null;
            }
            String text = this.getText(region);
            String type = region.getType();
            if (type == "DECLARATION_VALUE_IDENT") {
                this.setStringValue(childValue, text, type);
            } else {
                this.setFloatValue(childValue, text, type);
            }
            if (!this.fTempStructuredDocument) {
                childValue.setRangeRegion(this.fParentRegion, region, region);
            }
            ++i;
        }
        return value;
    }

    private CSSPrimitiveValueImpl createRgbValue(ITextRegionList regions) {
        String funcName = this.getFunctionName(regions);
        if (funcName == null || !funcName.toLowerCase().equals("rgb")) {
            return null;
        }
        String[] accepts = new String[]{"DECLARATION_VALUE_NUMBER", "DECLARATION_VALUE_PERCENTAGE"};
        ITextRegionList valueRegions = this.getFunctionParameters(regions, accepts);
        if (valueRegions.size() != 3) {
            return null;
        }
        RGBColorImpl value = this.getRGBColor();
        if (value == null) {
            return null;
        }
        int i = 0;
        while (i < 3) {
            ITextRegion region = valueRegions.get(i);
            CSSPrimitiveValueImpl childValue = null;
            switch (i) {
                case 0: {
                    childValue = (CSSPrimitiveValueImpl)value.getRed();
                    break;
                }
                case 1: {
                    childValue = (CSSPrimitiveValueImpl)value.getGreen();
                    break;
                }
                case 2: {
                    childValue = (CSSPrimitiveValueImpl)value.getBlue();
                    break;
                }
            }
            if (childValue == null) {
                return null;
            }
            this.setFloatValue(childValue, this.getText(region), region.getType());
            if (!this.fTempStructuredDocument) {
                childValue.setRangeRegion(this.fParentRegion, region, region);
            }
            ++i;
        }
        return value;
    }

    private CSSPrimitiveValueImpl createStringValue(String text, String type) {
        short valueType = this.getStringValueType(text, type);
        CSSPrimitiveValueImpl value = this.getCSSPrimitiveValue(valueType);
        if (value != null) {
            if (valueType == 20) {
                text = CSSUtil.extractUriContents(text);
            } else if (valueType == 19) {
                text = CSSUtil.extractStringContents(text);
            }
            value.setValue(text);
        }
        return value;
    }

    private CSSPrimitiveValueImpl createStringValue(ITextRegionList regions) {
        String type = "DECLARATION_VALUE_IDENT";
        if (regions.size() == 1) {
            ITextRegion region = regions.get(0);
            type = region.getType();
        }
        return this.createStringValue(this.makeString(regions), type);
    }

    private CounterImpl getCounter() {
        CounterImpl node = this.fUpdateContext != null && this.fUpdateContext.isActive() ? this.fUpdateContext.getCounter() : (CounterImpl)this.fDocument.createCSSPrimitiveValue((short)23);
        return node;
    }

    private CSSPrimitiveValueImpl getCSSPrimitiveValue(short type) {
        CSSPrimitiveValueImpl node = this.fUpdateContext != null && this.fUpdateContext.isActive() ? this.fUpdateContext.getCSSPrimitiveValue(type) : (CSSPrimitiveValueImpl)this.fDocument.createCSSPrimitiveValue(type);
        return node;
    }

    private CSSStyleDeclItemImpl getCSSStyleDeclItem(String propertyName) {
        CSSStyleDeclItemImpl node = this.fUpdateContext != null && this.fUpdateContext.isActive() ? this.fUpdateContext.getCSSStyleDeclItem(propertyName) : (CSSStyleDeclItemImpl)this.fDocument.createCSSStyleDeclItem(propertyName);
        return node;
    }

    static short getFloatValueType(String ident) {
        int valueType = (ident = ident.toLowerCase()).length() == 0 ? 1 : (ident.equals("%") ? 2 : (ident.equalsIgnoreCase("em") ? 3 : (ident.equalsIgnoreCase("ex") ? 4 : (ident.equalsIgnoreCase("px") ? 5 : (ident.equalsIgnoreCase("cm") ? 6 : (ident.equalsIgnoreCase("mm") ? 7 : (ident.equalsIgnoreCase("in") ? 8 : (ident.equalsIgnoreCase("pt") ? 9 : (ident.equalsIgnoreCase("pc") ? 10 : (ident.equalsIgnoreCase("deg") ? 11 : (ident.equalsIgnoreCase("rad") ? 12 : (ident.equalsIgnoreCase("grad") ? 13 : (ident.equalsIgnoreCase("ms") ? 14 : (ident.equalsIgnoreCase("s") ? 15 : (ident.equalsIgnoreCase("hz") ? 16 : (ident.equalsIgnoreCase("khz") ? 17 : 18))))))))))))))));
        return (short)valueType;
    }

    static short getFloatValueType(String value, String ident) {
        int valueType = (ident = ident.toLowerCase()).length() == 0 ? (value.indexOf(46) >= 0 ? 1 : 26) : (ident.equals("%") ? 2 : (ident.equalsIgnoreCase("em") ? 3 : (ident.equalsIgnoreCase("ex") ? 4 : (ident.equalsIgnoreCase("px") ? 5 : (ident.equalsIgnoreCase("cm") ? 6 : (ident.equalsIgnoreCase("mm") ? 7 : (ident.equalsIgnoreCase("in") ? 8 : (ident.equalsIgnoreCase("pt") ? 9 : (ident.equalsIgnoreCase("pc") ? 10 : (ident.equalsIgnoreCase("deg") ? 11 : (ident.equalsIgnoreCase("rad") ? 12 : (ident.equalsIgnoreCase("grad") ? 13 : (ident.equalsIgnoreCase("ms") ? 14 : (ident.equalsIgnoreCase("s") ? 15 : (ident.equalsIgnoreCase("hz") ? 16 : (ident.equalsIgnoreCase("khz") ? 17 : 18))))))))))))))));
        return (short)valueType;
    }

    private String getFunctionName(ITextRegionList regions) {
        if (regions == null || regions.size() < 2) {
            return null;
        }
        ITextRegion firstRegion = regions.get(0);
        if (firstRegion.getType() != "DECLARATION_VALUE_FUNCTION") {
            return null;
        }
        ITextRegion lastRegion = regions.get(regions.size() - 1);
        if (lastRegion.getType() != "DECLARATION_VALUE_PARENTHESIS_CLOSE") {
            return null;
        }
        String text = this.getText(firstRegion);
        return text.substring(0, text.length() - 1);
    }

    private ITextRegionList getFunctionParameters(ITextRegionList regions, String[] accepts) {
        TextRegionListImpl newRegions = new TextRegionListImpl();
        int nAccepts = accepts != null ? accepts.length : 0;
        Iterator i = regions.iterator();
        i.next();
        block0: while (i.hasNext()) {
            String type;
            ITextRegion region = (ITextRegion)i.next();
            if (region == null || CSSDeclarationItemParser.isBlank(type = region.getType())) continue;
            if (nAccepts == 0) {
                newRegions.add(region);
                continue;
            }
            int iAccept = 0;
            while (iAccept < nAccepts) {
                if (type == accepts[iAccept]) {
                    newRegions.add(region);
                    continue block0;
                }
                ++iAccept;
            }
        }
        return newRegions;
    }

    private String getPropertyName(ITextRegionList nodeRegions) {
        TextRegionListImpl nameRegions = new TextRegionListImpl();
        String name = null;
        while (!nodeRegions.isEmpty()) {
            ITextRegion region = nodeRegions.remove(0);
            if (region == null) continue;
            String type = region.getType();
            if (type == "DECLARATION_SEPARATOR") {
                CSSUtil.stripSurroundingSpace((ITextRegionList)nameRegions);
                name = this.makeString((ITextRegionList)nameRegions);
                break;
            }
            nameRegions.add(region);
        }
        return name;
    }

    private RectImpl getRect() {
        RectImpl node = this.fUpdateContext != null && this.fUpdateContext.isActive() ? this.fUpdateContext.getRect() : (RectImpl)this.fDocument.createCSSPrimitiveValue((short)24);
        return node;
    }

    private RGBColorImpl getRGBColor() {
        RGBColorImpl node = this.fUpdateContext != null && this.fUpdateContext.isActive() ? this.fUpdateContext.getRGBColor() : (RGBColorImpl)this.fDocument.createCSSPrimitiveValue((short)25);
        return node;
    }

    private short getStringValueType(String text, String type) {
        int valueType = text.toLowerCase().equals("inherit") ? 33 : (type == "DECLARATION_VALUE_URI" ? 20 : (type == "DECLARATION_VALUE_STRING" ? 19 : (type == "DECLARATION_VALUE_HASH" ? 27 : (type == "DECLARATION_VALUE_OPERATOR" && text.equals(",") ? 32 : (type == "DECLARATION_VALUE_OPERATOR" && text.equals("/") ? 31 : (type == "DECLARATION_VALUE_UNICODE_RANGE" ? 28 : 21))))));
        return (short)valueType;
    }

    private String makeString(ITextRegionList regions) {
        StringBuffer buf = new StringBuffer();
        boolean bSpace = false;
        Iterator i = regions.iterator();
        while (i.hasNext()) {
            ITextRegion region = (ITextRegion)i.next();
            String type = region.getType();
            if (!bSpace && CSSDeclarationItemParser.isBlank(type)) {
                buf.append(" ");
                bSpace = true;
                continue;
            }
            String text = i.hasNext() ? this.getCollapsedText(region) : this.getText(region);
            buf.append(text);
            bSpace = false;
        }
        return buf.toString();
    }

    void setStructuredDocumentTemporary(boolean bTemp) {
        this.fTempStructuredDocument = bTemp;
    }

    private void setFloatValue(CSSPrimitiveValueImpl value, String text, String type) {
        FloatInfo info = new FloatInfo(text);
        value.setFloatValue(info.getValueType(), info.getValue());
    }

    private void setStringValue(CSSPrimitiveValueImpl value, String text, String type) {
        short valueType = this.getStringValueType(text, type);
        value.setStringValue(valueType, text);
    }

    void setUpdateContext(CSSModelUpdateContext updateContext) {
        this.fUpdateContext = updateContext;
    }

    public static boolean hasColonSeparator(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return false;
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null || regions.size() == 0) {
            return false;
        }
        Iterator i = regions.iterator();
        while (i.hasNext()) {
            ITextRegion region = (ITextRegion)i.next();
            if (region == null || region.getType() != "DECLARATION_SEPARATOR") continue;
            return true;
        }
        return false;
    }

    CSSStyleDeclItemImpl setupDeclarationItem(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return null;
        }
        if (!CSSDeclarationItemParser.hasColonSeparator(flatNode)) {
            return null;
        }
        this.fParentRegion = flatNode;
        TextRegionListImpl nodeRegions = new TextRegionListImpl(flatNode.getRegions());
        CSSStyleDeclItemImpl newItem = this.createDeclarationItem((ITextRegionList)nodeRegions);
        if (newItem == null) {
            return null;
        }
        if (!this.fTempStructuredDocument && flatNode != null) {
            newItem.setRangeStructuredDocumentRegion(flatNode, flatNode);
        }
        CSSUtil.stripSurroundingSpace((ITextRegionList)nodeRegions);
        this.setupValues(newItem, (ITextRegionList)nodeRegions, null);
        return newItem;
    }

    void setupValues(ICSSStyleDeclItem item, IStructuredDocumentRegion parentRegion, ITextRegionList nodeRegions, List valueList) {
        this.fParentRegion = parentRegion;
        this.setupValues(item, nodeRegions, valueList);
    }

    private void setupValues(ICSSStyleDeclItem item, ITextRegionList nodeRegions, List propertyValueList) {
        CSSPrimitiveValueImpl value;
        if (item == null) {
            return;
        }
        TextRegionListImpl regionBuf = new TextRegionListImpl();
        String propertyName = item.getPropertyName().toLowerCase();
        boolean bFont = propertyName.equals("font");
        String propertyValue = null;
        int status = propertyName.equals("voice-family") || propertyName.equals("font-family") ? 3 : 0;
        while (!nodeRegions.isEmpty()) {
            value = null;
            ITextRegion region = nodeRegions.remove(0);
            if (region == null) continue;
            if (propertyValueList != null && !propertyValueList.isEmpty()) {
                propertyValue = (String)propertyValueList.remove(0);
            }
            String type = region.getType();
            switch (status) {
                case 0: {
                    if (type == "DECLARATION_VALUE_FUNCTION") {
                        regionBuf.add(region);
                        this.regionValues.put(region, propertyValue);
                        status = 1;
                        break;
                    }
                    if (bFont && type == "DECLARATION_VALUE_OPERATOR" && this.isValueRegionEqual(region, propertyValue, "/")) {
                        value = this.createPrimitiveValue(region, propertyValue);
                        status = 2;
                        break;
                    }
                    if (CSSDeclarationItemParser.isBlank(type)) break;
                    value = this.createPrimitiveValue(region, propertyValue);
                    break;
                }
                case 1: {
                    if (type == "DECLARATION_VALUE_PARENTHESIS_CLOSE") {
                        regionBuf.add(region);
                        this.regionValues.put(region, propertyValue);
                        value = this.createPrimitiveValue((ITextRegionList)regionBuf);
                        regionBuf.clear();
                        this.regionValues.clear();
                        status = 0;
                        break;
                    }
                    if (CSSDeclarationItemParser.isBlank(type)) break;
                    regionBuf.add(region);
                    this.regionValues.put(region, propertyValue);
                    break;
                }
                case 2: {
                    if (type == "DECLARATION_VALUE_DIMENSION") {
                        value = this.createPrimitiveValue(region, propertyValue);
                        status = 3;
                        break;
                    }
                    if (CSSDeclarationItemParser.isBlank(type)) break;
                    value = this.createPrimitiveValue(region, propertyValue);
                    break;
                }
                case 3: {
                    if (type == "DECLARATION_VALUE_OPERATOR" && this.isValueRegionEqual(region, propertyValue, ",")) {
                        value = this.createPrimitiveValue((ITextRegionList)regionBuf);
                        regionBuf.clear();
                        this.regionValues.clear();
                        if (!(value == null || this.fUpdateContext != null && this.fUpdateContext.isActive())) {
                            item.appendValue(value);
                        }
                        value = this.createPrimitiveValue(region, propertyValue);
                        break;
                    }
                    regionBuf.add(region);
                    this.regionValues.put(region, propertyValue);
                    break;
                }
            }
            if (value == null || this.fUpdateContext != null && this.fUpdateContext.isActive()) continue;
            item.appendValue(value);
        }
        if (!regionBuf.isEmpty()) {
            value = this.createPrimitiveValue((ITextRegionList)regionBuf);
            if (this.fUpdateContext == null || !this.fUpdateContext.isActive()) {
                item.appendValue(value);
            }
            regionBuf.clear();
            this.regionValues.clear();
        }
    }

    private boolean isValueRegionEqual(ITextRegion region, String propertyValue, String string) {
        return propertyValue != null ? string.equals(propertyValue) : this.fParentRegion.getText(region).equals(string);
    }

    private String getCollapsedText(ITextRegion region) {
        if (this.fParentRegion == null) {
            return "";
        }
        String value = (String)this.regionValues.get(region);
        StringBuffer text = new StringBuffer(value != null ? value : this.fParentRegion.getFullText(region));
        if (region.getLength() > region.getTextLength()) {
            text.replace(region.getTextLength(), region.getLength(), " ");
        }
        return text.toString();
    }

    private String getText(ITextRegion region) {
        String value = (String)this.regionValues.get(region);
        return value != null ? value : (this.fParentRegion != null ? this.fParentRegion.getText(region) : "");
    }

    private static boolean isBlank(String type) {
        return type == "S" || type == "COMMENT" || type == "DECLARATION_VALUE_S";
    }

    final class FloatInfo {
        private float fValue = 0.0f;
        private String fIdentifier = null;
        private short fType = 0;

        FloatInfo(String text) {
            this.parse(text);
        }

        void parse(String text) {
            StringBuffer bufValue = new StringBuffer();
            StringBuffer bufIdent = new StringBuffer();
            boolean bNum = true;
            int len = text.length();
            int i = 0;
            while (i < len) {
                char c = text.charAt(i);
                if (bNum) {
                    if ('0' <= c && c <= '9' || c == '.' || (c == '+' || c == '-') && i == 0) {
                        bufValue.append(c);
                    } else {
                        bufIdent.append(c);
                        bNum = false;
                    }
                } else {
                    bufIdent.append(c);
                }
                ++i;
            }
            String valueStr = bufValue.toString();
            try {
                this.fValue = Float.valueOf(valueStr).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                bufIdent.insert(0, valueStr);
            }
            this.fIdentifier = bufIdent.toString();
            this.fType = CSSDeclarationItemParser.getFloatValueType(valueStr, this.fIdentifier);
        }

        float getValue() {
            return this.fValue;
        }

        String getIdentifier() {
            return this.fIdentifier;
        }

        short getValueType() {
            return this.fType;
        }
    }
}

