/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.platform;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.utility.ExtensionPointTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatform;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformManager;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.InternalJaxbWorkbench;
import org.eclipse.jpt.jaxb.ui.internal.platform.JaxbPlatformUiConfig;
import org.eclipse.jpt.jaxb.ui.internal.plugin.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.platform.JaxbPlatformUi;
import org.eclipse.jpt.jaxb.ui.platform.JaxbPlatformUiManager;

public class InternalJaxbPlatformUiManager
implements JaxbPlatformUiManager {
    private final InternalJaxbWorkbench jaxbWorkbench;
    private final ArrayList<JaxbPlatformUiConfig> jaxbPlatformUiConfigs = new ArrayList();
    private static final String SIMPLE_EXTENSION_POINT_NAME = "jaxbPlatformUis";
    private static final String JAXB_PLATFORM_UI_ELEMENT = "jaxbPlatformUi";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String JAXB_PLATFORM_ATTRIBUTE = "jaxbPlatform";

    public InternalJaxbPlatformUiManager(InternalJaxbWorkbench jaxbWorkbench) {
        this.jaxbWorkbench = jaxbWorkbench;
        this.initialize();
    }

    private void initialize() {
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            throw new IllegalStateException("missing extension point: " + this.getExtensionPointName());
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                JaxbPlatformUiConfig config;
                IConfigurationElement element = iConfigurationElementArray[n4];
                String elementName = element.getName();
                if (elementName.equals(JAXB_PLATFORM_UI_ELEMENT) && (config = this.buildJaxbPlatformUiConfig(element)) != null) {
                    this.jaxbPlatformUiConfigs.add(config);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private JaxbPlatformUiConfig buildJaxbPlatformUiConfig(IConfigurationElement element) {
        String contributor = element.getContributor().getName();
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (StringTools.isBlank((String)id)) {
            this.logMissingAttribute(element, ID_ATTRIBUTE);
            return null;
        }
        if (this.containsJaxbPlatformUiConfig(id)) {
            this.logError(JptCommonCoreMessages.REGISTRY_DUPLICATE, this.getExtensionPointName(), contributor, ID_ATTRIBUTE, id);
            return null;
        }
        String className = element.getAttribute(CLASS_ATTRIBUTE);
        if (className == null) {
            this.logMissingAttribute(element, CLASS_ATTRIBUTE);
            return null;
        }
        String jaxbPlatformID = element.getAttribute(JAXB_PLATFORM_ATTRIBUTE);
        if (jaxbPlatformID == null) {
            this.logMissingAttribute(element, JAXB_PLATFORM_ATTRIBUTE);
            return null;
        }
        if (this.containsJaxbPlatformUiConfigForJaxbPlatform(jaxbPlatformID)) {
            this.logError(JptCommonCoreMessages.REGISTRY_DUPLICATE, this.getExtensionPointName(), contributor, JAXB_PLATFORM_ATTRIBUTE, jaxbPlatformID);
            return null;
        }
        if (this.jaxbPlatformConfigIsMissing(jaxbPlatformID)) {
            this.logMissingJaxbPlatform(element, jaxbPlatformID);
            return null;
        }
        JaxbPlatformUiConfig config = new JaxbPlatformUiConfig(this, id, className, jaxbPlatformID);
        config.setPluginID(contributor);
        return config;
    }

    public JaxbPlatformUi getJaxbPlatformUi(JaxbPlatform jaxbPlatform) {
        JaxbPlatformUiConfig config = this.getJaxbPlatformUiConfigForJaxbPlatform(jaxbPlatform.getConfig().getId());
        return config == null ? null : config.getJaxbPlatformUi();
    }

    private boolean containsJaxbPlatformUiConfig(String id) {
        return this.getJaxbPlatformUiConfig(id) != null;
    }

    private JaxbPlatformUiConfig getJaxbPlatformUiConfig(String id) {
        for (JaxbPlatformUiConfig config : this.jaxbPlatformUiConfigs) {
            if (!config.getID().equals(id)) continue;
            return config;
        }
        return null;
    }

    private boolean containsJaxbPlatformUiConfigForJaxbPlatform(String jaxbPlatformID) {
        return this.getJaxbPlatformUiConfigForJaxbPlatform(jaxbPlatformID) != null;
    }

    private JaxbPlatformUiConfig getJaxbPlatformUiConfigForJaxbPlatform(String jaxbPlatformID) {
        for (JaxbPlatformUiConfig config : this.jaxbPlatformUiConfigs) {
            if (!config.getJaxbPlatformID().equals(jaxbPlatformID)) continue;
            return config;
        }
        return null;
    }

    private void logMissingJaxbPlatform(IConfigurationElement element, String jaxbPlatformID) {
        this.logError(JptJaxbUiMessages.JAXB_PLATFORM_UI_MISSING_JAXB_PLATFORM, jaxbPlatformID, element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getContributor().getName());
    }

    private void logError(String msg, Object ... args) {
        this.getPlugin().logError(msg, args);
    }

    private void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.getPlugin().logError(ExtensionPointTools.buildMissingAttributeMessage((IConfigurationElement)element, (String)attributeName));
    }

    public InternalJaxbWorkbench getJaxbWorkbench() {
        return this.jaxbWorkbench;
    }

    String getExtensionPointName() {
        return String.valueOf(this.getPluginID()) + '.' + SIMPLE_EXTENSION_POINT_NAME;
    }

    private IExtensionPoint getExtensionPoint() {
        return this.getExtensionRegistry().getExtensionPoint(this.getPluginID(), SIMPLE_EXTENSION_POINT_NAME);
    }

    private IExtensionRegistry getExtensionRegistry() {
        return RegistryFactory.getRegistry();
    }

    private String getPluginID() {
        return this.getPlugin().getPluginID();
    }

    private JptJaxbUiPlugin getPlugin() {
        return JptJaxbUiPlugin.instance();
    }

    private boolean jaxbPlatformConfigIsMissing(String jaxbPlatformID) {
        return this.getJaxbPlatformConfig(jaxbPlatformID) == null;
    }

    private JaxbPlatformConfig getJaxbPlatformConfig(String jaxbPlatformID) {
        JaxbPlatformManager jaxbPlatformManager = this.getJaxbPlatformManager();
        return jaxbPlatformManager == null ? null : jaxbPlatformManager.getJaxbPlatformConfig(jaxbPlatformID);
    }

    private JaxbPlatformManager getJaxbPlatformManager() {
        JaxbWorkspace jaxbWorkspace = this.getJaxbWorkspace();
        return jaxbWorkspace == null ? null : jaxbWorkspace.getJaxbPlatformManager();
    }

    private JaxbWorkspace getJaxbWorkspace() {
        return this.jaxbWorkbench.getJaxbWorkspace();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.jaxbPlatformUiConfigs);
    }
}

