/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.Network;
import com.squareup.okhttp.internal.RouteDatabase;
import com.squareup.okhttp.internal.Util;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;

public final class RouteSelector {
    private final Address address;
    private final URI uri;
    private final Network network;
    private final OkHttpClient client;
    private final RouteDatabase routeDatabase;
    private final Request request;
    private Proxy lastProxy;
    private InetSocketAddress lastInetSocketAddress;
    private ConnectionSpec lastSpec;
    private List<Proxy> proxies = Collections.emptyList();
    private int nextProxyIndex;
    private List<InetSocketAddress> inetSocketAddresses = Collections.emptyList();
    private int nextInetSocketAddressIndex;
    private List<ConnectionSpec> connectionSpecs = Collections.emptyList();
    private int nextSpecIndex;
    private final List<Route> postponedRoutes = new ArrayList<Route>();

    private RouteSelector(Address address, URI uri, OkHttpClient client, Request request) {
        this.address = address;
        this.uri = uri;
        this.client = client;
        this.routeDatabase = Internal.instance.routeDatabase(client);
        this.network = Internal.instance.network(client);
        this.request = request;
        this.resetNextProxy(uri, address.getProxy());
    }

    public static RouteSelector get(Address address, Request request, OkHttpClient client) throws IOException {
        return new RouteSelector(address, request.uri(), client, request);
    }

    public boolean hasNext() {
        return this.hasNextConnectionSpec() || this.hasNextInetSocketAddress() || this.hasNextProxy() || this.hasNextPostponed();
    }

    public Route next() throws IOException {
        if (!this.hasNextConnectionSpec()) {
            if (!this.hasNextInetSocketAddress()) {
                if (!this.hasNextProxy()) {
                    if (!this.hasNextPostponed()) {
                        throw new NoSuchElementException();
                    }
                    return this.nextPostponed();
                }
                this.lastProxy = this.nextProxy();
            }
            this.lastInetSocketAddress = this.nextInetSocketAddress();
        }
        this.lastSpec = this.nextConnectionSpec();
        boolean shouldSendTlsFallbackIndicator = this.shouldSendTlsFallbackIndicator(this.lastSpec);
        Route route = new Route(this.address, this.lastProxy, this.lastInetSocketAddress, this.lastSpec, shouldSendTlsFallbackIndicator);
        if (this.routeDatabase.shouldPostpone(route)) {
            this.postponedRoutes.add(route);
            return this.next();
        }
        return route;
    }

    private boolean shouldSendTlsFallbackIndicator(ConnectionSpec connectionSpec) {
        return connectionSpec != this.connectionSpecs.get(0) && connectionSpec.isTls();
    }

    public void connectFailed(Route failedRoute, IOException failure) {
        if (failedRoute.getProxy().type() != Proxy.Type.DIRECT && this.address.getProxySelector() != null) {
            this.address.getProxySelector().connectFailed(this.uri, failedRoute.getProxy().address(), failure);
        }
        this.routeDatabase.failed(failedRoute);
        if (!(failure instanceof SSLHandshakeException) && !(failure instanceof SSLProtocolException)) {
            while (this.nextSpecIndex < this.connectionSpecs.size()) {
                ConnectionSpec connectionSpec = this.connectionSpecs.get(this.nextSpecIndex++);
                boolean shouldSendTlsFallbackIndicator = this.shouldSendTlsFallbackIndicator(connectionSpec);
                Route toSuppress = new Route(this.address, this.lastProxy, this.lastInetSocketAddress, connectionSpec, shouldSendTlsFallbackIndicator);
                this.routeDatabase.failed(toSuppress);
            }
        }
    }

    private void resetNextProxy(URI uri, Proxy proxy) {
        if (proxy != null) {
            this.proxies = Collections.singletonList(proxy);
        } else {
            this.proxies = new ArrayList<Proxy>();
            List<Proxy> selectedProxies = this.client.getProxySelector().select(uri);
            if (selectedProxies != null) {
                this.proxies.addAll(selectedProxies);
            }
            this.proxies.removeAll(Collections.singleton(Proxy.NO_PROXY));
            this.proxies.add(Proxy.NO_PROXY);
        }
        this.nextProxyIndex = 0;
    }

    private boolean hasNextProxy() {
        return this.nextProxyIndex < this.proxies.size();
    }

    private Proxy nextProxy() throws IOException {
        if (!this.hasNextProxy()) {
            throw new SocketException("No route to " + this.address.getUriHost() + "; exhausted proxy configurations: " + this.proxies);
        }
        Proxy result = this.proxies.get(this.nextProxyIndex++);
        this.resetNextInetSocketAddress(result);
        return result;
    }

    private void resetNextInetSocketAddress(Proxy proxy) throws IOException {
        int socketPort;
        String socketHost;
        this.inetSocketAddresses = new ArrayList<InetSocketAddress>();
        if (proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.SOCKS) {
            socketHost = this.address.getUriHost();
            socketPort = Util.getEffectivePort(this.uri);
        } else {
            SocketAddress proxyAddress = proxy.address();
            if (!(proxyAddress instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Proxy.address() is not an InetSocketAddress: " + proxyAddress.getClass());
            }
            InetSocketAddress proxySocketAddress = (InetSocketAddress)proxyAddress;
            socketHost = RouteSelector.getHostString(proxySocketAddress);
            socketPort = proxySocketAddress.getPort();
        }
        if (socketPort < 1 || socketPort > 65535) {
            throw new SocketException("No route to " + socketHost + ":" + socketPort + "; port is out of range");
        }
        for (InetAddress inetAddress : this.network.resolveInetAddresses(socketHost)) {
            this.inetSocketAddresses.add(new InetSocketAddress(inetAddress, socketPort));
        }
        this.nextInetSocketAddressIndex = 0;
    }

    static String getHostString(InetSocketAddress socketAddress) {
        InetAddress address = socketAddress.getAddress();
        if (address == null) {
            return socketAddress.getHostName();
        }
        return address.getHostAddress();
    }

    private boolean hasNextInetSocketAddress() {
        return this.nextInetSocketAddressIndex < this.inetSocketAddresses.size();
    }

    private InetSocketAddress nextInetSocketAddress() throws IOException {
        if (!this.hasNextInetSocketAddress()) {
            throw new SocketException("No route to " + this.address.getUriHost() + "; exhausted inet socket addresses: " + this.inetSocketAddresses);
        }
        InetSocketAddress result = this.inetSocketAddresses.get(this.nextInetSocketAddressIndex++);
        this.resetConnectionSpecs();
        return result;
    }

    private void resetConnectionSpecs() {
        this.connectionSpecs = new ArrayList<ConnectionSpec>();
        List<ConnectionSpec> specs = this.address.getConnectionSpecs();
        int size = specs.size();
        for (int i = 0; i < size; ++i) {
            ConnectionSpec spec = specs.get(i);
            if (this.request.isHttps() != spec.isTls()) continue;
            this.connectionSpecs.add(spec);
        }
        this.nextSpecIndex = 0;
    }

    private boolean hasNextConnectionSpec() {
        return this.nextSpecIndex < this.connectionSpecs.size();
    }

    private ConnectionSpec nextConnectionSpec() throws IOException {
        if (this.connectionSpecs.isEmpty()) {
            throw new UnknownServiceException("No route to " + (this.uri.getScheme() != null ? this.uri.getScheme() + "://" : "//") + this.address.getUriHost() + "; no connection specs");
        }
        if (!this.hasNextConnectionSpec()) {
            throw new SocketException("No route to " + (this.uri.getScheme() != null ? this.uri.getScheme() + "://" : "//") + this.address.getUriHost() + "; exhausted connection specs: " + this.connectionSpecs);
        }
        return this.connectionSpecs.get(this.nextSpecIndex++);
    }

    private boolean hasNextPostponed() {
        return !this.postponedRoutes.isEmpty();
    }

    private Route nextPostponed() {
        return this.postponedRoutes.remove(0);
    }
}

