/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlJoinNodeAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceXmlJoinNodeAnnotation
extends SourceAnnotation
implements XmlJoinNodeAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.oxm.annotations.XmlJoinNode");
    public static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.oxm.annotations.XmlJoinNodes");
    private final DeclarationAnnotationElementAdapter<String> xmlPathDeclarationAdapter;
    private final AnnotationElementAdapter<String> xmlPathAdapter;
    private String xmlPath;
    private TextRange xmlPathTextRange;
    private TextRange xmlPathValidationTextRange;
    private final DeclarationAnnotationElementAdapter<String> referencedXmlPathDeclarationAdapter;
    private final AnnotationElementAdapter<String> referencedXmlPathAdapter;
    private String referencedXmlPath;
    private TextRange referencedXmlPathTextRange;
    private TextRange referencedXmlPathValidationTextRange;

    public static SourceXmlJoinNodeAnnotation buildSourceXmlJoinNodeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, int index) {
        IndexedDeclarationAnnotationAdapter idaa = SourceXmlJoinNodeAnnotation.buildXmlJoinNodeDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = SourceXmlJoinNodeAnnotation.buildXmlJoinNodeAnnotationAdapter(annotatedElement, idaa);
        return new SourceXmlJoinNodeAnnotation(parent, annotatedElement, idaa, iaa);
    }

    private SourceXmlJoinNodeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter daa, IndexedAnnotationAdapter annotationAdapter) {
        super((JavaResourceModel)parent, annotatedElement, (DeclarationAnnotationAdapter)daa, (AnnotationAdapter)annotationAdapter);
        this.xmlPathDeclarationAdapter = this.buildXmlPathAdapter((DeclarationAnnotationAdapter)daa);
        this.xmlPathAdapter = this.buildAnnotationElementAdapter(this.xmlPathDeclarationAdapter);
        this.referencedXmlPathDeclarationAdapter = this.buildReferencedXmlPathAdapter((DeclarationAnnotationAdapter)daa);
        this.referencedXmlPathAdapter = this.buildAnnotationElementAdapter(this.referencedXmlPathDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildXmlPathAdapter(DeclarationAnnotationAdapter daa) {
        return this.buildAnnotationElementAdapter(daa, "xmlPath", (ExpressionConverter<String>)StringExpressionConverter.instance());
    }

    private DeclarationAnnotationElementAdapter<String> buildReferencedXmlPathAdapter(DeclarationAnnotationAdapter daa) {
        return this.buildAnnotationElementAdapter(daa, "referencedXmlPath", (ExpressionConverter<String>)StringExpressionConverter.instance());
    }

    private DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.oxm.annotations.XmlJoinNode";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.xmlPath = this.buildXmlPath(astAnnotation);
        this.xmlPathTextRange = this.buildXmlPathTextRange(astAnnotation);
        this.xmlPathValidationTextRange = this.buildXmlPathValidationTextRange(astAnnotation);
        this.referencedXmlPath = this.buildReferencedXmlPath(astAnnotation);
        this.referencedXmlPathTextRange = this.buildReferencedXmlPathTextRange(astAnnotation);
        this.referencedXmlPathValidationTextRange = this.buildReferencedXmlPathValidationTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncXmlPath(this.buildXmlPath(astAnnotation));
        this.xmlPathTextRange = this.buildXmlPathTextRange(astAnnotation);
        this.xmlPathValidationTextRange = this.buildXmlPathValidationTextRange(astAnnotation);
        this.syncReferencedXmlPath(this.buildReferencedXmlPath(astAnnotation));
        this.referencedXmlPathTextRange = this.buildReferencedXmlPathTextRange(astAnnotation);
        this.referencedXmlPathValidationTextRange = this.buildReferencedXmlPathValidationTextRange(astAnnotation);
    }

    public void toString(StringBuilder sb) {
        sb.append(String.valueOf(this.xmlPath) + " -> " + this.referencedXmlPath);
    }

    @Override
    public String getXmlPath() {
        return this.xmlPath;
    }

    @Override
    public void setXmlPath(String xmlPath) {
        if (ObjectTools.notEquals((Object)this.xmlPath, (Object)xmlPath)) {
            this.xmlPath = xmlPath;
            this.xmlPathAdapter.setValue((Object)xmlPath);
        }
    }

    private void syncXmlPath(String astXmlPath) {
        String old = this.xmlPath;
        this.xmlPath = astXmlPath;
        this.firePropertyChanged("xmlPath", old, astXmlPath);
    }

    private String buildXmlPath(Annotation astAnnotation) {
        return (String)this.xmlPathAdapter.getValue(astAnnotation);
    }

    private TextRange buildXmlPathTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(this.xmlPathDeclarationAdapter, astAnnotation);
    }

    private TextRange buildXmlPathValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.xmlPathDeclarationAdapter, astAnnotation);
    }

    @Override
    public TextRange getXmlPathTextRange() {
        return this.xmlPathTextRange;
    }

    @Override
    public TextRange getXmlPathValidationTextRange() {
        return this.xmlPathValidationTextRange;
    }

    @Override
    public boolean xmlPathTouches(int pos) {
        return this.textRangeTouches(this.xmlPathTextRange, pos);
    }

    @Override
    public String getReferencedXmlPath() {
        return this.referencedXmlPath;
    }

    @Override
    public void setReferencedXmlPath(String referencedXmlPath) {
        if (ObjectTools.notEquals((Object)this.referencedXmlPath, (Object)referencedXmlPath)) {
            this.referencedXmlPath = referencedXmlPath;
            this.referencedXmlPathAdapter.setValue((Object)referencedXmlPath);
        }
    }

    private void syncReferencedXmlPath(String astReferencedXmlPath) {
        String old = this.referencedXmlPath;
        this.referencedXmlPath = astReferencedXmlPath;
        this.firePropertyChanged("referencedXmlPath", old, astReferencedXmlPath);
    }

    private String buildReferencedXmlPath(Annotation astAnnotation) {
        return (String)this.referencedXmlPathAdapter.getValue(astAnnotation);
    }

    private TextRange buildReferencedXmlPathTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(this.referencedXmlPathDeclarationAdapter, astAnnotation);
    }

    private TextRange buildReferencedXmlPathValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.referencedXmlPathDeclarationAdapter, astAnnotation);
    }

    @Override
    public TextRange getReferencedXmlPathTextRange() {
        return this.referencedXmlPathTextRange;
    }

    @Override
    public TextRange getReferencedXmlPathValidationTextRange() {
        return this.referencedXmlPathValidationTextRange;
    }

    @Override
    public boolean referencedXmlPathTouches(int pos) {
        return this.textRangeTouches(this.referencedXmlPathTextRange, pos);
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    private static IndexedAnnotationAdapter buildXmlJoinNodeAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    private static IndexedDeclarationAnnotationAdapter buildXmlJoinNodeDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        return idaa;
    }
}

