/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.server.mars;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.io.Files;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.server.mars.IO;
import org.eclipse.epp.internal.logging.aeri.ide.server.mars.Zips;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Formats;
import org.eclipse.epp.logging.aeri.core.ILink;
import org.eclipse.epp.logging.aeri.core.IModelFactory;
import org.eclipse.epp.logging.aeri.core.IProblemState;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.ProblemStatus;
import org.eclipse.epp.logging.aeri.core.ResetSendMode;
import org.eclipse.epp.logging.aeri.core.SendMode;
import org.eclipse.epp.logging.aeri.core.util.Links;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.epp.logging.aeri.core.util.Statuses;

public class ServerProblemsHistory
extends AbstractIdleService {
    public static final String F_VERSION = "version";
    public static final String VERSION = "0.6";
    public static final String F_MESSAGE = "message";
    public static final String F_ACTION = "action";
    public static final String F_BUG_ID = "bugId";
    public static final String F_BUG_URL = "bugUrl";
    public static final String F_PROBLEM_URL = "problemUrl";
    public static final String F_FINGERPRINT = "fingerprint";
    private File stateLocation;
    private Directory index;
    private SearcherManager manager;

    public ServerProblemsHistory(File stateLocation) {
        this.stateLocation = stateLocation;
    }

    @PostConstruct
    private void e4PostConstruct() {
        this.startAsync();
    }

    protected void startUp() throws Exception {
        this.index = this.createIndexDirectory();
        if (!IndexReader.indexExists((Directory)this.index)) {
            this.createInitialIndex(this.index);
        }
        this.manager = new SearcherManager(this.index, null, null);
    }

    @VisibleForTesting
    protected Directory createIndexDirectory() throws IOException {
        this.stateLocation.mkdirs();
        FSDirectory directory = FSDirectory.open((File)this.stateLocation);
        return directory;
    }

    private void createInitialIndex(Directory directory) throws IOException {
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)new KeywordAnalyzer());
        conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        Throwable throwable = null;
        Object var4_5 = null;
        try (IndexWriter writer = new IndexWriter(directory, conf);){
            Document meta = new Document();
            meta.add((Fieldable)new Field(F_VERSION, VERSION, Field.Store.YES, Field.Index.NO));
            writer.addDocument(meta);
            writer.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public IProblemState seen(IStatus status) {
        Preconditions.checkNotNull((Object)status);
        Preconditions.checkState((boolean)this.isRunning());
        String fingerprint = Statuses.traceIdentityHash((IStatus)status);
        return this.seen((Query)new TermQuery(new Term(F_FINGERPRINT, fingerprint)));
    }

    private IProblemState seen(Query q) {
        IndexSearcher searcher = this.manager.acquire();
        try {
            TopDocs results = searcher.search(q, 1);
            if (results.totalHits > 0) {
                IProblemState status;
                int doc = results.scoreDocs[0].doc;
                Document d = searcher.doc(doc);
                IProblemState iProblemState = status = this.loadStatus(d);
                return iProblemState;
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_INDEX_NOT_AVAILABLE, (Throwable)e);
        }
        finally {
            try {
                this.manager.release(searcher);
            }
            catch (IOException e) {
                Logs.log((Logs.ILogMessage)LogMessages.WARN_INDEX_NOT_AVAILABLE, (Throwable)e);
            }
        }
        IProblemState state = IModelFactory.eINSTANCE.createProblemState();
        state.setStatus(ProblemStatus.UNCONFIRMED);
        return state;
    }

    private IProblemState loadStatus(Document d) {
        IProblemState state = IModelFactory.eINSTANCE.createProblemState();
        String bugUrl = StringUtils.stripToNull((String)d.get(F_BUG_URL));
        String bugId = StringUtils.stripToNull((String)d.get(F_BUG_ID));
        ProblemStatus status = this.parseProblemStatus(d.get(F_ACTION));
        String message = StringUtils.stripToNull((String)d.get(F_MESSAGE));
        if (bugId != null) {
            ILink bug = Links.createBugLink((String)bugUrl, (String)Formats.format(Messages.LINK_TEXT_BUG, bugId));
            state.getLinks().put((Object)"bug", (Object)bug);
        }
        state.setStatus(status);
        state.setMessage(message);
        return state;
    }

    /*
     * Exception decompiling
     */
    private ProblemStatus parseProblemStatus(String string) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[8] lbl46 : CaseStatement: default:\u000a, @NONE, blocks:[8] lbl46 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replaceContent(File tempDir) throws IOException {
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)new KeywordAnalyzer());
        conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            IndexWriter writer = new IndexWriter(this.index, conf);
            try {
                try (FSDirectory newContent = FSDirectory.open((File)tempDir);){
                    writer.deleteAll();
                    writer.addIndexes(new Directory[]{newContent});
                    writer.commit();
                    this.indexChanged();
                }
                if (writer == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            writer.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    protected void indexChanged() throws IOException {
        this.manager.maybeReopen();
    }

    @PreDestroy
    private void e4PreDestroy() {
        try {
            this.stopAsync().awaitTerminated(2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_HISTORY_STOP_FAILED, (Throwable)e);
        }
    }

    protected void shutDown() throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{this.index});
        this.manager.close();
    }

    public static class RemoteProblemsHistoryFilter
    implements Predicate<IStatus> {
        private ServerProblemsHistory index;

        public RemoteProblemsHistoryFilter(ServerProblemsHistory index) {
            this.index = index;
        }

        public boolean apply(IStatus input) {
            if (!this.index.isRunning()) {
                return true;
            }
            IProblemState status = this.index.seen(input);
            switch (status.getStatus()) {
                case INVALID: 
                case FAILURE: 
                case IGNORED: {
                    return false;
                }
                case NEW: 
                case CONFIRMED: 
                case UNCONFIRMED: 
                case NEEDINFO: 
                case FIXED: {
                    return true;
                }
            }
            Logs.log((Logs.ILogMessage)LogMessages.DEBUG_UNKNOWN_SERVER_STATUS, (Object[])new Object[]{status.getStatus()});
            return true;
        }
    }

    public static class UpdateIndexJob
    extends Job {
        private IO io;
        private ISystemSettings settings;
        private ServerProblemsHistory history;

        public UpdateIndexJob(IO io, ISystemSettings settings, ServerProblemsHistory history) {
            super(Messages.JOB_NAME_UPDATE_INDEX);
            this.io = io;
            this.settings = settings;
            this.history = history;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            progress.beginTask(Messages.JOB_TASK_NAME_CHECKING_INDEX, 1000);
            if (!this.io.isProblemsDatabaseOutdated()) {
                return Status.OK_STATUS;
            }
            try {
                progress.subTask(Messages.JOB_TASK_NAME_CHECKING_REMOTE_STATUS);
                File tempRemoteIndexZip = File.createTempFile("problems-index", ".zip");
                int downloadStatus = this.io.downloadDatabase(tempRemoteIndexZip, (IProgressMonitor)progress);
                if (downloadStatus == 304) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                if (downloadStatus != 200) {
                    this.settings.setSendMode(SendMode.NEVER);
                    this.settings.setResetSendMode(ResetSendMode.RESTART);
                    Logs.log((Logs.ILogMessage)LogMessages.INFO_SERVER_NOT_AVAILABLE);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                progress.worked(1);
                File tempDir = Files.createTempDir();
                progress.subTask(Messages.JOB_TASK_NAME_REPLACING_LOCAL_DATABASE);
                Zips.unzip(tempRemoteIndexZip, tempDir);
                this.history.replaceContent(tempDir);
                progress.worked(1);
                tempRemoteIndexZip.delete();
                FileUtils.deleteDirectory((File)tempDir);
                progress.worked(1);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (CancellationException cancellationException) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.WARN_INDEX_UPDATE_FAILED, (Throwable)e);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }
}

