/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.server.mars;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.logging.aeri.core.filters.StatusIgnorePattern;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.epp.logging.aeri.core.util.WildcardPatterns;
import org.eclipse.jdt.annotation.Nullable;

public class ServerConfiguration {
    private String version;
    private String title;
    private String description;
    private long timestamp;
    private long ttl;
    private String helpUrl;
    private String feedbackUrl;
    private String aboutUrl;
    private String submitUrl;
    private int maxReportSize;
    private String problemsUrl;
    private long problemsTtl;
    private String queryUrl;
    private int connectTimeout = (int)TimeUnit.SECONDS.toMillis(3L);
    private int socketTimeout = (int)TimeUnit.SECONDS.toMillis(10L);
    private List<String> acceptedProducts;
    @Nullable
    private transient List<Pattern> acceptedProductsPatterns;
    private List<String> acceptedPlugins;
    @Nullable
    private transient List<Pattern> acceptedPluginsPatterns;
    private List<String> acceptedPackages;
    @Nullable
    private transient List<Pattern> acceptedPackagesPatterns;
    private List<String> requiredPackages;
    @Nullable
    private transient List<Pattern> requiredPackagesPatterns;
    private boolean acceptOtherPackages;
    private boolean acceptUiFreezes;
    private List<String> ignoredStatuses;
    @Nullable
    private transient List<StatusIgnorePattern> ignoredPatterns;
    private long problemsZipLastDownloadTimestamp;

    public int getConnectTimeoutMs() {
        return (int)TimeUnit.MILLISECONDS.convert(this.connectTimeout, TimeUnit.SECONDS);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeoutMs() {
        return (int)TimeUnit.MILLISECONDS.convert(this.socketTimeout, TimeUnit.SECONDS);
    }

    public long getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getTtl() {
        return this.ttl;
    }

    public long getTtlMs() {
        return TimeUnit.MILLISECONDS.convert(this.getTtl(), TimeUnit.MINUTES);
    }

    public void setTtl(long ttlInMinutes) {
        this.ttl = ttlInMinutes;
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    public String getFeedbackUrl() {
        return this.feedbackUrl;
    }

    public void setFeedbackUrl(String feedbackUrl) {
        this.feedbackUrl = feedbackUrl;
    }

    public String getAboutUrl() {
        return this.aboutUrl;
    }

    public void setAboutUrl(String aboutUrl) {
        this.aboutUrl = aboutUrl;
    }

    public String getSubmitUrl() {
        return this.submitUrl;
    }

    public void setSubmitUrl(String submitUrl) {
        this.submitUrl = submitUrl;
    }

    public int getMaxReportSize() {
        return this.maxReportSize;
    }

    public void setMaxReportSize(int submitSizeLimit) {
        this.maxReportSize = submitSizeLimit;
    }

    public String getProblemsUrl() {
        return this.problemsUrl;
    }

    public void setProblemsUrl(String problemsUrl) {
        this.problemsUrl = problemsUrl;
    }

    public long getProblemsTtl() {
        return this.problemsTtl;
    }

    public long getProblemsTtlMs() {
        return TimeUnit.MILLISECONDS.convert(this.getProblemsTtl(), TimeUnit.MINUTES);
    }

    public void setProblemsTtl(long problemsTtlInMinutes) {
        this.problemsTtl = problemsTtlInMinutes;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public void setQueryUrl(String queryUrl) {
        this.queryUrl = queryUrl;
    }

    public List<String> getAcceptedProducts() {
        return this.acceptedProducts;
    }

    public void setAcceptedProducts(List<String> acceptedProducts) {
        this.acceptedProducts = acceptedProducts;
        this.acceptedProductsPatterns = null;
    }

    public List<String> getAcceptedPlugins() {
        return this.acceptedPlugins;
    }

    public void setAcceptedPlugins(List<String> acceptedPlugins) {
        this.acceptedPlugins = acceptedPlugins;
        this.acceptedPluginsPatterns = null;
    }

    public List<Pattern> getAcceptedProductsPatterns() {
        if (this.acceptedProductsPatterns == null) {
            this.acceptedProductsPatterns = WildcardPatterns.convert(this.acceptedProducts);
        }
        return this.acceptedProductsPatterns;
    }

    public List<Pattern> getAcceptedPluginsPatterns() {
        if (this.acceptedPluginsPatterns == null) {
            this.acceptedPluginsPatterns = WildcardPatterns.convert(this.acceptedPlugins);
        }
        return this.acceptedPluginsPatterns;
    }

    public List<Pattern> getAcceptedPackagesPatterns() {
        if (this.acceptedPackagesPatterns == null) {
            this.acceptedPackagesPatterns = WildcardPatterns.convert(this.acceptedPackages);
        }
        return this.acceptedPackagesPatterns;
    }

    public List<String> getAcceptedPackages() {
        return this.acceptedPackages;
    }

    public void setAcceptedPackages(List<String> acceptedPackages) {
        this.acceptedPackages = acceptedPackages;
        this.acceptedPackagesPatterns = null;
    }

    public List<Pattern> getRequiredPackagesPatterns() {
        if (this.requiredPackagesPatterns == null) {
            this.requiredPackagesPatterns = WildcardPatterns.convert(this.requiredPackages);
        }
        return this.requiredPackagesPatterns;
    }

    public List<String> getRequiredPackages() {
        return this.requiredPackages;
    }

    public void setRequiredPackages(List<String> requiredPackages) {
        this.requiredPackages = requiredPackages;
        this.requiredPackagesPatterns = null;
    }

    public boolean isAcceptOtherPackages() {
        return this.acceptOtherPackages;
    }

    public void setAcceptOtherPackages(boolean acceptOtherPackages) {
        this.acceptOtherPackages = acceptOtherPackages;
    }

    public List<StatusIgnorePattern> getIgnoredPluginMessagesPatterns() {
        if (this.ignoredPatterns == null) {
            this.ignoredPatterns = Lists.newArrayList();
            for (String s : this.getIgnoredStatuses()) {
                StatusIgnorePattern pattern = StatusIgnorePattern.fromString((String)s);
                if (pattern != null) {
                    this.ignoredPatterns.add(pattern);
                    continue;
                }
                Logs.log((Logs.ILogMessage)LogMessages.WARN_INVALID_PATTERN, (Object[])new Object[]{s});
            }
        }
        return this.ignoredPatterns;
    }

    public boolean isAcceptUiFreezes() {
        return this.acceptUiFreezes;
    }

    public void setAcceptUiFreezes(boolean acceptUiFreezes) {
        this.acceptUiFreezes = acceptUiFreezes;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getProblemsZipLastDownloadTimestamp() {
        return this.problemsZipLastDownloadTimestamp;
    }

    public void setProblemsZipLastDownloadTimestamp(long problemsZipLastDownloadTimestamp) {
        this.problemsZipLastDownloadTimestamp = problemsZipLastDownloadTimestamp;
    }

    public List<String> getIgnoredStatuses() {
        return this.ignoredStatuses;
    }

    public void setIgnoredStatuses(List<String> ignoredStatuses) {
        this.ignoredStatuses = ignoredStatuses;
    }
}

