/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.jayes.io.util;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.recommenders.commons.bayesnet.BayesianNetwork;
import org.eclipse.recommenders.commons.bayesnet.Node;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;

public class BayesNetConverter {
    public BayesNet transform(BayesianNetwork network) {
        BayesNet bayesNet = new BayesNet();
        this.initializeNodes(network, bayesNet);
        this.initializeArcs(network, bayesNet);
        this.initializeProbabilities(network, bayesNet);
        return bayesNet;
    }

    private void initializeNodes(BayesianNetwork network, BayesNet bayesNet) {
        Collection<Node> nodes = network.getNodes();
        for (Node node : nodes) {
            BayesNode bayesNode = bayesNet.createNode(node.getIdentifier());
            String[] states = node.getStates();
            bayesNode.addOutcomes(states);
        }
    }

    private void initializeArcs(BayesianNetwork network, BayesNet bayesNet) {
        Collection<Node> nodes = network.getNodes();
        for (Node node : nodes) {
            Node[] parents = node.getParents();
            BayesNode children = bayesNet.getNode(node.getIdentifier());
            LinkedList<BayesNode> bnParents = new LinkedList<BayesNode>();
            int i = 0;
            while (i < parents.length) {
                bnParents.add(bayesNet.getNode(parents[i].getIdentifier()));
                ++i;
            }
            children.setParents(bnParents);
        }
    }

    private void initializeProbabilities(BayesianNetwork network, BayesNet bayesNet) {
        Collection<Node> nodes = network.getNodes();
        for (Node node : nodes) {
            BayesNode bayesNode = bayesNet.getNode(node.getIdentifier());
            bayesNode.setProbabilities(node.getProbabilities());
        }
    }

    public static Function<BayesianNetwork, BayesNet> asFunction() {
        return new Function<BayesianNetwork, BayesNet>(){
            private BayesNetConverter converter = new BayesNetConverter();

            public BayesNet apply(BayesianNetwork network) {
                return this.converter.transform(network);
            }
        };
    }
}

