/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.coordinates.jre;

import com.google.common.base.Optional;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.recommenders.coordinates.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.coordinates.Coordinates;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.DependencyType;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.utils.Versions;

public class AndroidDirectoryNameAdvisor
extends AbstractProjectCoordinateAdvisor {
    private static final String GROUP_ID = "com.google.android";
    private static final String ARTIFACT_ID = "android";
    private static final String ANDROID_TARGET_PREFIX = "android-";
    private static final String[] VERSION_CODES;

    static {
        String[] stringArray = new String[20];
        stringArray[1] = "1.0";
        stringArray[2] = "1.1";
        stringArray[3] = "1.5";
        stringArray[4] = "1.6";
        stringArray[5] = "2.0";
        stringArray[6] = "2.0.1";
        stringArray[7] = "2.1";
        stringArray[8] = "2.2";
        stringArray[9] = "2.3";
        stringArray[10] = "2.3.3";
        stringArray[11] = "3.0";
        stringArray[12] = "3.1";
        stringArray[13] = "3.2";
        stringArray[14] = "4.0";
        stringArray[15] = "4.0.3";
        stringArray[16] = "4.1";
        stringArray[17] = "4.2";
        stringArray[18] = "4.3";
        stringArray[19] = "4.4";
        VERSION_CODES = stringArray;
    }

    @Override
    protected boolean isApplicable(DependencyType type) {
        return type == DependencyType.JAR;
    }

    @Override
    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        File jar = dependencyInfo.getFile();
        if (!"android.jar".equals(jar.getName())) {
            return Optional.absent();
        }
        File directory = jar.getParentFile();
        if (directory == null) {
            return Optional.absent();
        }
        return this.asProjectCoordinate(directory.getName());
    }

    private Optional<ProjectCoordinate> asProjectCoordinate(String target) {
        try {
            int apiVersion = this.extractApiVersion(target);
            if (apiVersion < 1 || apiVersion >= VERSION_CODES.length) {
                return Optional.absent();
            }
            String version = Versions.canonicalizeVersion((String)VERSION_CODES[apiVersion]);
            return Coordinates.tryNewProjectCoordinate(GROUP_ID, ARTIFACT_ID, version);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.absent();
        }
    }

    private int extractApiVersion(String target) {
        if (target.startsWith(ANDROID_TARGET_PREFIX)) {
            return Integer.parseInt(StringUtils.removeStart((String)target, (String)ANDROID_TARGET_PREFIX));
        }
        throw new IllegalArgumentException("Cannot extract API version: " + target);
    }
}

